/*
   StandAlone Compiler used to bootstrap PIP.PRO
   WFC, March 83
   Version for use with Release 2.0.
   March 84
*/

zapify(X) :-   modtofile(X,Y),  see(X),  tell(Y), zap, seen, told.

zap :- repeat, zap_read(Next), zap_do(Next), !.

zap_read(C) :- read(C), !.
zap_read(C) :- write('syntax error'), abort.
zap_do(end_of_file).
zap_do(Clause) :-expand(Clause,E), do(E), !, fail.
zap_do(Clause) :- seen, nl, write('FAILED: '), write(Clause).


do((?-zap([primitive,X,Y,Z,P]))) :- output([primitive,X,Y,Z,P]), !.
do((?-zap([op,X,Y,Z,P]))) :- output([op,X,Y,Z,P]), !.
do((?-zap([visible,X,Y]))) :- output([visible,X,Y]), !.
do((?-zap([updatable,X,Y]))) :- output([updatable,X,Y]), !.
do(Clause) :-
	destclause(Clause,Head,Body),
	c_clause(Head,Body,Code).

destclause((H:-B),H,B) :- !.
destclause(C,C,true).


/* Outputing primitives - with logging */

output(X) :-
	do_output(X), nl,
        telling(F),
	tell(user),
	do_output(X), nl,
	tell(F),
	!.


do_output([]) :- !.
do_output([X|_]) :- var(X), !, write('OUTPUT MUST BE INSTANTIATED'), fail.
do_output([X|Rest]) :-
	!,
	writeq(X), put(32),
	do_output(Rest).
do_output(Atomic) :- write(Atomic), put(32).



modtofile(Module,File) :-
	name(Module,Mchars),
        name('.zap',Ext),
	append(Mchars,Ext,Fchars),
	name(File,Fchars).

append([],L,L).
append([X|L1],L2,[X|L3]) :- append(L1,L2,L3).



/* ZIP Clause Preprocessor */

expand((H:-X),(H:-Z)) :- cb(X,[],Z,[],_), !.
expand(X,X).

cb((A,B),L0,C0,C1,L1) :- !, cb(A,L0,C0,Cn,Ln), cb(B,Ln,Cn,C1,L1).
cb((A;B),L0,[(A1;B1)|Z],Z,L0) :- !, cb(A,[],A1,[],_), cb(B,[],B1,[],_).
cb((A->B),L0,[(A1->B1)|Z],Z,L0) :- !, cb(A,[],A1,[],_), cb(B,[],B1,[],_).
cb(A,L0,C0,C1,L1) :- cg(A,L0,C0,C1,L1).


cg(X,L,[X|Y],Y,L) :- var(X), !.
cg(is(X,Y),L0,C0,C5,L) :- var(X), asschk(X,L0,V), !, c(Y,C0,C1,C1,C2,L0,L), C2 = ['%pushv%'(V), '%inteq%'|C5].
cg(is(X,Y),L0,C0,C5,[[X|X]|L]) :- var(X), !, c(Y,C0,C1,C1,C2,L0,L), C2 = ['%result%'(X)|C5].
cg(is(X,Y),L0,C0,C5,L) :- !, c(X,C0,C1,C2,C3,L0,L1), c(Y,C1,C2,C3,C4,L1,L), C4 = ['%inteq%'|C5].
cg(E,L0,C0,C5,L) :- compop(E,X,Y,Op,_), !, c(X,C0,C1,C2,C3,L0,L1), c(Y,C1,C2,C3,C4,L1,L), C4 = [Op|C5].
cg(G,L,[G|X],X,L).

c(I,E,E,[C|C1],C1,L,L) :- integer(I), !, pushint(I,C).
c(V,E0,E1,['%pushv%'(Z)|C1],C1,L0,L1) :- var(V), !, assoc(V,L0,E0,E1,Z,L1).
c(Exp,E0,E2,C0,C3,L0,L2) :- binop(Exp,A,B,Op,_), !, c(A,E0,E1,C0,C1,L0,L1), c(B,E1,E2,C1,C2,L1,L2), C2 = [Op|C3].
c(Exp,E0,E1,C0,C2,L0,L1) :- unop(Exp,A,Op,_), !, c(A,E0,E1,C0,C1,L0,L1), C1 = [Op|C2].
c(Exp,[is(X,Exp)|Z],Z,['%pushv%'(X)|C],C,L,L).

pushint(I,'%pushb%'(I)) :- I >= 0, I =< 255, !.
pushint(I,'%pushi%'(I)).

/* an association list holds eval'd var pairs */

asschk(V1,[[V|V2]|_],V2) :- V1 == V, !.
asschk(V1,[_|L],V2) :- asschk(V1,L,V2).

assoc(V1,[],['%eval%'(V1,V2)|C],C,V2,[[V1|V2]]) :- !.
assoc(V1,[[Va|Vb]|L],C,C,Vb,[[Va|Vb]|L]) :- V1 == Va, !.
assoc(V1,[X|L],C0,C1,V2,[X|L1]) :- assoc(V1,L,C0,C1,V2,L1).

binop(X+Y,X,Y,'%add%',add).
binop(X-Y,X,Y,'%sub%',sub).
binop(X/Y,X,Y,'%div%',div).
binop(X*Y,X,Y,'%mul%',mul).
binop(X mod Y,X,Y,'%mod%',mod).
binop(X /\ Y,X,Y,'%and%',and).
binop(X \/ Y,X,Y,'%or%',or).
binop(<<(X,Y),X,Y,'%shl%',shl).
binop(>>(X,Y),X,Y,'%shr%',shr).

unop(+X,X,true,_).
unop(-X,X,'%neg%',neg).
unop(\(X),X,'%not%',not).

compop(=:=(X,Y),X,Y,'%inteq%',eq).
compop(=\=(X,Y),X,Y,'%intne%',ne).
compop(X<Y,X,Y,'%intlt%',lt).
compop(X>Y,X,Y,'%intgt%',gt).
compop(X=<Y,X,Y,'%intle%',le).
compop(X>=Y,X,Y,'%intge%',ge).

/* ZIP compiler in Prolog
*/
succ(X,Y) :- Y is X + 1.

c_clause(Head,Body,OptCode) :-
	functor(Head,_,Arity),
	do_var_each(0,Arity,head,outer,Head,VL,VL1),
	do_body_vars(Body,NewBody,last,VL1,[]),
	assign_var_types(VL,0,NumLocals,0,NumTemps),
	actsize(A),		
	LocalOrigin is A+Arity,
	FS is LocalOrigin+NumLocals,
	MaxFS is FS+NumTemps,
	assign_offsets(VL,LocalOrigin,FS),
	c_term(0,Arity,0,Head,head,outer,Code,BodyCode),
	gen_body_code(NewBody,FS,BodyCode),
	conseq(Code,OptCode),
	assemble(Head,MaxFS,OptCode), !.

actsize(8).			  

/* Variable handling tables */

var_bits(head,outer,'$$VAR'(1, _, _, _, _, _, _, _, O, _), I) :- !,
	(   nonvar(O), !	
	;   actsize(A),	
	    O is A+I-1 ).	
var_bits(head,inner,'$$VAR'(_, 1, _, _, _, _, _, _, _, _), _) :- !.
var_bits(body,outer,'$$VAR'(_, _, 1, _, _, _, _, _, _, _), _) :- !.
var_bits(body,inner,'$$VAR'(_, _, _, 1, _, _, _, _, _, _), _) :- !.
var_bits(last,outer,'$$VAR'(_, _, _, _, 1, _, _, _, _, _), _) :- !.
var_bits(last,inner,'$$VAR'(_, _, _, _, _, 1, _, _, _, _), _).

var_index(multiple,V,Value) :- !, arg(7,V,Value).	
var_index(var_type,V,Value) :- !, arg(8,V,Value).
var_index(f_offset,V,Value) :- !, arg(9,V,Value).
var_index(first_fl,V,Value) :-    arg(10,V,Value).


assign_var_type('$$VAR'(_, _, 0, _, 0, _, 0,  void, _, _), 0, 0) :- !.
assign_var_type('$$VAR'(0, 1, 0, 0, 0, 0, 1,  temp, _, _), 0, 1) :- !.
assign_var_type('$$VAR'(0, 0, _, _, _, _, _, b_loc, _, _), 1, 0) :- !.
assign_var_type('$$VAR'(0, 1, _, _, _, _, 1, local, _, _), 1, 0) :- !.
assign_var_type('$$VAR'(1, _, _, _, _, _, 1,   arg, _, _), 0, 0).



do_var_each(N,N,_,_,_,VL,VL) :- !.
do_var_each(I,N,Position,Depth,Term,VL0,VL2) :-
	succ(I,J),
	arg(J,Term,Arg),
	do_var(Position,Depth,Arg,J,VL0,VL1),
	do_var_each(J,N,Position,Depth,Term,VL1,VL2).

do_var(Posn,IorO,V,I,[V|VL],VL) :-  var(V), !, var_bits(Posn,IorO,V,I).
do_var(Posn,IorO,V,I,VL,VL) :- var_bits(Posn,IorO,V,I), !, var_index(multiple,V,1).
do_var(_,_,X,_,VL,VL) :- atomic(X), !.			
do_var(Posn,_,T,_,VL0,VL1) :- functor(T,_,A), do_var_each(0,A,Posn,inner,T,VL0,VL1).

do_body_vars([],[],_,L,L) :- !.
do_body_vars(Var,call(Var),Posn,VL0,VL1) :-
	var(Var), !,
	do_var_each(0,1,Posn,outer,call(Var),VL0,VL1).	
do_body_vars([P|Q],[NewP|NewQ],Posn,VL0,VL2) :- !,		
	do_body_vars(P,NewP,body,VL0,VL1),
	do_body_vars(Q,NewQ,Posn,VL1,VL2).
do_body_vars((P;Q),'%disjunct%'(NewP,NewQ,Vars),Posn,VL0,VL2) :- !,	
	do_body_vars(P,NewP,Posn,VL0,VL1),
	do_body_vars(Q,NewQ,Posn,VL1,VL2),
	real_list(VL0,VL2,Vars).
do_body_vars((P->Q),'%localcut%'(NewP,NewQ,V),Posn,[V|VL0],VL2) :- !,
	V = '$$VAR'(0,1,1,0,0,0,1,local,_,_),	
	do_body_vars(P,NewP,body,VL0,VL1),	
	do_body_vars(Q,NewQ,Posn,VL1,VL2).
do_body_vars(V,call(V),P,VL0,VL1) :- functor(V,'$$VAR',10), !, do_var_each(0,1,Posn,outer,call(V),VL0,Vl1).
do_body_vars(Goal,Goal,Posn,VL0,VL1) :- nonvar(Goal), !, functor(Goal,_,A), do_var_each(0,A,Posn,outer,Goal,VL0,VL1).

	
real_list(VL0,VLn,[]) :- VL0 == VLn, !. 
real_list([Var|VL0],VLn,[Var|List]) :- real_list(VL0,VLn,List).


/* This procedure works on the list of variables which is built by do_vars.
   (using an accumulator for each).  */

assign_var_types([],Locals,Locals,Temps,Temps) :- !.
assign_var_types([V|Z],L0,L2,T0,T2) :-
	assign_var_type(V,L_inc,T_inc),
	L1 is L0 + L_inc,
	T1 is T0 + T_inc,
	assign_var_types(Z,L1,L2,T1,T2).



assign_offsets([],_,_).
assign_offsets([V|Z],LocOff,TempOff) :-
	var_index(var_type,V,Type),			
	assign_offset(Type,V,LocOff,NewLoc,TempOff,NewTemp),
	assign_offsets(Z,NewLoc,NewTemp).
	
assign_offset(local,V,L0,L1,T,T) :- !, succ(L0,L1), var_index(f_offset,V,L0).
assign_offset(b_loc,V,L0,L1,T,T) :- !, succ(L0,L1), var_index(f_offset,V,L0).
assign_offset(temp,V,L,L,T0,T1) :- !, succ(T0,T1), var_index(f_offset,V,T0).
assign_offset(void,V,L,L,T,T) :- var_index(f_offset,V,0), !.
assign_offset(_,_,L,L,T,T).		


/* Body code generation.  FS is the size of frame excluding any
   temporary variables.  */

gen_body_code(true,FS,[return(FS)]) :- !.
% gen_body_code([!],FS,[detunit(FS)]) :- !.
gen_body_code(B,FS,[enter(FS)|BodyCode]) :-
	c_goals(B,FS,last,BodyCode,[exit]).

c_goals([Goal],FS,Posn,Code0,Code1) :- c_goal(Posn,Goal,FS,Code0,Code1).
c_goals([Goal|Z],FS,Posn,Code0,Code3) :- !,
	c_goal(body,Goal,FS,Code0,Code2),
	c_goals(Z,FS,Posn,Code2,Code3).

c_goal(body,Goal,FS,Code0,Code1) :- open_code(Goal,FS,body,Code0,Code1), !.
c_goal(body,Goal,_,Code0,Code1) :- !,
	functor(Goal,F,N),
	c_term(0,N,0,Goal,body,outer,Code0,[call(F,N)|Code1]).
c_goal(last,Goal,FS,Code0,Code1) :- open_code(Goal,FS,last,Code0,Code1), !.
c_goal(last,Goal,_,Code0,Code1) :-
	functor(Goal,F,N),
	c_term(0,N,0,Goal,last,outer,Code0,[depart(F,N)|Code1]).



c_term(N,N,_,_,_,_,L,L) :- !.
c_term(I,N,InPop,Term,Position,Depth,L0,L2) :-
	succ(I,J), arg(J,Term,Arg), L is J-InPop,
	c_arg(Arg,Position,Depth,L,N,L0,L1),
	c_term(J,N,InPop,Term,Position,Depth,L1,L2).

c_arg('$$VAR'(_,_,_,_,_,_,_,Type,Offset,FirstFlag),Position,Depth,_,_,Instr,Z) :- !,
	c_arg_var(Type,Offset,FirstFlag,Position,Depth,Instr,Z).
c_arg([],_,_,_,_,[constnil|Z],Z) :- !.
c_arg(Atom,_,_,_,_,[constant(Atom)|Z],Z) :- atom(Atom), !.
c_arg(Int,_,_,_,_,[immed(Int)|Z],Z) :- integer(Int), 0 =< Int, Int =< 255, !.
c_arg(Int,_,_,_,_,[constant(Int)|Z],Z) :- integer(Int), !.
c_arg(Term,Position,_,N,N,[lastconslist|L0],L1) :-
	functor(Term,'.',2), !,
	c_term(0,2,0,Term,Position,inner,L0,L1).
c_arg(Term,Position,_,N,N,[lastfunctor(Name,Arity)|L0],L1) :- !,
	functor(Term,Name,Arity),
	c_term(0,Arity,0,Term,Position,inner,L0,L1).
c_arg(Term,Position,_,_,_,[conslist|L0],L1) :-
	functor(Term,'.',2), !,
	choose_pop(Position,Pop),
	c_term(0,2,1,Term,Position,inner,L0,[Pop|L1]).
c_arg(Term,Position,_,_,_,[functor(Name,Arity)|L0],L1) :-
	functor(Term,Name,Arity),
	choose_pop(Position,Pop),
	c_term(0,Arity,1,Term,Position,inner,L0,[Pop|L1]).

choose_pop(head,pop) :- !.
choose_pop(_,poparg).


/* Generate instruction for variable */


c_arg_var(void,_,_,_,_,[void|Z],Z) :- !.
c_arg_var(arg,Offset,FirstFlag,head,outer,[void|Z],Z) :- var(FirstFlag), !, FirstFlag=1.
c_arg_var(arg,Offset,_,body,outer,[vararg(Offset)|Z],Z) :- !.
c_arg_var(arg,Offset,_,last,outer,[vararg(Offset)|Z],Z) :- !.
c_arg_var(arg,Offset,_,_,_,[var(Offset)|Z],Z) :- !.
c_arg_var(b_loc,Offset,FirstFlag,body,outer,[firvararg(Offset)|Z],Z) :-
	var(FirstFlag), !,
	FirstFlag = ff(_).	
c_arg_var(b_loc,Offset,FirstFlag,body,inner,[firstvar(Offset)|Z],Z) :-
	var(FirstFlag), !,
	FirstFlag = ff(_).	
c_arg_var(b_loc,Offset,FirstFlag,last,outer,[glofirvar(Offset)|Z],Z) :-
	var(FirstFlag), !,	
	FirstFlag = ff(1).	
c_arg_var(b_loc,Offset,ff(FirstFlag),last,outer,[glovar(Offset)|Z],Z) :-
	var(FirstFlag), !,	
	FirstFlag = 1.
c_arg_var(_,Offset,FirstFlag,_,_,[firstvar(Offset)|Z],Z) :- var(FirstFlag), !, FirstFlag=1.
c_arg_var(_,Offset,_,body,outer,[vararg(Offset)|Z],Z) :- !.
c_arg_var(_,Offset,_,last,outer,[vararg(Offset)|Z],Z) :- !.
c_arg_var(_,Offset,_,_,_,[var(Offset)|Z],Z) :- !.



open_code(true,_,_,C,C) :- !.
open_code(!,FS,_,[cut(FS)|C],C) :- !.
open_code(fail,_,_,[fail|C],C) :- !.
open_code(succ(X,Y),_,BL,C0,C1) :- !, c_term(0,2,0,succ(X,Y),BL,outer,C0,[prosucc|C1]).
open_code(=(X,Y),FS,BL,C0,C1) :- !, c_term(0,2,0,=(X,Y),BL,outer,C0,[proequal|C1]).
open_code(arg(X,Y,Z),FS,BL,C0,C1) :- !, c_term(0,3,0,arg(X,Y,Z),BL,outer,C0,[proarg|C1]).
open_code(functor(X,Y,Z),FS,BL,C0,C1) :- !, c_term(0,3,0,functor(X,Y,Z),BL,outer,C0,[profunctor|C1]).
open_code('%pushb%'(I),_,_,[pushb(I)|Z],Z) :- !.
open_code('%pushi%'(I),_,_,[pushi(I)|Z],Z) :- !.
open_code('%result%'(V),_,_,[firstresult(Offset)|Z],Z) :-
	var_index(first_fl,V,FF), var(FF), !, FF = 1,
	var_index(f_offset,V,Offset).
open_code('%eval%'('$$VAR'(_,_,_,_,_,_,_,T1,O1,FF1),'$$VAR'(_,_,_,_,_,_,_,T2,O2,FF2)),_,_,[eval(O1,O2)|Z],Z) :-
	c_arg_var(T1,O1,FF1,body,outer,_,_),
	c_arg_var(T2,O2,FF2,body,outer,_,_), !.
open_code('%disjunct%'('%localcut%'(P,Q,V),R,Vars),FS,BL,[savel(V_offset)|C0],C5) :- !,
	var_index(f_offset,V,V_offset),
	init_vars(Vars,C0,[disjunct(Offset1)|C1]),
	c_goals(P,FS,body,C1,[localcut(V_offset)|C2]),
	c_goals(Q,FS,BL,C2,[continue(Offset2),label(Offset1),endor|C4]),
	c_goals(R,FS,BL,C4,[label(Offset2)|C5]).
open_code('%disjunct%'(P,Q,Vars),FS,BL,C0,C4) :- !,		
	init_vars(Vars,C0,[disjunct(Offset1)|C1]),
	c_goals(P,FS,BL,C1,[continue(Offset2),label(Offset1),endor|C3]),
	c_goals(Q,FS,BL,C3,[label(Offset2)|C4]).
open_code('%localcut%'(P,Q,V),FS,BL,[savel(V_offset)|C0],C2) :- !,
	var_index(f_offset,V,V_offset),
	c_goals(P,FS,body,C0,[localcut(V_offset)|C1]),
	c_goals(Q,FS,BL,C1,C2).
open_code(put([X]),FS,BL,C0,C1) :- !, c_goal(BL,put(X),FS,C0,C1).
open_code(Goal,_,_,[ProInst|C],C) :-
	var_instr(Goal,V,ProInst,Offset), !, functor(V,'$$VAR',10),
	var_index(first_fl,V,Fflag), nonvar(Fflag),
	var_index(f_offset,V,Offset), Offset =\= 0.
open_code(F,_,_,[Op|Z],Z) :- binop(_,_,_,F,Op), !.
open_code(F,_,_,[Op|Z],Z) :- unop(_,_,F,Op), !.
open_code(F,_,_,[Op|Z],Z) :- compop(_,_,_,F,Op), !.



init_vars([],C,C).
init_vars(['$$VAR'(_,_,_,_,_,_,_,b_loc,Offset,ff(_))|Z],[initvar(Offset)|C0],C1) :- !,
	init_vars(Z,C0,C1).
init_vars([_|Z],C0,C1) :- init_vars(Z,C0,C1).


instr(pad(X),X,0) :- !.
instr(label(_),0,0) :- !.
instr(constant(_),2,11) :- !.
instr(immed(_),2,11) :- !.
instr(constnil,1,35) :- !.
instr(functor(_,_),3,9) :- !.
instr(lastfunctor(_,_),3,10) :- !.
instr(conslist,1,33) :- !.
instr(lastconslist,1,34) :- !.
instr(void,1,7) :- !.
instr(voidn(_),2,32) :- !.
instr(firstvar(_),2,5) :- !.
instr(glofirvar(_),2,29) :- !.
instr(glovar(_),2,30) :- !.
instr(var(_),2,4) :- !.
instr(vararg(_),2,2) :- !.
instr(firvararg(_),2,40) :- !.
instr(pop,1,1) :- !.
instr(poparg,1,3) :- !.
instr(depart(_,_),3,16) :- !.
instr(call(_,_),2,17) :- !.  % Note final length is 2, but compiler token has two arguments
instr(callx(_),2,26) :- !.
instr(return(_),2,13) :- !.
instr(enter(_),2,12) :- !.
instr(exit,1,25) :- !.
instr(cut(_),2,15) :- !.
instr(fail,1,19) :- !.
instr(savel(_),2,14) :- !.
instr(disjunct(_),2,18) :- !.
instr(continue(_),2,8) :- !.
instr(endor,1,28) :- !.
instr(localcut(_),2,31) :- !.
instr(initvar(_),2,63) :- !.
instr(provar(_),2,20) :- !.
instr(prononvar(_),2,21) :- !.
instr(proatom(_),2,22) :- !.
instr(proint(_),2,23) :- !.
instr(proatomic(_),2,39) :- !.
instr(prosucc,1,24) :- !.
instr(proarg,1,36) :- !.
instr(profunctor,1,37) :- !.
instr(proequal,1,38) :- !.
instr(eval(_,_),3,41) :- !.
instr(pushb(_),2,42) :- !.
instr(pushi(_),2,43) :- !.
instr(pushv(_),2,44) :- !.
instr(firstresult(_),2,6) :- !.
instr(result(_),2,45) :- !.
instr(add,1,46) :- !.
instr(sub,1,47) :- !.
instr(mul,1,48) :- !.
instr(div,1,49) :- !.
instr(mod,1,50) :- !.
instr(shr,1,51) :- !.
instr(shl,1,52) :- !.
instr(and,1,53) :- !.
instr(or,1,54) :- !.
instr(not,1,55) :- !.
instr(neg,1,56) :- !.
instr(eq,1,57) :- !.
instr(ne,1,58) :- !.
instr(lt,1,59) :- !.
instr(le,1,60) :- !.
instr(gt,1,61) :- !.
instr(ge,1,62) :- !.
instr(Op,_,_) :- write('Unknown op '), write(Op).

var_instr(call(V),V,callx(N),N).
var_instr(var(V),V,provar(N),N).	
var_instr(atom(V),V,proatom(N),N).
var_instr(integer(V),V,proint(N),N).
var_instr(nonvar(V),V,prononvar(N),N).
var_instr(atomic(V),V,proatomic(N),N).
var_instr('%pushv%'(V),V,pushv(N),N).
var_instr('%result%'(V),V,result(N),N).

gen_key(Head,Key) :-
	arg(1,Head,FirstArg), !,
	princ_func(FirstArg,Key).
gen_key(_,undef-var).

princ_func('$$VAR'(_,_,_,_,_,_,_,_,_,_),undef-var) :- !.
princ_func(X,X) :- (atom(X); integer(X)), !.
princ_func(X,undef-var) :- atomic(X), !.	
princ_func(X,F/N) :- functor(X,F,N).

/* Optimise the generated code.
   First stage is replacing sequences of VOID instructions by VOIDN.	     */

conseq([voidn(M),void|C0], C1):- !, N is M+1, conseq([voidn(N)|C0], C1).
conseq([void,void|C0],C1):- !, conseq([voidn(2)|C0],C1).
conseq([I|C0],[I|C1]) :- !, conseq(C0,C1).
conseq([], []).


/* ZIP Assembler */

/* instantiate label(X) addresses */

labadd([],_) :- !.
labadd([label(X)|T],X) :- !, labadd(T,X).
labadd([H|T],N) :- instr(H,L,_), N1 is N+L, labadd(T,N1).

/* ORION ONLY:  insert pad(X) to prevent straddle word boundary */

strad([],_,[]) :- !.
strad([H|T],P,[H|Z]) :- 
	instr(H,I,_), P1 is P + I, stradx(P1,P2), !,
	strad(T,P2,Z).
strad([H|T],P,[pad(N),H|Z]) :- !,
	instr(H,I,_), N is 4-P, strad(T,I,Z).

stradx(0,0).
stradx(1,1).
stradx(2,2).
stradx(3,3).
stradx(4,0).
/* stradx(X,_) fails for X > 4 */


assemble(Head,FS,C) :-
	strad(C,0,Code),      %  ORION ONLY
	labadd(Code,0),
	functor(Head,F,A),
	output([clause,F,A,FS]),
	output_key(Head),
	emitloop(Code,XR,0),
	output(xrtable),
	writexr(XR),
	output(endxrtable),
	output(endclause),
	output(';').

output_key(X) :- functor(X,_,A), A > 0, !, arg(1,X,ARG), g_key(ARG).
output_key(_).

g_key('$$VAR'(_,_,_,_,_,_,_,_,_,_)) :- !.
g_key(X) :- integer(X), !, output([keyi,X]).
g_key(X) :- atom(X), !, output([keya,X]).
g_key(X) :- functor(X,F,A), !, output([keyf,F,A]).

emitloop([],X,_) :- !.
emitloop([label(_)|T],XR,P) :- !, emitloop(T,XR,P).
emitloop([disjunct(L)|T],XR,P) :- !,
	P1 is P + 2, D is L - P1,
	output([disjunct,D]),
	emitloop(T,XR,P1).
emitloop([continue(L)|T],XR,P) :- !,
	P1 is P + 2, D is L - P1,
	output([continue,D]),
	emitloop(T,XR,P1).
emitloop([H|T],XR,P) :-
	form_entry(H,E,F,N),
	!,
	add_xr(XR,E,0,N),
	output(F),
	instr(H,I,_), P1 is P + I,
	emitloop(T,XR,P1).
emitloop([H|T],XR,P) :-
	!,
	H =.. F,
	output(F),
	instr(H,I,_), P1 is P + I,
	emitloop(T,XR,P1).

form_entry(constant(A),a(A),[constant,N],N) :- atom(A), !.
form_entry(constant(I),i(I),[constant,N],N) :- integer(I), !.
form_entry(functor(F,A),f(F,A),[functor,N,A],N) :- !.
form_entry(lastfunctor(F,A),f(F,A),[lastfunctor,N,A],N) :- !.
form_entry(depart(F,A),p(F,A),[depart,N,A],N) :- !.
form_entry(call(F,A),p(F,A),[call,N],N) :- !.
form_entry(pushi(I),i(I),[pushi,N],N) :- !.

add_xr(Last,Entry,N,N) :- var(Last), !, Last = [Entry|_].
add_xr([Entry|_],Entry,A,A) :- !.
add_xr([_|Z],Entry,A,N) :- succ(A,A1), add_xr(Z,Entry,A1,N).

writexr(Last) :- var(Last), !.
writexr([H|T]) :- H =.. F, output(F), writexr(T).
