/* Copyright (C) 1992 Damian Chu */

/*
 * sample agent core as used in CKBS paper
 * Damian Chu, Imperial College - Aug. 92
 *
 *	Initialisation
 */

init_agent(Name) :-
   load(Name),
   concat('Agent ', Name, Title),
   window_label(Title),
   knowledge:my_name(MyName),
   mbx_create(Id),
   mbx_bind(Id, MyName), !,
   writeseqnl(user, ['initialised agent :', MyName]),
   fork(read_messages(Id)).
init_agent(Name) :-
   writeseqnl(user, ['failed to initialise agent :', Name]).

read_messages(Id) :-
   mbx_recv(Id, Msg),
   writeseqnl(user, ['MESSAGE RECEIVED :', Msg]),
   communicator:Msg,    /* pass all incoming messages to ... */
   read_messages(Id).   /* the communicator and loop again   */

solve(G) :- monitor:solve(G).




% start Logic & Objects System
?- ensure_loaded(lo).

% load interface to mailboxes
?- ensure_loaded(mailbox).
?- write(user, '\nName of machine running mailbox server ? '),
   flush,
   read(Machine),
   mbx_init(Machine,mbx1).

% load agent demo
?- load(core_agent).
