/*
	The old benchmarking favourite !
	To time naive reverse for 500 elements, do

		| ?- bench(500).
 */

% harness to perform timing
bench(N) :-
  genlist(N,L),
  statistics(runtime, [T1,_]),
  nrev(L,R),
  statistics(runtime, [T2,_]),
  write(R), nl,
  write('Time taken = '),
  T is (T2 - T1),
  write(T),
  write(' millisecond(s).'), nl.

% generate a list of length N
genlist(0,[]) :- !.
genlist(N,[N|R]) :-
  M is N - 1,
  genlist(M,R).

% naive reverse
nrev([],[]).
nrev([F|R],L) :-
  nrev(R,L1),
  app(L1,[F],L).

% defining our own append
app([],L,L).
app([F|R],T,[F|L]) :-
  app(R,T,L).
