/*
 * This program demonstrates the use of multiple threads which execute
 * concurrently.  Note that the program appears to terminate very
 * quickly because it does not wait for the forked threads to finish.
 *
 * To run it, call test(N,D) with different values for N and D. e.g.
 *
 *	| ?- test(30, 100).
 *
 */
test(N, Delay) :-
	integer(N), N > 0,
	integer(Delay), Delay > 0,
	pipe(In, Out),
	fork(producer(N, In, Delay)),
	fork(consumer(Out)),
	write('Producer and consumer threads have been forked\n\c
	       They will continue to run in the background.\n').

/*
 * Writes out the first N integers in descending order to a pipe.
 * A delay was introduced because the timeslice is too big for
 * this example.
 */
producer(0, Pipe, _) :- !,
	close(Pipe).
producer(N, Pipe, Delay) :-
	writeseqnl([producing, N]),
	write_pipe(Pipe, N),
	M is N-1,
	delay(Delay),
	producer(M, Pipe, Delay).

/*
 * reads integers from a pipe
 */
consumer(Pipe) :-
	read_pipe(Pipe, N),
	N \== end_of_file, !,
	writeseqnl(['		', consuming, N]),
	consumer(Pipe).
consumer(Pipe) :-
	close(Pipe).

/*
 * just a time waster
 */
delay(0) :- !.
delay(N) :-
	M is N-1,
	delay(M).

?- write('\n\nCall test(N,D) with different values for N and D. e.g.\n\
	| ?- test(30, 100).\n\n').
