/*
**	This file shows how ICP ][ can be used to connect to external programs.
**	It allows for the sending of electronic mail by directly establishing
**	connections with the Unix sendmail daemon.
**
**	To use the program, type the command
**		mail.
**	at the prompt. You will be requested for the name of the recipient,
**	the subject and for the text to be sent.
*/

mail_server(MailServer) :-
	tcp_currenthost(MailServer, _).
% If your machine does not run sendmail, comment out the above
% definition of mail_server/1 and uncomment the next line, specifying
% the name of a machine which does.
% mail_server(NAME_GOES_HERE).

mail :-
	establish_connection(Socket),
	/********* send data **********/
	mail_data(Socket),
	tcp_send(Socket, '.\n', raw),
		print_response(Socket),
	tcp_send(Socket, 'QUIT\n', raw),
		print_response(Socket),
	tcp_close(Socket).

establish_connection(Socket) :-
	mail_server(MailServer),
	tcp_currenthost(Host, _),
	tcp_getport(mail, _, MailPort),
	sender(Sender),
	recipient(Recipient),
	subject(Subject),
	/********* establish connection **********/
	tcp_client(MailPort, MailServer, Socket),
		print_response(Socket),
	tcp_send(Socket, 'HELO ', raw),
	tcp_send(Socket, Host, raw),
	tcp_send(Socket, '\n', raw),
		print_response(Socket),
	tcp_send(Socket, 'MAIL From:<', raw),
	tcp_send(Socket, Sender, raw),
	tcp_send(Socket, '>\n', raw),
		print_response(Socket),
	tcp_send(Socket, 'RCPT To:<', raw),
	tcp_send(Socket, Recipient, raw),
	tcp_send(Socket, '>\n', raw),
		print_response(Socket),
	tcp_send(Socket, 'DATA\n', raw),
		print_response(Socket),
	/********* send header **********/
	tcp_send(Socket, 'To: ', raw),
	tcp_send(Socket, Recipient, raw),
	tcp_send(Socket, '\nSubject: ', raw),
	tcp_send(Socket, Subject, raw),
	tcp_send(Socket, '\n\n', raw).

mail_data(Socket) :-
	write('Next line> '), flush,
	read_string(Line),
	not Line = '.',
	tcp_send(Socket, Line, raw),
	tcp_send(Socket, '\n', raw), !,
	mail_data(Socket).
mail_data(Socket) :-
	tcp_send(Socket, 'end of message from ICP\n', raw).

sender(Sender) :- getenv('USER', Sender).

recipient(Recipient) :-
	write('Recipient> '), flush,
	read_string(Recipient).

subject(Subject) :-
	write('Subject> '), flush,
	read_string(Subject1),
	pname(Subject1, Subject).

read_string(S) :-
	get0(C),
	read_chars(C, L),
	(   L == [] ->
		S = ''
	;   atom_chars(S, L)
	).

read_chars(0'\n, []) :- !.
read_chars(0'\^Z, [0'.]) :- !.
read_chars(C, [C|T]) :-
	get0(C1),
	read_chars(C1, T).

print_response(Socket) :-
	tcp_recv(Socket, Response, raw, block),
	write(Response).

?- ensure_loaded(tcp),
   write('\nTo start, type the command\n\t \033[1mmail.\033[0m\n\n').
