port_machine(Port, Machine) :-
	tcp_getport(icprolog, _, Port),
	tcp_currenthost(_, Machine).

data_list(1000, 100).

/****************************** server ******************************/
server :-
	port_machine(Port, _),
	tcp_open(connection, Socket),
	tcp_bind(Socket, Port),
	tcp_listen(Socket),
	server_loop(ok, Socket).

server_loop(stop, Socket) :- !, tcp_close(Socket).
server_loop(_, Socket) :-
	tcp_accept(Socket, NewSocket, NewPort, Machine),
	writenl(tcp_accept(Socket, NewSocket, NewPort, Machine)),
	statistics(runtime, [_, _]),
	process_request(ok, NewSocket, Term, T),
	writeseqnl([time,is,T]),
	server_loop(Term, Socket).

process_request(stop, Socket, stop, T) :- !,
	statistics(runtime, [_, T]),
	tcp_close(Socket).
process_request(end, Socket, end, T) :- !,
	statistics(runtime, [_, T]),
	tcp_close(Socket).
process_request(_, Socket, Final, Time) :-
	tcp_recv(Socket, Term),
	process_request(Term, Socket, Final, Time).

/****************************** client ******************************/
client :-
	port_machine(Port, Machine),
	tcp_open(connection, Socket),
	tcp_connect(Socket, Port, Machine),
	data_list(Length, Times),
	make_list(Length, List),
	writeseqnl(['sending integer list of length', Length, Times, times]),
	statistics(runtime, [_, _]),
	client_loop(Times, List, Socket, T),
	writeseqnl([time,is,T]).

client_loop(0, _, Socket, Time) :- !,
	statistics(runtime, [_, Time]),
	tcp_send(Socket, stop),
	tcp_close(Socket).
client_loop(N, Data, Socket, Time) :-
	tcp_send(Socket, Data),
	N1 is N - 1,
	client_loop(N1, Data, Socket, Time).

make_list(0, []) :- !.
make_list(N, [N|List]) :-
	N1 is N - 1,
	make_list(N1, List).

?- ensure_loaded(tcp).
