/*
	Harness for performing single parameter benchmarks.  The
	predicate test/1 is user-defined.  This predicate is executed
	N times and the timing result is adjusted to allow for the loop
	iteration.

	example: to get a timing for running foo(X) N times, we can
	rename foo/1 as test/1 and run

		| ?- timer(N, X).
 */

timer(N, Term) :-
	time(T3),
	timeloop(N, _),
	time(T4),
	Loop is T4 - T3,
	time(T1),
	do_it(N, Term),
	time(T2),
	write(user_error, 'Time taken = '),
	T is (T2 - T1 - Loop) / 1000,
	format(user_error, '~3f',T),
	write(user_error, ' second(s).\n').

timeloop(0, _) :- !.
timeloop(N, Term) :-
	M is N -- 1,
	timeloop(M, Term).

do_it(0, _) :- !.
do_it(N, Term) :-
	test(Term), !,
	M is N -- 1,
	do_it(M, Term).
