/*
    This is a simple program to illustrate the use of multiple threads.
    The call
  
  		loop(hello, 30)
  
     will write `hello' to the current output stream 30 times.  We can
     set up two such threads running concurrently as follows :
  
		! ?- fork(loop(hello, 30)), loop(bye, 30).

     The fork/1 call succeeds as soon as the new thread is created, it
     does not wait for the goal to finish.

     Note that a delay has been inserted in each iteration of the loop.
     By adjusting the length of the delay, you can vary the number of
     iterations executed during each timeslice.  Try changing the delay
     value to 10 and to 2000.
 */

% write out a term N times
loop(_, 0) :- !.
loop(Term, N) :-
	write(Term), nl,
	M is N - 1,
	delay(500),
	loop(Term, M).

% a time-waster !
delay(0) :- !.
delay(N) :- M is N - 1, delay(M).
