#
# install the IC-Prolog services into /etc/services
#
$services = 'icp-services';
$tmp = "/etc/delete_me_$$";

sub endit {
	close TMP;
	unlink $tmp;
	die @_;
}

open (TMP, ">$tmp") || die "Cannot open $tmp: $!";
open (SERVICES, $services) || &endit("Cannot find $services: $!");

while (<SERVICES>) {
	next unless /^[^#]/;
	chop; split;
	$services{$_[0]} = $_[1];
	$numeric{$_[1]} = 1;
}
close SERVICES;

open(ETC, "/etc/services") || &endit("Cannot open /etc/services: $!");
while(<ETC>) {
	/^#/ && do {
		print TMP $_;
		next;
	};
	$line = $_;
	chop; split;
	if (defined $services{$_[0]}) {
		print STDERR "$services{$_[0]} already defined, commenting out.\n";
		print TMP "#$line";
		next;
	}
	if (defined $numeric{$_[1]}) {
		print STDERR "PORT \"$_[1]\" ALREADY IN USE!!! - ABORTING.\n";
		&endit("Help!");
	}
	print TMP $line;
}
close ETC;
close TMP;
system("cat $services >> $tmp");
if (!rename("/etc/services", "/etc/services.preICP")) {
	&endit("Cannot backup old services file: $!\n");
}
if (!rename($tmp, "/etc/services")) {
	rename("/etc/services.preICP", "/etc/services");
	&endit("Cannot install new services file: $!\n");
}
exit 0;
