/*****************************************************************************
LOGIC & OBJECTS ------------- IC PROLOG ][ version

written by F.G.McCabe (fgm@doc.ic.ac.uk)
modified for IC PROLOG ][ by Z.Bobolakis (zb@doc.ic.ac.uk)
last modified: 25 Jan 1993

Logic Programming Section
Dept. of Computing
Imperial College
London
******************************************************************************/


gnu_analyze_body_hook(B, Pos, NB, Stream) :-
        no_of_clauses(B, 0, N),
        cursor(Stream, AfterPos),
        cursor(Stream, Pos),
        skip_label,
        second_pass(N, LoPos, Stream),
        build_body(LoPos, B, NB),
        cursor(Stream, AfterPos).


no_of_clauses('. '(_,Clauses), CN, N) :-
        !,
        NN is CN+1,
        no_of_clauses(Clauses, NN, N).
no_of_clauses((_'. '), CN, N) :-
        !,
        N is CN+1.
no_of_clauses((_..Clauses), CN, N) :-
        !,
        NN is CN+1,
        no_of_clauses(Clauses, NN, N).
no_of_clauses(_, CN, N) :-
        !,
        N is CN+1.

skip_label :- skip(58), skip(123).

second_pass(1, [P], Stream) :-
        !,
        get(_),
        cursor(Stream, P1),
        P is P1-1.
second_pass(N, [P|Ps], Stream) :-
        get(_),
        cursor(Stream, P1),
        P is P1-1,
        cursor(Stream, P),
        read(_),
        N1 is N-1,
        second_pass(N1, Ps, Stream).

build_body([P], (Cl'. '), [Cl-P]) :- !.
build_body([P], Cl, [Cl-P]) :- !.
build_body([P|Ps], '. '(Cl,Clauses), [Cl-P|B]) :-
        !,
        build_body(Ps, Clauses, B).
build_body([P|Ps], (Cl..Clauses), [Cl-P|B]) :-
        build_body(Ps, Clauses, B).





gnutracehook('@w'(File,Char,_)) :- !,
  write(''),
  concat(File,':',S2),
  concat(S2,Char,S3),
  concat(S3,':',S),
  write(S),
  nl.
gnutracehook('@x'(File,Char,_,_)) :- !,
  write(''),
  concat(File,':',S2),
  concat(S2,Char,S3),
  concat(S3,':',S),
  write(S),
  nl.
gnutracehook(_).

