/*****************************************************************************
LOGIC & OBJECTS ------------- IC PROLOG ][ version

written by F.G.McCabe (fgm@doc.ic.ac.uk)
modified for IC PROLOG ][ by Z.Bobolakis (zb@doc.ic.ac.uk)
last modified: 25 Jan 1993

Logic Programming Section
Dept. of Computing
Imperial College
London
******************************************************************************/




% L&O File

%
% conc - low-level implementation
%
conc(List,Atom):-
  current_output(O),
  open_ram('',write,S),
  set_output(S),
  conc_s(List),
  ram_const(S,A),
  set_output(O),
  A = Atom.  
conc_s([]).
conc_s([T|L]):-
  write(T),
  conc_s(L).


%
%percentf is true if a symbol is a percentf (not exactly though)
%
perCentF(Pr):-
  '$ pred'(Pr,_,system,static).




% nearest integer, rather than truncate towards zero
nint(A,B):-
  'lt%f'(A,0),!,
  'fadd%f'(A,-0.5,A1),
  'ceil%f'(A1,B).
nint(A,B):-
  'fadd%f'(A,0.5,A1),
  'floor%f'(A1,B).



% integer part
fint(A,B) :- 
  'lt%f'(A,0),!,
  'ceil%f'(A,B).
fint(A,B) :-
  'floor%f'(A,B).


min(X,Y,Z):- X=<Y, !, Z=X.
min(_,Y,Y).



% the primitive defined predicates
primitive_pred(fail,0).
primitive_pred(true,0).
primitive_pred(repeat,0).
primitive_pred(var,1).
primitive_pred(nonvar,1).
primitive_pred(atom,1).
primitive_pred(atomic,1).
primitive_pred(integer,1).
primitive_pred(number,1).
primitive_pred(float,1).
primitive_pred(compound,1).
primitive_pred(arg,3).
primitive_pred(functor,3).
primitive_pred(=..,2).
primitive_pred(varsin,2).
primitive_pred(numbervars,2).
primitive_pred(=,2).
primitive_pred(\=,2).
primitive_pred(==,2).
primitive_pred(\==,2).
primitive_pred(unify,2).
primitive_pred(compare,3).
primitive_pred(<,2).
primitive_pred(>,2).
primitive_pred(=<,2).
primitive_pred(>=,2).
primitive_pred(@>,2).
primitive_pred(@<,2).
primitive_pred(@>=,2).
primitive_pred(@=<,2).
primitive_pred(mem,3).
primitive_pred(sort,2).
primitive_pred(keysort,2).
primitive_pred(append,3).
primitive_pred(on,2).
primitive_pred(length,2).
primitive_pred(reverse,2).
primitive_pred(stringof,2).
primitive_pred(charof,2).
primitive_pred(name,2).
primitive_pred(concat,3).
primitive_pred(gensym,2).
primitive_pred(genint,2).
primitive_pred(pname,2).
primitive_pred(&:,2).
primitive_pred(\:,2).
primitive_pred(map_cast,3).
primitive_pred(consult,1).
primitive_pred(def,1).
primitive_pred(abort,0).
primitive_pred(halt,0).
primitive_pred((spy),1).
primitive_pred((nospy),1).
primitive_pred(op,3).
primitive_pred(current_op,3).
primitive_pred(write,1).
primitive_pred(writeq,1).
primitive_pred(writeqnl,1).
primitive_pred(writenl,1).
primitive_pred(writeseq,1).
primitive_pred(writeseqnl,1).
primitive_pred(writeqseq,1).
primitive_pred(writeqseqnl,1).
primitive_pred(write,2).
primitive_pred(writeq,2).
primitive_pred(writeqnl,2).
primitive_pred(writenl,2).
primitive_pred(writeseq,2).
primitive_pred(writeseqnl,2).
primitive_pred(writeqseq,2).
primitive_pred(writeqseqnl,2).
primitive_pred(write,3).
primitive_pred(writeq,3).
primitive_pred(nl,1).
primitive_pred(nl,0).
primitive_pred(get_prop,3).
primitive_pred(set_prop,3).
primitive_pred(del_prop,2).
primitive_pred(get_props,2).
primitive_pred(get_cons,2).


% The standard primitive functions

% primitive_fun((<<), 2).
primitive_fun((>>), 2).
primitive_fun(irand, 0).
primitive_fun(irand, 1).
primitive_fun(mem,2).
primitive_fun(which, 2).
primitive_fun(gensym,1).
primitive_fun(genint,1).
primitive_fun(charof,1).
primitive_fun(stringof,1).
primitive_fun(concat,2).
primitive_fun(name,1).
primitive_fun(pname,1).
primitive_fun(length,1).
primitive_fun(sign, 1).
primitive_fun(nint, 1).
primitive_fun((-),1).
primitive_fun(&^,2).
primitive_fun(max,2).
primitive_fun(min,2).
primitive_fun(acc_cast,4).
primitive_fun(pi, 0).
primitive_fun(radians,1).
primitive_fun(degrees,1).


% specially compiled functions ...
percentf((+), 2, 'ADD%F').          % addition (integer or fp)
percentf((-), 2, 'SUB%F').          %
percentf((*), 2, 'MUL%F').          %
percentf((/), 2, 'DIV%F').          %
percentf((mod), 2, 'REM%F').        %
percentf(\, 1, 'NOTB%F').           % bw negation
percentf((/\), 2, 'ANDB%F').        % bw and
percentf((\/), 2, 'ORB%F').         % bw or 
percentf((++), 2, 'ADDB%F').        % integer addition
percentf((--), 2, 'SUBB%F').        %
percentf((**), 2, 'MULB%F').        %
percentf((//), 2, 'DIVB%F').        %
percentf(sqrt, 1, 'SQRT%F').        % square root
percentf(abs, 1, 'ABS%F').          % absolute value
percentf(int, 1, 'FINT').           % integer part
percentf(ln, 1, 'LN%F').            % logarithm (base e)
percentf(pwr, 2, 'PWR%F').          % power
percentf(^, 2, 'PWR%F').            % power
percentf(sin, 1, 'SIN%F').          %
percentf(cos, 1, 'COS%F').          %
percentf(tan, 1, 'TAN%F').          %
percentf(atan, 1, 'ATAN%F').        %
percentf(exp, 1, 'EXP%F').          %




% translate MacProlog notation to ICP][ notation
'ADD%F'(A, B, C):-'fadd%f'(A, B, C).   % addition (integer or fp)
'SUB%F'(A, B, C):-'fsub%f'(A, B, C).   %
'MUL%F'(A, B, C):-'fmul%f'(A, B, C).   %
'DIV%F'(A, B, C):-'fdiv%f'(A, B, C).   %
'REM%F'(A, B, C):-'mod%f'(A, B, C).    % remainder
'NOTB%F'(A, B):- B is \A.              % bw negation
'ANDB%F'(A, B, C):- C is A/\B.         % bw and
'ORB%F'(A, B, C):- C is A\/B.          % bw or
'ADDB%F'(A, B, C):-'add%f'(A, B, C).   % integer addition
'SUBB%F'(A, B, C):-'sub%f'(A, B, C).   %
'MULB%F'(A, B, C):-'mul%f'(A, B, C).   %
'DIVB%F'(A, B, C):-'div%f'(A, B, C).   %
'SQRT%F'(A, B):-'sqrt%f'(A, B).        % square root
'ABS%F'(A, B):-'abs%f'(A, B).          % absolute value
'FINT'(A, B):- fint(A, B).             % integer part
'LN%F'(A, B):-'log%f'(A, B).           % logarithm (base e)
'PWR%F'(A, B, C):-'pow%f'(A, B, C).    % Bth power of A
'SIN%F'(A, B):-'sin%f'(A, B).          %
'COS%F'(A, B):-'cos%f'(A, B).          %
'TAN%F'(A, B):-'tan%f'(A, B).          %
'ATAN%F'(A, B):-'atan%f'(A, B).        %
'EXP%F'(A, B):-'exp%f'(A, B).          % exponential (base e)

