/* Copyright (C) 1992 Imperial College */
/***************************************************/
/*             Arithmetical Primitives             */
/***************************************************/

'$ compile_expr'(Term, X, Vars, LI, LO, VI, VO) :-
        'tpl%f'(Term), !,
        '$comp_expr$'(Term, X, Vars, LI, LO, VI, VO).
'$ compile_expr'(X, X, _, L, L, V, V) :- 
        number(X), !.
'$ compile_expr'(X, X, Vars, L, L, V, [X|V]) :-
        'atom%f'(X),
        on(X, Vars), !.
'$ compile_expr'(pi, X, _, ['pi%f'(X)|L], L, V, V) :- !.
'$ compile_expr'(rand, X, _, ['rand%f'(X)|L], L, V, V) :- !.
'$ compile_expr'([X],X, _, L, L, V, V) :- !.
'$ compile_expr'(Y,_, _, L, L, _, _) :-
        writeseqnl(user_error, ['\nERROR: invalid arithmetic expression :', Y]),
        fail.

'$comp_expr$'(-N, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['fsub%f'(0, NN, X)|LO], VI, VO).
'$comp_expr$'(N+1, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['increment%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N+M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['fadd%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N++1, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['increment%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N++M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['add%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N-1, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['decrement%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N-M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['fsub%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N--1, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['decrement%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N--M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['sub%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N*M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['fmul%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N**M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['mul%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N/M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['fdiv%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N//M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['div%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N mod M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['mod%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'((N<<M), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['lshift%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N>>M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['rshift%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(\N, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['not%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N/\M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['and%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(N\/M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['or%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(int(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['int%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(sin(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['sin%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(cos(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['cos%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(tan(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['tan%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(asin(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['asin%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(acos(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['acos%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(atan(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['atan%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(atan2(N,M), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['atan2%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(sinh(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['sinh%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(cosh(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['cosh%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(tanh(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['tanh%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(exp(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['exp%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(log(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['log%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(log10(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['log10%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(sqrt(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['sqrt%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(N^M, X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['pow%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(pow(N,M), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, L, VI, V1),
        '$ compile_expr'(M, MM, Vars, L, ['pow%f'(NN, MM, X)|LO], V1, VO).
'$comp_expr$'(abs(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['abs%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(sign(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['sign%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(ceil(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['ceil%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(floor(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['floor%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(deg2rad(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['deg2rad%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(rad2deg(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['rad2deg%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(float(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['ar_float%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(integer(N), X, Vars, LI, LO, VI, VO) :- !,
        '$ compile_expr'(N, NN, Vars, LI, ['ar_int%f'(NN, X)|LO], VI, VO).
'$comp_expr$'(Y,_, _, L, L, _, _) :-
        writeseqnl(user_error, ['\nERROR: invalid arithmetic expression :', Y]),
        fail.

'$ arith_err'(is(X,Exp)) :- '$ primcatch'('?is?'(Exp,X), is(X,Exp)).
