/* Copyright (C) 1992 Imperial College */
'$ boot' :-
  '$fastload$'('loader.icp'),		% MUST be first file loaded
  '$fastload$'('operators.icp'),
  '$fastload$'('primitives.icp'),
  '$fastload$'('control.icp'),
  '$fastload$'('syserror.icp'),
  '$fastload$'('predicates.icp'),
  '$fastload$'('newuser.icp'),
  '$fastload$'('comp.icp'),
  '$fastload$'('arith.icp'),
  '$fastload$'('compiler.icp'),
  '$fastload$'('esc_code.icp'),
  '$fastload$'('write.icp'),
  '$fastload$'('listing.icp'),
  '$fastload$'('fork.icp'),
  '$fastload$'('assert.icp'),
  '$fastload$'('interrupt.icp'),
  '$fastload$'('foreign.icp'),
  '$fastload$'('newForeign.icp'),
  '$fastload$'('unix.icp'),
  '$fastload$'('misc.icp'),
  '$fastload$'('dcg.icp'),
  '$fastload$'('escape.icp'),
  '$fastload$'('style.icp'),
  '$fastload$'('format.icp'),
  'thread%f'(Th),
  'set_prop%f'(Th, initial, ('<TOP_SHELL>', stream(0), stream(1), stream(2))),
  'set_in%f'(0, 0),
  'set_out%f'(0, 1),
  '$ dcodegen'('$c$',2,[fail()],1),	% set_up '$c$'(_,_) :- fail
  style_check(all),
  catch(reconsult(system), system_fail(reconsult(system),Err), Err),
  remember(editor,vi),
  'pipe%f'(Prolog, Queries),
  'set_port%f'(0, Prolog),		/* register prolog port */
  fork('$prolog_server'(port(Queries))),
  '$ startup',
  fail.
'$ boot' :-
  '$ run'.

'$fastload$'(File) :-
  'o_stream%f'(File, 0, N),
  'set_in%f'(0, N),
  'load%f'(system),
  'c_stream%f'(N),
  'fix_tables%f',
  '$ LOAD'.

'$ startup' :-
  get_prop('$prolog$', '$file$', [File]),
  (  File == '~/.icp.pl' ->
	file_exists(File)
  ;	true
  ),
  catch(consult(File), system_fail(consult(File),Err), Err), fail.
'$ startup' :-
	get_prop('$prolog$', '$argv$', List),
	'$ startup'(List).

'$ startup'([]) :- !.
'$ startup'([Atom|T]) :-
	pname(Term, Atom),
	catch(call(Term), system_fail(Term, Err), Err), !,
	'$ startup'(T).
'$ startup'([_|T]) :-
	'$ startup'(T).
