/* Copyright (C) 1992 Imperial College */
/* public list: [compile/1, compile/2, compile/3, '$ read_clause'/4,
	 '$ comp_user'/3, '$ comp_file'/6, expand_term/2, '$ compile_error'/2,
	 read_prolog_file/1] */

compile(Name) :- '$compile$'(Name, [], file).
compile(Name, Public) :- '$compile$'(Name, Public, file).
compile(Name, Public, Mode) :- '$compile$'(Name, Public, Mode, file).

/************ this is the old compiler
compile(Name) :- '$compile$'(Name, [], pred).
compile(Name, Public) :- '$compile$'(Name, Public, pred).
compile(Name, Public, Mode) :- '$compile$'(Name, Public, Mode, pred).
************/

% 'user' files are compiled in 'multiple' mode
% Other files are compiled in 'single' mode
'$compile$'(user, Public, Flag) :- !, 
  '$compile$'(user, Public, multiple, Flag).
'$compile$'(Source, Public, Flag) :-
  '$compile$'(Source, Public, single, Flag).

% Compiling in 'single' Mode produces a single segment, while compiling
% in 'multiple' Mode produces one segment for each relation.
'$compile$'(user, Public, Mode, Flag) :- !,
  set_prop('$ dynamic', 0, []),
  catch('$ comp_user'(Mode, Public, Flag), '$ compile_error'([], Err), Err),
  del_prop('$ dynamic', 0).
'$compile$'(Source, Public, Mode, Flag) :-
  '$ filenames'(Source, Name, Dest, Type),
  open(Name, read, Stream),
  current_input(In),
  set_input(Stream),
  Stream = stream(S),
  set_prop('$ dynamic', S, []),
  catch('$ comp_file'(Mode, Name, Public, Dest, Type, Flag),
		'$ compile_error'([Dest, Source], Err), Err), !,
  del_prop('$ dynamic', S),
  close(Stream),
  set_input(In).

/* error handler to remove incomplete output file */
'$ compile_error'([], Err) :- !,
  del_prop('$ dynamic', 0),
  catch(throw(Err), system_error(compile(user), Code), Code).
'$ compile_error'([BadFile, Source], Err) :-
  'curr_input%f'(_, Stream),
  del_prop('$ dynamic', Stream),
  writeseqnl(user_error, ['\n\nremoving', BadFile, '\n']),
  concat('rm -f ', BadFile, Command),
  unix(Command),
  'timeslice%f'(1),	% may have been turned off
  catch(throw(Err), system_error(compile(Source), Code), Code).

'$ comp_user'(Mode, Public, Flag) :-
  current_output(Original),
  '$comp_user$'(Mode, Public, Flag),
  set_output(Original).

'$comp_user$'(single, Public, Flag) :- !,
  'timeslice%f'(0),
  '$compile_window$'(Flag, pl, user, single),
  manage_segment(Public),
  'timeslice%f'(1).
'$comp_user$'(multiple, _, Flag) :-
  '$compile_window$'(Flag, pl, user, multiple).

'$ comp_file'(Mode, Source, Public, Dest, Type, Flag) :- !,
  current_output(Original),
  set_output(user_error),
  write('  reading source file ... '),
  flush_output(user_error),
  statistics(runtime, [T1,_]),
  open(Dest, write, Out),
  set_output(Out),
  '$comp_file$'(Mode, Source, Public, Type, Flag),
  close(Out),
  statistics(runtime, [T2,_]),
  T is (T2-T1)/1000,
  set_output(user_error),
  '$ return_clr_eol'(String),
  write(String),
  write('finished compilation in '),
  format('~3f', T),
  write(' seconds\n'),
  set_output(Original).

'$comp_file$'(single, Source, Public, Type, Flag) :- !,
  'timeslice%f'(0),
  '$compile_window$'(Flag, Type, Source, single),
  'cg_fixup%f'(Public, _),
  'cg_out%f',
  'timeslice%f'(1).
'$comp_file$'(multiple, Source, _, Type, Flag) :- 
  '$compile_window$'(Flag, Type, Source, multiple).

generate_code(single, _, Code) :- !,
  'cg%f'(Code).
generate_code(multiple, user, [Pred|Rest]) :- !,
  'timeslice%f'(0),
  'cg_init%f'(0),
  'cg%f'([Pred|Rest]),
  manage_segment([Pred]),
  'timeslice%f'(1).
generate_code(multiple, _, [Pred|Rest]) :- 
  'timeslice%f'(0),
  'cg_init%f'(0),
  'cg%f'([Pred|Rest]),
  'cg_fixup%f'([Pred], _),
  'cg_out%f',
  'timeslice%f'(1).

manage_segment(Public) :-
  'cg_fixup%f'(Public, Size),
  'o_mem%f'(_, 2, Out, Size),
  'set_out%f'(1, Out),
  'cg_out%f',
  'set_up_seg%f'(Out),
  'set_out%f'(0, 1),    /* must reset to some valid output here */
  '$ validate'(Status),
  '$ continuation'(Status).

'$compile_window$'(pred, Type, Window, Style) :-
	'$compile_by_pred$'(Type, Window, Style).
'$compile_window$'(file, Type, Window, Style) :-
	'$compile_by_file$'(Type, Window, Style).

'$compile_by_pred$'(pl, Window, Style) :- !,
	'$ read_clause'(Term, Vars, Pred, Arity, pred),
	'cg_init%f'(0),
	compile_window(Vars-Term,Pred,Arity,Window,Style,0).
'$compile_by_pred$'(Type, Window, Style) :-
	'defined%f'(user_compile/3, _),
	user_compile(Type, Window, Progs),
	'cg_init%f'(0),
	compile_relations(Progs, Style, Window, 0).

compile_window(end,_,_,_,_,_) :- !.
compile_window(Cl,Pred,Arity,Window,Style,L) :-
	read_relation(Cls,Pred,Arity,NCl,NPred,NArity),
	'$comp_msg$'(Window, Pred/Arity),
	'$ comp_relation'([Cl|Cls],Pred,Arity,L,L1,C,[]),     
	generate_code(Style, Window, C),
	compile_window(NCl,NPred,NArity,Window,Style,L1).

compile_relations([], _, _, _) :- !.
compile_relations([pr(Pred/Arity, Cl)|Progs], Style, Window, L) :-
	'$comp_msg$'(Window, Pred/Arity),
	'$ comp_relation'(Cl,Pred,Arity,L,L1,C,[]),
	generate_code(Style, Window, C),
	compile_relations(Progs,Style,Window, L1).

read_relation(Cls,Pred,Arity,NCl,NPred,NArity) :-
  '$ read_clause'(Term,Vars,Pr,Ar, pred), !,
  aux_read_relation(Cls,Pred,Arity,NCl,NPred,NArity,Vars-Term,Pr,Ar).
read_relation([],_,_,end,_,_).

aux_read_relation([Cl|Cls],Pred,Arity,NCl,NPred,NArity,Cl,Pred,Arity) :-
  !,
  read_relation(Cls,Pred,Arity,NCl,NPred,NArity).
aux_read_relation([],_,_,Cl,Pred,Arity,Cl,Pred,Arity).

'$ read_clause'(Term, Vars, Pr, Ar) :-
	'$ read_clause'(Term, Vars, Pr, Ar, pred).

'$ read_clause'(Term, Vars, Pr, Ar, Flag) :-
  get_prop(term_expansion, clauses, Vars1-Rest), !,
  del_prop(term_expansion, clauses),
  '$return_one_clause'(Rest, Vars1, Term2, Vars),
  '$read_clause1$'(Term2, Term, Vars, Pr, Ar, Flag).
'$ read_clause'(Term, Vars, Pr, Ar, Flag) :-
  '?read?'(T, V),
  T \== end_of_file,
  '$read_clause$'(T, V, Term, Vars, Pr, Ar, Flag).

'$read_clause$'((:- Goal), _, Term, Vars, Pr, Ar, Flag) :- !,
  (   '$ primcatch'(Goal, (:- Goal)),
      fail
  ;   '$ read_clause'(Term, Vars, Pr, Ar, Flag)
  ).
'$read_clause$'((?- Goal), _, Term, Vars, Pr, Ar, pred) :- !,
  (   '$ primcatch'(Goal, (:- Goal)),
      fail
  ;   '$ read_clause'(Term, Vars, Pr, Ar, pred)
  ).
'$read_clause$'((?- Goal), V, NewGoal, [Anon|Vars], '<LOAD>', 0, file) :- !,
	'?ground?'(V, Vars),
	'$transform_load$'(Goal, Anon, NewGoal).
/***********************
'$read_clause$'(Term, V, Term, Vars, Pr, Ar, _) :-
  analyse_head(Term, Pr, Ar),
  'atom%f'(Pr), !,
  '?ground?'(V, Vars).
***********************/
'$read_clause$'(Term1, V, OutTerm, Vars, OutPr, OutAr, Flag) :-
  '$expand_term$'(Term1, V, Term, Vars),
  '$read_clause1$'(Term, OutTerm, Vars, OutPr, OutAr, Flag).

'$read_clause1$'(Term, OutTerm, Vars, OutPr, OutAr, _) :-
  analyse_head(Term, Pr, Ar),
  'atom%f'(Pr),
  not on(Pr, Vars), !,
  maybe_dynamic(Term, Pr, Ar, OutTerm, OutPr, OutAr).
'$read_clause1$'(T, Term, Vars, Pr, Ar, Flag) :-
  system_error(T, 201),
  '$ read_clause'(Term, Vars, Pr, Ar, Flag).

% returns the predicate name and arity of the clause given
analyse_head((Head :- _), Pr, Ar) :- !,
  functor(Head, Pr, Ar).
analyse_head(Term, Pred, Ar) :-
  functor(Term, Pred, Ar).

maybe_dynamic(Term, Pr, Ar, OutTerm, '<LOAD>', 0) :-
  'curr_input%f'(_, Stream),
  get_prop('$ dynamic', Stream, List),
  on(Pr/Ar, List), !,
  OutTerm = ('<LOAD>' :- assert(Term)).
maybe_dynamic(Term, Pr, Ar, Term, Pr, Ar).
  

% adds ".pl" suffix if not already present
'$ filenames'(Name, Srcfile, Binfile, Type) :-
	'$ file_extension_type'(Ext, Type),
	'suffix%f'(Name, Ext), !,
	(   absolute_file_name(Name, Srcfile)
	;   Srcfile=Name
	), !,
	concat(FullBase, Ext, Srcfile),
	concat(FullBase, '.icp', Binfile).
'$ filenames'(Base, Srcfile, Binfile, Type) :-
	'$ file_extension_type'(Ext, Type),
	concat(Base, Ext, Name),
	absolute_file_name(Name, Srcfile), !,
	concat(FullBase, Ext, Srcfile),
	concat(FullBase, '.icp', Binfile).
'$ filenames'(Base, Srcfile, Binfile, pl) :- !,
	concat(Base, '.pl', Srcfile),
	concat(Base, '.icp', Binfile).
'$ filenames'(Base, Srcfile, Binfile, Type) :-
	'$ file_extension_type'(Ext, Type),
	concat(Base, Ext, Srcfile),
	concat(Base, '.icp', Binfile).

'$comp_msg$'(user,_) :- !.
'$comp_msg$'(_, Pred) :- 
  '$ return_clr_eol'(String),
  writeseq(user_error, [String, '  compiling', Pred]),
  flush_output(user_error).

/**********************************************************************
* Term1 here is hollow and Vars1 is of the form ['X'=X] eg
* Term1 = (my_append([_311|_321],_331,[_311|_347]) :- my_append(_321,_331,_347))
* Vars1 = ['H' = _311,'T' = _321,'L' = _331,'L1' = _347]
**********************************************************************/
'$expand_term$'(Term1, Vars1, Term2, Vars2) :-
	'defined%f'(term_expansion/2, _),
	term_expansion(Term1, Term3), !,
	'$return_one_clause'(Term3, Vars1, Term2, Vars2).
'$expand_term$'(-->(Head, Body), Vars1, Clause2, Vars2) :- !,
	'$ dcg_rule'(-->(Head, Body), Clause1),
	'$split_vars$'(Vars1, VarList, NameList),
	'to_ground%f'(Clause1, Clause2, VarList, NameList, Vars2).
'$expand_term$'(Term, V, Term, Vars) :-
	'?ground?'(V, Vars).

'$return_one_clause'([First], Vars1, Term2, Vars2) :- !,
	'$return_one_clause'(First, Vars1, Term2, Vars2).
'$return_one_clause'([First|Rest], Vars1, Term2, Vars2) :-
	set_prop(term_expansion, clauses, Vars1-Rest), !,
	'$return_one_clause'(First, Vars1, Term2, Vars2).
'$return_one_clause'((?- Goal), V, NewGoal, [Anon|Vars]) :- !,
	'?ground?'(V, Vars),
	'$transform_load$'(Goal, Anon, NewGoal).
'$return_one_clause'(Term3, Vars1, Term2, Vars2) :-
	'$split_vars$'(Vars1, VarList, NameList),
	'to_ground%f'(Term3, Term2, VarList, NameList, Vars2).

'$split_vars$'([], [], []) :- !.
% special case to make sure 'C' is not used as a variable name
'$split_vars$'(['C'=Var|L1], [Var|L2], ['_$C'|L3]) :- !,
	'$split_vars$'(L1, L2, L3).
'$split_vars$'([Name=Var|L1], [Var|L2], [Name|L3]) :-
	'$split_vars$'(L1, L2, L3).

expand_term(Term1, Term2) :-
	defined(term_expansion/2),
	term_expansion(Term1, Term2), !.
expand_term(-->(Head, Body), Clause) :- !,
	'$ dcg_rule'(-->(Head, Body), Clause).
expand_term(Term, Term).

'$transform_load$'(Goal, '_$$',
	('<LOAD>' :- 'gensym%f'('<LOAD>','_$$'),
		     'set_prop%f'('<LOAD>', '_$$', Goal))).
/****************************************************************** yac
***	new compile which reads whole file before compiling	***
******************************************************************/
'$compile_by_file$'(Type, Name, Style) :-
	'$read_compiled_prolog_file$'(Type, Name, Progs), !,
	'cg_init%f'(0),
	compile_relations(Progs, Style, Name, 0).

'$read_compiled_prolog_file$'(Type, Name, Progs) :-
	'defined%f'(user_compile/3, _),
	user_compile(Type, Name, Progs), !.
'$read_compiled_prolog_file$'(pl, _, Progs) :-
	read_prolog_file(Progs), !.
'$read_compiled_prolog_file$'(_, _, _) :-
	throw(303).

read_prolog_file(Progs) :-
	'$read_prolog_file$'(ProgsOut, ''),
	'$fix_read_clauses$'(ProgsOut, [], Progs).

'$read_prolog_file$'(Progs, LP) :-
	'$ read_clause'(Term,Vars,Pr,Ar, file),
	add_clause(Pr/Ar, Vars-Term, Progs, LP, LP1),
	maybe_var_warning(Term, Vars, Pr/Ar, Progs), !,
	'$read_prolog_file$'(Progs, LP1).
'$read_prolog_file$'(_, _).

/*************************************************************
** We store clauses in a tree of the form
**	tree(Pred/Arity, Clauses, Left, Right)
** where Clauses is a variable tail list
** We also keep a term going round of the form
**	p(Pred/Arity, Tail)
** Holding the pred/arity of the last clause read and the tail of `Clauses'
** which is a variable. This is for the fast addition of clause continuation
** with no searching and also helps for finding discontinuous clauses.
*************************************************************/
%***** Same Pred/Arity as previous clause
add_clause(Key, Clause, _, p(Key, [Clause|ClTail]), p(Key, ClTail)) :- !.
%***** Different Pred/Arity to previous clause
add_clause(Key, Clause, Tree, _, p(Key, ClTail)) :-
	locate_tree_position(Key, Tree, Clauses), !,
	tree_add_clause(Clauses, Clause, ClTail, Key).

tree_add_clause(Var, Clause, ClTail, _) :-	% New Pred
	var(Var), !,
	Var = [Clause|ClTail].
tree_add_clause(Clauses, Clause, ClTail, Key) :-	% Old Pred
	addTail(Clauses, Clause, ClTail), !,
	'$ style_warning'((discontiguous), Key).

addTail(Var, Value, Tail) :-
	var(Var), !,
	Var = [Value|Tail].
addTail([_|T], Value, Tail) :-
	addTail(T, Value, Tail).

'$fix_read_clauses$'([], L, L) :- !.	% Tree is a variable
'$fix_read_clauses$'(tree(PA, CL, L, R), Prog1, Prog2) :-
	'$fix_read_clause$'(CL),
	'$fix_read_clauses$'(L, [pr(PA, CL)|Prog1], Prog),
	'$fix_read_clauses$'(R, Prog, Prog2).

'$fix_read_clause$'([]) :- !.
'$fix_read_clause$'([_|T]) :- '$fix_read_clause$'(T).

locate_tree_position(Key, tree(Key, Clauses, _, _), Clauses) :- !.
locate_tree_position(Key, tree(Key1, _, L, _), Clauses) :-
	Key @< Key1, !,
	locate_tree_position(Key, L, Clauses).
locate_tree_position(Key, tree(_, _, _, R), Clauses) :-
	locate_tree_position(Key, R, Clauses).

/*********************** for style checking ************************/
maybe_var_warning(Term, Vars, PA, Tree) :-
	get_prop('$style_check$', single_var, on),
	check_vars(Term, Vars, SingleVars),
	SingleVars = [_|_],
	locate_tree_position(PA, Tree, Clauses),
	var_length(Clauses, 0, Idx),
	'$ style_warning'(single_var, vars(Idx, PA, SingleVars)).
maybe_var_warning(_, _, _, _).

var_length(V, N, N) :- var(V), !.
var_length([_|T], N1, N2) :-
	'increment%f'(N1, N),
	var_length(T, N, N2).

check_vars(Term, Vars1, Vars2) :-
	prep_vars(Vars1, Vars),
	functor(Term, _, Arity),
	check_term_vars(Arity, Term, Vars, Vars3),
	remove_duplicates(Vars3, Vars2).

check_term_vars(0, Term, Vars1, Vars2) :- !,
	functor(Term, Functor, _),
	'tag%f'(Functor,Type),
	get_arg_vars(Type, Functor, Vars1, Vars2).
check_term_vars(N, Term, Vars1, Vars2) :-
	arg(N, Term, Arg),
	'tag%f'(Arg,Type),
	get_arg_vars(Type, Arg, Vars1, Vars),
	'decrement%f'(N, N1), !,
	check_term_vars(N1, Term, Vars, Vars2).

remove_duplicates([], []).
remove_duplicates([X,X|T], L) :- !,
	remove_duplicates(T, L).
remove_duplicates([X|T], [X|L]) :-
	remove_duplicates(T, L).
/*
[
	[Arg,Vars]-(get_arg_vars(1,Arg,Vars,Vars) :- !),
	[Arg,Vars]-(get_arg_vars(2,Arg,Vars,Vars) :- !),
	[Atom,Vars1,Vars2]-(get_arg_vars(3,Atom,Vars1,Vars2) :- !,remove_one(Atom,Vars1,Vars2)),
	[Arg,Vars]-(get_arg_vars(4,Arg,Vars,Vars) :- !),
	[List,Vars1,Vars2]-(get_arg_vars(5,List,Vars1,Vars2) :- !,check_term_vars(2,List,Vars1,Vars2)),
	[Tuple,Vars1,Vars2,Ar,Arity]-(get_arg_vars(6,Tuple,Vars1,Vars2) :- !,arity%f(Tuple,Ar),sub%f(Ar,1,Arity),check_term_vars(Arity,Tuple,Vars1,Vars2))|_18190]
*/

get_arg_vars(1, _, Vars, Vars) :- !.			% integer
get_arg_vars(2, _, Vars, Vars) :- !.			% float
get_arg_vars(3, Atom, Vars1, Vars2) :- !,		% var or constant
	remove_one(Atom, Vars1, Vars2).
get_arg_vars(4, _, Vars, Vars) :- !.			% []
get_arg_vars(5, List, Vars1, Vars2) :- !,		% [_|_]
	check_term_vars(2, List, Vars1, Vars2).
get_arg_vars(6, Tuple, Vars1, Vars2) :- !,		% tuple
	'arity%f'(Tuple, Ar),
	'sub%f'(Ar, 1, Arity),
	check_term_vars(Arity, Tuple, Vars1, Vars2).

remove_one(A, [A|Rest], Rest) :- !.
remove_one(A, [B|Rest], [B|Rest1]) :- !,
	remove_one(A, Rest, Rest1).
remove_one(_, [], []).

prep_vars([], []).
prep_vars([H|T1], T2) :-
	concat('_', _, H), !,
	prep_vars(T1, T2).
prep_vars([H|T1], [H,H|T2]) :-
	prep_vars(T1, T2).
