/* Copyright (C) 1992 Imperial College */
/* A table of foreign escape codes.  The 'foreign' functions
   contained herein are those which are implemented in "C"

            name        arity  escape#
*/
'$ escape_code'(noref,          0, -3).     % list undefined preds
'$ escape_code'(debugicp,       0, -2).     % debug emulator
'$ escape_code'(halt,           0, -1).     % exit emulator
'$ escape_code'('add%f',        3,  0).     % add two integers
'$ escape_code'('sub%f',        3,  1).     % subtract two integers
'$ escape_code'('mul%f',        3,  2).     % multiply two integers
'$ escape_code'('div%f',        3,  3).     % divide two integers
'$ escape_code'('mod%f',        3,  4).     % modulus
'$ escape_code'('cmp%f',        3,  5).     % compare two terms
'$ escape_code'('int%f',        1,  6).     % integer test
'$ escape_code'(integer,        1,  6).     % integer test
'$ escape_code'('atom%f',       1,  7).     % atomic test
'$ escape_code'('var%f',        1,  8).     % var test
'$ escape_code'(var,            1,  8).     % var test
'$ escape_code'('list%f',       1,  9).     % list test
'$ escape_code'(list,           1,  9).     % list test
'$ escape_code'('tpl%f',        1, 10).     % tuple test
'$ escape_code'('arg%f',        3, 11).     % extract from tuple
'$ escape_code'('univ%f',       2, 12).     % univ
'$ escape_code'('name%f',       3, 13).     % print-names of terms
'$ escape_code'('o_stream%f',   3, 14).     % initialise stream I/O
'$ escape_code'('c_stream%f',   1, 15).     % finished with stream/ram file
'$ escape_code'('o_mem%f',      4, 16).     % initialise ram file
'$ escape_code'('c_mem%f',      1, 17).     % finished with ram file
'$ escape_code'('set_in%f',     2, 18).     % set current input stream
'$ escape_code'('set_out%f',    2, 19).     % set current output stream
'$ escape_code'('increment%f',  2, 20).     % increment by 1
'$ escape_code'('put_q_atom%f', 1, 21).     % write out a quoted atom
'$ escape_code'('get0%f',       1, 22).     % input a character
'$ escape_code'(get0,           1, 22).     % input a character
'$ escape_code'('put%f',        1, 23).     % output a character
'$ escape_code'('unget%f',      1, 24).     % put back a character
'$ escape_code'(unget,          1, 24).     % put back a character
'$ escape_code'('flush%f',      1, 25).     % flush output stream
'$ escape_code'('addr%f',       2, 26).     % numerical address of var
'$ escape_code'('deepcut%f',    1, 27).     % deep cut
'$ escape_code'('back%f',       1, 28).     % pick up cut label
'$ escape_code'('meta%f',       1, 29).     % meta-call
'$ escape_code'('eq%f',         2, 30).     % 
'$ escape_code'('ne%f',         2, 31).     % 
'$ escape_code'('lt%f',         2, 32).     % 
'$ escape_code'('le%f',         2, 33).     % 
'$ escape_code'('gt%f',         2, 34).     % 
'$ escape_code'('ge%f',         2, 35).     % 
'$ escape_code'('syntax_error%f',1,36).     % Syntax Error Handler
'$ escape_code'('link%f',       1, 37).     % link clause of dynamic predicate
'$ escape_code'('retract%f',    3, 38).     % retract dynamic clause
'$ escape_code'('dec%f',        1, 39).     % decrement N by 1 in [N]
'$ escape_code'('inc%f',        1, 40).     % increment N by 1 in [N]
'$ escape_code'('find_clause%f',5, 41).     % find partic. clause of dynamic chain
'$ escape_code'('time%f',       1, 42).     % get CPU time
'$ escape_code'('arity%f',      2, 43).     % get arity of tuple 
'$ escape_code'('funct%f',      2, 44).     % get functor of tuple 
'$ escape_code'('interm%f',     3, 45).     % read a term and produce var list 
'$ escape_code'('ntpl%f',       2, 46).     % create a new tuple of unbounds 
'$ escape_code'('not%f',        2, 47).     % binary complement 
'$ escape_code'('lshift%f',     3, 48).     % left shift
'$ escape_code'('rshift%f',     3, 49).     % right shift
'$ escape_code'('and%f',        3, 50).     % and
'$ escape_code'('or%f',         3, 51).     % or
'$ escape_code'('op_prefix%f',  3, 52).     % define a new prefix operator
'$ escape_code'('op_postfix%f', 3, 53).     % define a new postfix operator
'$ escape_code'('op_infix%f',   4, 54).     % define a new infix operator
'$ escape_code'('op_look%f',    8, 55).     % read specified operator details
'$ escape_code'('op_get%f',    10, 56).     % read unspecified operator details
'$ escape_code'('put_str%f',    2, 57).     % write a quoted atom (list of ASCII)
'$ escape_code'('put_atom%f',   1, 58).     % write out an atom
'$ escape_code'('put_number%f', 1, 59).     % write out a number
'$ escape_code'('atom_type%f',  2, 60).     % is atom alphanumeric or symbols ?
'$ escape_code'('defined%f',    2, 61).     % return address of predicate
'$ escape_code'('read_catch%f', 1, 62).     % read CATCH register
'$ escape_code'('set_catch%f',  1, 63).     % set CATCH register
'$ escape_code'('read_error%f', 1, 64).     % read and reset ERROR register
'$ escape_code'('catch%f',      1, 65).     % set CATCH to most recent chpt.
'$ escape_code'('throw%f',      1, 66).     % throw an error
'$ escape_code'('cg_init%f',    1, 67).     % initialise code generator
'$ escape_code'('cg_fixup%f',   2, 68).     % fixup generated code and return its size
'$ escape_code'('cg%f',         1, 69).     % generate code for one relation
'$ escape_code'('system%f',     1, 70).     % enter/exit system mode
'$ escape_code'('ram_const%f',  2, 71).     % create constant from memory file
'$ escape_code'('load%f',       1, 72).     % load code block from current input
'$ escape_code'('varsin%f',     2, 73).     % bind 2nd arg to list of vars appearing in 1st arg
'$ escape_code'('fix_tables%f', 0, 74).     % fixup externals and entries tables
'$ escape_code'('save%f',       3, 75).     % save to curr output file the code for a pred 
'$ escape_code'('pred_look%f',  4, 76).     % Check if specified predicate is defined
'$ escape_code'('pred_get%f',   6, 77).     % Get unspecified predicate details
'$ escape_code'('abolish%f',    2, 78).     % Abolish predicate
'$ escape_code'('validate%f',   2, 79).     % Gets a list of predicates being re-loaded
'$ escape_code'('undo_seg%f',   0, 80).     % Free space for and delete last seg 
'$ escape_code'('kill%f',       2, 81).     % Kill predicate
'$ escape_code'('write_term%f', 1, 82).     % write encoded term
'$ escape_code'('read_term%f',  1, 83).     % read encoded term
'$ escape_code'('tag%f',        2, 84).     % return tag as in integer
'$ escape_code'('grnd_funct%f', 1, 85).     % test for ground functor
'$ escape_code'('tab%f',        1, 86).     % print spaces
'$ escape_code'('tab',          1, 86).     % print spaces
'$ escape_code'('concat%f',     3, 87).     % concat two symbols
'$ escape_code'('prefix%f',     2, 88).     % symbol prefix test
'$ escape_code'('suffix%f',     2, 89).     % symbol suffix test
'$ escape_code'('to_ground%f',  5, 90).     % Makes a ground copy of a term
'$ escape_code'('to_hollow%f',  4, 91).     % Makes a hollow copy of a term
'$ escape_code'('delete%f',     2, 92).     % deletes all the clauses for foo/n
'$ escape_code'('cg_out%f',     0, 93).     % writes generated code to current output
'$ escape_code'('set_up_seg%f', 1, 94).     % sets up last memory file as a segment
'$ escape_code'('tty%f',        3, 95).     % create slave window
'$ escape_code'('ram_pipe%f',   2, 96).     % create ram file pipe
'$ escape_code'('close_port%f', 1, 97).     % close one end of pipe
'$ escape_code'('read_pipe%f',  2, 98).     % read a term from pipe
'$ escape_code'('write_pipe%f', 2, 99).     % write a term to pipe
'$ escape_code'('new_thread%f', 1, 100).    % create a new thread
'$ escape_code'('kill_thread%f',1, 101).    % kill a thread
'$ escape_code'('fork%f',       2, 102).    % fork a thread
'$ escape_code'('resume%f',     1, 103).    % resume a thread
'$ escape_code'('suspend%f',    0, 104).    % suspend a thread
'$ escape_code'('rpc%f',        3, 105).    % remote procedure call
'$ escape_code'('pipe%f',       2, 106).    % create a pipe using memory buffers
'$ escape_code'('thread%f',     1, 107).    % get address of current thread
'$ escape_code'('set_prop%f',   3, 108).    % setting a property
'$ escape_code'('get_prop%f',   3, 109).    % retrieving a property
'$ escape_code'('del_prop%f',   2, 110).    % deleting a property
'$ escape_code'('get_props%f',  2, 111).    % get property names of an object
'$ escape_code'('del_props%f',  1, 112).    % delete all properties of an object
'$ escape_code'('get_cons%f',   2, 113).    % get objects which have property
'$ escape_code'('del_cons%f',   1, 114).    % delete objects which have property
'$ escape_code'('float%f',      1, 115).    % floating-point test
'$ escape_code'('put_float%f',  1, 116).    % write out a floating-point
'$ escape_code'('number%f',     1, 117).    % integer/float test
'$ escape_code'('number',       1, 117).    % integer/float test
'$ escape_code'('fadd%f',       3, 118).    % floating point addition
'$ escape_code'('fsub%f',       3, 119).    % floating point subtraction
'$ escape_code'('fmul%f',       3, 120).    % floating point multiplication
'$ escape_code'('fdiv%f',       3, 121).    % floating point division
'$ escape_code'('int%f',        2, 122).    % convert float to integer
'$ escape_code'('sin%f',        2, 123).    %
'$ escape_code'('cos%f',        2, 124).    %
'$ escape_code'('tan%f',        2, 125).    %
'$ escape_code'('asin%f',       2, 126).    %
'$ escape_code'('acos%f',       2, 127).    %
'$ escape_code'('atan%f',       2, 128).    %
'$ escape_code'('atan2%f',      3, 129).    %
'$ escape_code'('sinh%f',       2, 130).    %
'$ escape_code'('cosh%f',       2, 131).    %
'$ escape_code'('tanh%f',       2, 132).    %
'$ escape_code'('exp%f',        2, 133).    %
'$ escape_code'('log%f',        2, 134).    %
'$ escape_code'('log10%f',      2, 135).    %
'$ escape_code'('sqrt%f',       2, 136).    %
'$ escape_code'('pow%f',        3, 137).    %
'$ escape_code'('abs%f',        2, 138).    %
'$ escape_code'('sign%f',       2, 139).    %
'$ escape_code'('ceil%f',       2, 140).    %
'$ escape_code'('floor%f',      2, 141).    %
'$ escape_code'('pi%f',         1, 142).    %
'$ escape_code'('rand%f',       1, 143).    %
'$ escape_code'('deg2rad%f',    2, 144).    %
'$ escape_code'('rad2deg%f',    2, 145).    %
'$ escape_code'('interrupt%f',  1, 146).    %
'$ escape_code'('unix%f',       1, 147).    % interface to unix shell
'$ escape_code'('stat%f',       7, 148).    % get file statistics
'$ escape_code'('look_pipe%f',  2, 149).    % read without removing
'$ escape_code'('commit_read%f',1, 150).    % commits the non-removing read
'$ escape_code'('unlock%f',     1, 151).    % unlock a pipe
'$ escape_code'('init_parlog%f',1, 152).    % start up a Parlog thread
'$ escape_code'('tty_get0%f',   1, 153).    % read char from terminal
'$ escape_code'('curr_input%f', 2, 154).    % identify current input
'$ escape_code'('curr_output%f',2, 155).    % identify current output
'$ escape_code'('release_port%f',1,156).    % relinquish ownership of port
'$ escape_code'('empty_pipe%f', 1, 157).    % test if pipe is empty
'$ escape_code'('is_iport%f',   1, 158).    % input port test
'$ escape_code'('is_oport%f',   1, 159).    % output port test
'$ escape_code'('runtime%f',    2, 160).    % get CPU time (SICSTUS style)
'$ escape_code'('decrement%f',  2, 161).    % decrement by 1
'$ escape_code'('exit%f',       1, 162).    % return from WAM emulator
'$ escape_code'('set_port%f',   2, 163).    % hack for Parlog
'$ escape_code'('get_port%f',   2, 164).    % hack for Parlog
'$ escape_code'('gensym%f',     2, 165).    % generate a new symbol
'$ escape_code'('ar_int%f',     2, 166).    % int test/cast for expressions
'$ escape_code'('ar_float%f',   2, 167).    % float test/cast for expressions
'$ escape_code'('copy%f',	2, 168).    % copy term with new variables
'$ escape_code'('load_foreign%f',3,170).    % set up foreign C primitives
'$ escape_code'('realtime%f',   1, 171).    % real time (seconds since 1/1/170)
'$ escape_code'('errno%f',      2, 172).    % C errno
'$ escape_code'('getenv%f',     2, 173).    % get environment variable
'$ escape_code'('timeslice%f',  1, 174).    % allow/dissallow timeslicing
'$ escape_code'('cursor%f',     3, 175).    % fseek and ftell
'$ escape_code'('ctime%f',      7, 176).    % unix time conversion
'$ escape_code'('gc_usage%f',   3, 177).    % garbage collection stats
'$ escape_code'('format_print_float%f',   3, 178).	% print float
'$ escape_code'('format_print_integer%f',   3, 179).	% print integer
'$ escape_code'('line_position%f',   2, 180).		% position of last nl
'$ escape_code'('line_count%f',   2, 181).  % number of nls
'$ escape_code'('setenv%f',     2, 182).    % set environment variable
'$ escape_code'('suspend%f',    1, 183).    % suspend given thread
'$ escape_code'('$tcp_init$', 0, 184).
'$ escape_code'('tcp_socket%f', 3, 185).
'$ escape_code'('tcp_setsockopt%f', 3, 186).
'$ escape_code'('tcp_getsockopt%f', 3, 187).
'$ escape_code'('tcp_bind%f', 3, 188).
'$ escape_code'('tcp_listen%f', 1, 189).
'$ escape_code'('tcp_accept%f', 5, 190).
'$ escape_code'('tcp_connect1%f', 3, 191).
'$ escape_code'('tcp_connect2%f', 2, 192).
'$ escape_code'('tcp_send%f', 3, 193).
'$ escape_code'('tcp_recv%f', 4, 194).
'$ escape_code'('tcp_sendto%f', 5, 195).
'$ escape_code'('tcp_recvfrom%f', 6, 196).
'$ escape_code'('tcp_sendbr%f', 4, 197).
'$ escape_code'('tcp_checkrecv%f', 2, 198).
'$ escape_code'('tcp_checkconn%f', 1, 199).
'$ escape_code'('tcp_close%f', 1, 200).
'$ escape_code'('tcp_getsockaddr%f', 3, 201).
'$ escape_code'('tcp_getpeeraddr%f', 3, 202).
'$ escape_code'('tcp_gethost%f', 2, 203).
'$ escape_code'('tcp_getport%f', 3, 204).
'$ escape_code'('tcp_real_socket%f', 2, 205).

