/* Copyright (C) 1992 Imperial College */
load_foreign(File, List) :-
        '$foreign_funcs$'(List, L, []),
        'load_foreign%f'(File, L, []).

load_foreign(File, List, [Lib|Libs]) :- !,
        '$foreign_funcs$'(List, L, []),
        'load_foreign%f'(File, L, [Lib|Libs]).
load_foreign(File, List, Lib) :-
	'atom%f'(Lib),
        '$foreign_funcs$'(List, L, []),
        'load_foreign%f'(File, L, [Lib]).

'$foreign_funcs$'([], L, L) :- !.
'$foreign_funcs$'([Pred/Ar | Rest], [Pred(Pred,Ar)|L], Tail) :- !,
        '$foreign_funcs$'(Rest, L, Tail).
'$foreign_funcs$'([Pred/Ar = CName | Rest], [CName(Pred,Ar)|L], Tail) :-
        '$foreign_funcs$'(Rest, L, Tail).
