/* Copyright (C) 1992 Imperial College */
'$mbx_preds$'([
	'$mbx_init$'/0 = pr_mbx_init0,
	'mbx_init%f'/2 = pr_mbx_init1,
	'mbx_create%f'/6 = pr_mbx_create,
	'mbx_send%f'/6 = pr_mbx_send1,
	'mbx_recv%f'/5 = pr_mbx_recv1,
	'mbx_look%f'/5 = pr_mbx_look1,
	'mbx_commit%f'/5 = pr_mbx_commit1,
	'mbx_discard%f'/5 = pr_mbx_discard1,
	'mbx_check%f'/5 = pr_mbx_check1,
	'mbx_close%f'/4 = pr_mbx_close1,
	'mbx_link_i%f'/5 = pr_mbx_link_i1,
	'mbx_link_o%f'/5 = pr_mbx_link_o1,
	'mbx_unlink_i%f'/5 = pr_mbx_unlink_i1,
	'mbx_unlink_o%f'/5 = pr_mbx_unlink_o1,
	'mbx_getlinks%f'/4 = pr_mbx_getlinks1,
	'mbx_clear%f'/5 = pr_mbx_clear1,
	'mbx_bind%f'/5 = pr_mbx_bind1,
	'mbx_getid%f'/4 = pr_mbx_getid1,
	'mbx_getname%f'/4 = pr_mbx_getname1,
	'mbx_initdb%f'/2 = pr_mbx_initdb1,
	'mbx_getdb%f'/4 = pr_mbx_getdb1,
	'mbx_closedb%f'/3 = pr_mbx_closedb1,
	'$mbx_req1$'/1 = pr_mbx_req1,
	'?mbx_req2?'/2 = pr_mbx_req2,
	'$mbx_req3$'/2 = pr_mbx_req3,
	'$mbx_req4$'/3 = pr_mbx_req4
]).

'$mbx_req2$'(Req, Term) :-
	'?mbx_req2?'(Req, Term1),
	Term = Term1.

/*
 *	Mailboxes Primitives
 */
/*	mode mbx_init(?, ?) */
mbx_init(Mach, Service) :-
	'$ primcatch'('$ mbx_init'(Mach, Service),
			mbx_init(Mach, Service)).

'$ mbx_init'(Mach, Service) :-
	'mbx_init%f'(Mach, Service).

/*	mbx_create(^, ?, ?, ?, ?, ?) */
mbx_create(Id, UserPer, GroupPer, OthersPer, ReadPwd, WritePwd) :-
	'$ primcatch'('$ mbx_create'(Id, UserPer, GroupPer, OthersPer, ReadPwd, WritePwd),
		mbx_create(Id, UserPer, GroupPer, OthersPer, ReadPwd, WritePwd)).

'$ mbx_create'(Id, UserPer, GroupPer, OthersPer, ReadPwd, WritePwd) :-
	'mbx_create%f'(Id, UserPer, GroupPer, OthersPer, ReadPwd, WritePwd).

/*	mode mbx_send(?,?,?,?,?).	*/
mbx_send(Id, Flag, TimeOut, Term, WPwd) :-
	'$ primcatch'('$ mbx_send'(Id, Flag, TimeOut, Term, WPwd),
		mbx_send(Id, Flag, TimeOut, Term, WPwd)).

'$ mbx_send'(Id, Flag, TimeOut, Term, WPwd) :-
	'mbx_send%f'(Id, Flag, TimeOut, Term, WPwd, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_recv(?,?,?,^,?).	*/
mbx_recv(Id, Flag, TimeOut, Term, RPwd) :-
	'$ primcatch'('$ mbx_recv'(Id, Flag, TimeOut, Term, RPwd),
		mbx_recv(Id, Flag, TimeOut, Term, RPwd)).

'$ mbx_recv'(Id, Flag, TimeOut, Term, RPwd) :-
	'mbx_recv%f'(Id, Flag, TimeOut, RPwd, Req),
	'$mbx_req2$'(Req, Term).

/*	mode mbx_look(?,?,?,^,?).	*/
mbx_look(Id, Flag, TimeOut, Term, RPwd) :-
	'$ primcatch'('$ mbx_look'(Id, Flag, TimeOut, Term, RPwd),
		mbx_look(Id, Flag, TimeOut, Term, RPwd)).

'$ mbx_look'(Id, Flag, TimeOut, Term, RPwd) :-
	'mbx_look%f'(Id, Flag, TimeOut, RPwd, Req) ,
	'$mbx_req2$'(Req, Term).

/*	mode mbx_commit(?,?,?,?).	*/
mbx_commit(Id, Flag, TimeOut, RPwd) :-
	'$ primcatch'('$ mbx_commit'(Id, Flag, TimeOut, RPwd),
		mbx_commit(Id, Flag, TimeOut, RPwd)).

'$ mbx_commit'(Id, Flag, TimeOut, RPwd) :-
	'mbx_commit%f'(Id, Flag, TimeOut, RPwd, Req) ,
	'$mbx_req1$'(Req).

/*	mode mbx_discard(?,?,?,?).	*/
mbx_discard(Id, Flag, TimeOut, RPwd) :-
	'$ primcatch'('$ mbx_discard'(Id, Flag, TimeOut, RPwd),
		mbx_discard(Id, Flag, TimeOut, RPwd)).

'$ mbx_discard'(Id, Flag, TimeOut, RPwd) :-
	'mbx_discard%f'(Id, Flag, TimeOut, RPwd, Req) ,
	'$mbx_req1$'(Req).

/*	mode mbx_check(?,?,?,?).	*/
mbx_check(Id, Flag, TimeOut, RPwd) :-
	'$ primcatch'('$ mbx_check'(Id, Flag, TimeOut, RPwd),
		mbx_check(Id, Flag, TimeOut, RPwd)).

'$ mbx_check'(Id, Flag, TimeOut, RPwd) :-
	'mbx_check%f'(Id, Flag, TimeOut, RPwd, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_close(?,?,?).	*/
mbx_close(Id, TimeOut, RPwd) :-
	'$ primcatch'('$ mbx_close'(Id, TimeOut, RPwd),
		mbx_close(Id, TimeOut, RPwd)).

'$ mbx_close'(Id, TimeOut, RPwd) :-
	'mbx_close%f'(Id, TimeOut, RPwd, Req) ,
	'$mbx_req1$'(Req).

/*	mode mbx_link(?,?,?,?,?).	*/
mbx_link(IdI, RPwd, IdO, WPwd, TimeOut) :-
	'$ primcatch'('$ mbx_link'(IdI, RPwd, IdO, WPwd, TimeOut),
		mbx_link(IdI, RPwd, IdO, WPwd, TimeOut)).

'$ mbx_link'(IdI, RPwd, IdO, WPwd, TimeOut) :-
	'$mbx_link_i$'(IdI, RPwd, IdO, TimeOut),
	'$mbx_link_o$'(IdO, WPwd, IdI, TimeOut).

/*	mode '$mbx_link_i$'(?,?,?,?).	*/
'$mbx_link_i$'(IdI, RPwd, IdO, TimeOut) :-
	'mbx_link_i%f'(IdI, RPwd, IdO, TimeOut, Req),
	'$mbx_req1$'(Req).

/*	mode '$mbx_link_c$'(?,?,?,?).	*/
'$mbx_link_o$'(IdO, WPwd, IdI, TimeOut) :-
	'mbx_link_o%f'(IdO, WPwd, IdI, TimeOut, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_unlink(?,?,?,?,?).	*/
mbx_unlink(IdI, RPwd, IdO, WPwd, TimeOut) :-
	'$ primcatch'('$ mbx_unlink'(IdI, RPwd, IdO, WPwd, TimeOut),
		mbx_unlink(IdI, RPwd, IdO, WPwd, TimeOut)).

'$ mbx_unlink'(IdI, RPwd, IdO, WPwd, TimeOut) :-
	'$mbx_unlink_i$'(IdI, RPwd, IdO, TimeOut),
	'$mbx_unlink_o$'(IdO, WPwd, IdI, TimeOut).

/*	mode '$mbx_unlink_i$'(?,?,?,?).	*/
'$mbx_unlink_i$'(IdI, RPwd, IdO, TimeOut) :-
	'mbx_unlink_i%f'(IdI, RPwd, IdO, TimeOut, Req),
	'$mbx_req1$'(Req).

/*	mode '$mbx_unlink_c$'(?,?,?,?).	*/
'$mbx_unlink_o$'(IdO, WPwd, IdI, TimeOut) :-
	'mbx_unlink_o%f'(IdO, WPwd, IdI, TimeOut, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_getlinks(?,?,?,^).	*/
mbx_getlinks(Id, TimeOut, RPwd, Term) :-
	'$ primcatch'('$ mbx_getlinks'(Id, TimeOut, RPwd, Term),
		mbx_getlinks(Id, TimeOut, RPwd, Term)).

'$ mbx_getlinks'(Id, TimeOut, RPwd, Term) :-
	'mbx_getlinks%f'(Id, TimeOut, RPwd, Req),
	'$mbx_req2$'(Req, Term).

/*	mode mbx_clear(?,?,?,?).	*/
mbx_clear(Id, Flag, TimeOut, RPwd) :-
	'$ primcatch'('$ mbx_clear'(Id, Flag, TimeOut, RPwd),
		mbx_clear(Id, Flag, TimeOut, RPwd)).

'$ mbx_clear'(Id, Flag, TimeOut, RPwd) :-
	'mbx_clear%f'(Id, Flag, TimeOut, RPwd, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_bind(?,?,?,?).	*/
mbx_bind(Id, TimeOut, RPwd, Term) :-
	'$ primcatch'('$ mbx_bind'(Id, TimeOut, RPwd, Term),
		mbx_bind(Id, TimeOut, RPwd, Term)).

'$ mbx_bind'(Id, TimeOut, RPwd, Term) :-
	pname(Term, Pname),
	'mbx_bind%f'(Id, TimeOut, RPwd, Pname, Req),
	'$mbx_req1$'(Req).

/*	mode mbx_getid(?,?,?,^).	*/
mbx_getid(Term, TimeOut, Pwd, Id) :-
	'$ primcatch'('$ mbx_getid'(Term, TimeOut, Pwd, Id),
		mbx_getid(Term, TimeOut, Pwd, Id)).

'$ mbx_getid'(Term, TimeOut, Pwd, Id) :-
	pname(Term, Pname),
	'mbx_getid%f'(Pname, TimeOut, Pwd, Req),
	'$mbx_req3$'(Req, Id).

/*	mode mbx_getname(?,?,?,^).	*/
mbx_getname(Id, TimeOut, Pwd, Term) :-
	'$ primcatch'('$ mbx_getname'(Id, TimeOut, Pwd, Term),
		mbx_getname(Id, TimeOut, Pwd, Term)).

'$ mbx_getname'(Id, TimeOut, Pwd, Term) :-
	'mbx_getname%f'(Id, TimeOut, Pwd, Req),
	'$mbx_req2$'(Req, Pname),
	pname(Term, Pname).

/*	mode mbx_initdb(^,?).	*/
mbx_initdb(Ptr, TimeOut) :-
	'$ primcatch'('$ mbx_initdb'(Ptr, TimeOut),
		mbx_initdb(Ptr, TimeOut)).

'$ mbx_initdb'(Ptr, TimeOut) :-
	'mbx_initdb%f'(TimeOut, Req),
	'$mbx_req3$'(Req, Ptr).

/*	mode mbx_getdb(?,?,?,^,^).	*/
mbx_getdb(Ptr, TimeOut, Pwd, Term, Id) :-
	'$ primcatch'('$ mbx_getdb'(Ptr, TimeOut, Pwd, Term, Id),
		mbx_getdb(Ptr, TimeOut, Pwd, Term, Id)).

'$ mbx_getdb'(Ptr, TimeOut, Pwd, Term, Id) :-
	'mbx_getdb%f'(Ptr, TimeOut, Pwd, Req),
	'$mbx_req4$'(Req, Id, Pname),
	pname(Term, Pname).

/*	mode mbx_closedb(?,?).	*/
mbx_closedb(Ptr, TimeOut) :-
	'$ primcatch'('$ mbx_closedb'(Ptr, TimeOut),
		mbx_closedb(Ptr, TimeOut)).

'$ mbx_closedb'(Ptr, TimeOut) :-
	'mbx_closedb%f'(Ptr, TimeOut, Req),
	'$mbx_req1$'(Req).

/**********************************************************************/

/* Simple interface */

mbx_create(Id) :-
	'$ primcatch'('$ mbx_create'(Id, read_write, write, write, 0, 0),
		mbx_create(Id)).

mbx_send(Id, Term) :-
	'$ primcatch'('$ mbx_send'(Id, normal, block, Term, 0),
		mbx_send(Id, Term)).

mbx_recv(Id, Term) :-
	'$ primcatch'('$ mbx_recv'(Id, normal, block, Term, 0),
		mbx_recv(Id, Term)).

mbx_look(Id, Term) :-
	'$ primcatch'('$ mbx_look'(Id, normal, block, Term, 0),
		mbx_look(Id, Term)).

mbx_commit(Id) :-
	'$ primcatch'('$ mbx_commit'(Id, normal, block, 0),
		mbx_commit(Id)).

mbx_discard(Id) :-
	'$ primcatch'('$ mbx_discard'(Id, normal, block, 0),
		mbx_discard(Id)).

mbx_check(Id) :-
	'$ primcatch'('$ mbx_check'(Id, normal, block, 0),
		mbx_check(Id)).

mbx_close(Id) :-
	'$ primcatch'('$ mbx_close'(Id, block, 0),
		mbx_close(Id)).

mbx_link(IdI, IdO) :-
	'$ primcatch'('$ mbx_link'(IdI, 0, IdO, 0, block),
		mbx_link(IdI, IdO)).

mbx_unlink(IdI, IdO) :-
	'$ primcatch'('$ mbx_unlink'(IdI, 0, IdO, 0, block),
		mbx_unlink(IdI, IdO)).

mbx_getlinks(Id, Term) :-
	'$ primcatch'('$ mbx_getlinks'(Id, block, 0, Term),
		mbx_getlinks(Id, Term)).

mbx_clear(Id) :-
	'$ primcatch'('$ mbx_clear'(Id, normal, block, 0),
		mbx_clear(Id)).

mbx_bind(Id, Term) :-
	'$ primcatch'('$ mbx_bind'(Id, block, 0, Term),
		mbx_bind(Id, Term)).

mbx_getid(Term, Id) :-
	'$ primcatch'('$ mbx_getid'(Term, block, 0, Id),
		mbx_getid(Term, Id)).

mbx_getname(Id, Term) :-
	'$ primcatch'('$ mbx_getname'(Id, block, 0, Term),
		mbx_getname(Id, Term)).

mbx_initdb(Ptr) :-
	'$ primcatch'('$ mbx_initdb'(Ptr, block),
		mbx_initdb(Ptr)).

mbx_getdb(Ptr, Term, Id) :-
	'$ primcatch'('$ mbx_getdb'(Ptr, block, 0, Term, Id),
		mbx_getdb(Ptr, Term, Id)).

mbx_closedb(Ptr) :-
	'$ primcatch'('$ mbx_closedb'(Ptr, block),
		mbx_closedb(Ptr)).

/**********************************************************************/

?- '$mbx_preds$'(L),
   load_foreign('mbx_prolog.o',L, 'mbx_kernel.o'),
   '$mbx_init$'.

