/* Copyright (C) 1992 Imperial College */
make(rebuild) :- !,
	rebuild.
make(File) :-
	public(File, Preds), !,
	make(File, Preds).
make(File) :- make(File, []).

make(File, Public) :-
	write('Checking '),
	write(File),
	write('.pl ... '), flush,
	out_of_date(File, pl), !,
	write('out of date.\n'),
	flush,
	compile(File, Public).
make(_, _) :-
	write('ok.\n').

rebuild :-
	write('\n\n\n'),
	write('REBUILD ICP ][\n'),
	write('==============\n'),
	write('\nMaking all system files ...\n\n'),
	fail.
rebuild :-
	out_of_date(esc_code, pl),
	make(esc_code, []),
	system(on),
	load(esc_code),
	system(off),
	fail.
rebuild :-
	public(File, Preds),
	make(File, Preds),
	fail.
rebuild :-
	file_exists('lorebuild.pl'),
	reconsult(lorebuild),
	fail.
rebuild :-
	file_exists('xpcerebuild.pl'),
	reconsult(xpcerebuild),
	fail.
rebuild :- write('\nICP SYSTEM IS UP TO DATE\n').

public(make, [make/1, make/2]).
public(assert, [consult/1, '$ consult'/2, reconsult/1,
        assert/1, asserta/1, assertz/1, assertx/2,
	'$ assertx_hollow'/2, '$ assertx_ground'/6, clause/2, retract/1,
	'$ retract'/1, '$ retract'/4, retractx/3, '$ retractx'/3,
	retractall/1, '$ retractall'/1, '$ dcodegen'/4, '$ unlink'/4,
	(dynamic)/1, '$ valid_pred'/2 ]).
public(boot, ['$ boot'/0]).
public(comp, [compile/1, compile/2, compile/3, '$ read_clause'/4,
        '$ comp_user'/3, '$ comp_file'/6, expand_term/2, '$ compile_error'/2,
	 read_prolog_file/1, '$ filenames'/4]).
public(arith, ['$ compile_expr'/7, '$ arith_err'/1]).
public(compiler,['$ comp_relation'/7, '$ assert_compiler'/6,
	'$ indxless'/2, '$ v_less'/2, '$ compare_perms'/2, '$ warn_locals'/5]).
public(control, [true/0, otherwise/0, fail/0, false/0, (\+)/1, (not)/1,
	succeed/1, repeat/0, call/1, '?call?'/2, one/1,
	forall/2, findall/3, bagof/3, setof/3, map/2, map/3, map/4, map/5]).
public(fork, []).
public(foreign, [load_foreign/2, load_foreign/3]).
public(newForeign, [load_foreign_files/1, load_foreign_files/2]).
public(listing, [listing/0, listing/1, listfile/1, numbervars/3,
	portray_clause/1]).
public(loader, [loadicp/1, loadicp/2, load/1, load/2, '$ loader'/1,
	'$ continuation'/1, '$ validate'/1, '$ LOAD'/0]).
public(misc, []).
public(newuser, ['$ run'/0, shell/0, shell_escape/0, '$ query_handler'/0,
        trace/0, notrace/0, tty_get0/1, '$ icp_print'/1, '$ icp_print'/2]).
public(operators, [op/3, current_op/3, '$ op'/3]).
public(predicates, ['$ pred'/4, predicate/2, current_predicate/2,
        system_predicate/2, predicate_property/2,
	save/2, save/3, abolish/1, kill/1, '$ notify'/2]).
public(primitives, []).
public(syserror, [system_fail/2, system_error/2, error/3,
        '$system_fail$'/2, '$system_error$'/2, '$undefined$'/0,
	system_undefined/1]).
public(tracer, [('??')/1, '$ inc'/1, '$ runproc'/7,
        set_leashes/0, set_echoes/0]).
public(write, [write/1, writeq/1, display/1, print/1, write_canonical/1,
	write/2, writeq/2, display/2, print/2, write_canonical/2, writeq/3]).
public(interrupt, []).
public(unix, [unix/1, '?unix?'/1, cd/0, cd/1, ls/0, ls/1, pwd/0, vi/1,
	edit/1, edit/2, getenv/2, setenv/2, stat/7]).
public(dcg, [phrase/2, phrase/3, 'C'/3, '$ dcg_rule'/2]).
public(style, [style_check/1, no_style_check/1, '$ style_warning'/3,
	'$ style_warning'/2]).
public(format, [format/2, format/3, '$ format'/2]).
public(escape, []).
public(mailbox, []).
public(tcp, []).
