/* Copyright (C) 1992 Imperial College */
/* public list :
        ['$ run', shell, shell_escape, trace, notrace]
*/
/* dac 22/5/90  changed consult_user to use assert */

/* NOTE : the first two subgoal (setting input and output) 
   are important initialisations.  Do not delete ! */
'$ run' :-
  read_eval_print.
'$ run' :-
  set_output(user),
  write('\n*** Serious Error - Query Handler Failed ***\c
         \n***    Please Report This To Authors.    ***\c
         \n***     Starting New Query Handler ...   ***\n\n'),
  '$ run'.

read_eval_print :-
  repeat,
  catch('$ query_handler', system_fail(' ',Err), Err),
  fail.

shell :-
  thread(Th),
  get_prop(Th, initial, (G,_,_,_)),
  ok_to_run_shell(G),
  tty('Shell', In, Out),
  set_prop(Th, initial, ('<SHELL>', In, Out, Out)),
  set_input(In),
  set_output(Out),
  read_eval_print.

ok_to_run_shell('<TOP_SHELL>') :- !,
	write(user_error, 'shell can only be run in a new thread\n'),
	fail.
ok_to_run_shell('<SHELL>') :- !,
	write(user_error, 'shell can only be run in a new thread\n'),
	fail.
ok_to_run_shell(_).

shell_escape :-
  current_input(In),
  current_output(Out),
  set_input(user),
  set_output(user_output),
  write('\n! '),
  catch('$ query_handler', system_fail(' ',Err), Err),
  set_input(In),
  set_output(Out).

'$ query_handler' :-
  repeat,
  write('\n| ?- '), flush,
  '$ primcatch'('$read$'(Goal1, 1200, Vars), read(_)),
  nonvar(Goal1),
  '$query_expansion$'(Goal1, Goal),
  knownVars(Vars, V),
  execute(Goal, V), !.

'$query_expansion$'(Goal, Goal1) :-
	'defined%f'(query_expansion/2, _),
	query_expansion(Goal, Goal1), !.
'$query_expansion$'(Goal, Goal).

execute(halt, _) :- !,
  halt.
execute(notrace, _) :- !,
  notrace.
execute(end_of_file, _) :- !,
  thread(Th),
  get_prop(Th, initial, (Name,_,_,_)),
  (Name == '<TOP_SHELL>' -> halt ; exit).
execute((:- Goal), V) :- !,
  execute(Goal, V).
execute((?- Goal), V) :- !,
  execute(Goal, V).
execute(Goal, V) :-
  thread(Th),
  get_prop(Th, trace, _), !,
  get_prop(Th, initial, (_, In, Out, _)),
  query(??(Goal), V, In, Out).
execute(Goal, V) :-
  thread(Th),
  get_prop(Th, initial, (_, In, Out, _)),
  query(Goal, V, In, Out).

'?query?'(G) :-
  catch(G,system_fail(G,C),C).

query(G, [], In, Out) :-
  '?query?'(G), !,
  set_input(In), set_output(Out),
  write('\nyes').
query(G, [H|T], In, Out) :-
  '?query?'(G),
  set_input(In),
  set_output(Out),	/* may have problems, if so use 'set_out%f' */
  split_bindings([H|T], [], Vars, Ground),
  write_vars(Vars),
  write_equations(Ground, Vars), !.
query(_, _, In, Out) :-
  set_input(In), set_output(Out),
  write('\nno').

/* the interesting variables are the non-anonymous ones */
knownVars([], []) :- !.
knownVars([Name=_|T], V) :-
  'prefix%f'(Name, '_$'), !,    % anonymous variables begin with '_$'
  knownVars(T, V).
knownVars([H|T], [H|L]) :-
  knownVars(T, L).

/* Trying something new here.  The unbound variables are just
   listed out with no address value. */
write_vars([]) :- !.
write_vars([V]) :- !,
  writeseq(['\nUnbound variable :', V]).
write_vars([H|T]) :-
  qsort([H|T], [First|Rest], @<),
  write('\nUnbound variables : '),
  write(First),
  more_vars(Rest).

more_vars([]) :- !.
more_vars([H|T]) :-
  write(', '),
  write(H),
  more_vars(T).

/* write out bindings of variables, wait for user input
   and backtrack if alternate answers are required */
write_equations([], []) :- !,
  nl.
write_equations([], [_|_]) :-
  '$more$'.
write_equations([H|T], _) :-
  write_bindings([H|T]).

write_bindings([]) :-
  '$more$'.
write_bindings([Name=Value|Vars]) :-
  nl,
  '$writeVar$'(Name), write(' = '),
  writeValue(Vars, V, Value),
  write_bindings(V).

/* if variables are bound to the same value, show this */
writeValue([], [], Value) :- !,
  '$ icp_print'(Value).
writeValue([Name=V|Tail], Rest, Value) :-
  V == Value, !,
  '$writeVar$'(Name), write(' = '),
  writeValue(Tail, Rest, Value).
writeValue([Head|Tail], [Head|Rest], Value) :-
  writeValue(Tail, Rest, Value).

'$writeVar$'(Var) :-
	name(Var, L),
	append(Name, [0'$|_], L),
	name(N, Name), !,
	write(N).
'$writeVar$'(Var) :-
	write(Var).

'$ icp_print'(Value) :-
  defined(portray/1), !,
  print(Value).
'$ icp_print'(Value) :-
  writeq(Value).

'$ icp_print'(Stream, Value) :-
  current_output(Out),
  set_output(Stream),
  '$ icp_print'(Value),
  set_output(Out).


/* split into two categories - variables and ground terms */
split_bindings([], Vars, Vars, []) :- !.
split_bindings([Name=Value|T], VL, Vars, [Name=Value|R]) :-
  nonvar(Value), !,
  remove_value(Value, VL, VList),
  split_bindings(T, VList, Vars, R).
split_bindings([V='$VAR'(V)|T], VList, Vars, Ground) :-
  split_bindings(T, [V|VList], Vars, Ground).

/* variables which are bound to other variables are 
   removed from the 'unbound variables list' */
remove_value(Pred(V), VL, VList) :-
  Pred == '$VAR', !,
  '$delete$'(V, VL, VList).
remove_value(_, VList, VList).

'$delete$'(_, [], []) :- !.
'$delete$'(El, [El|T], T) :- !.
'$delete$'(El, [H|T], [H|R]) :-
  '$delete$'(El, T, R).

'$more$' :-
  write(' '),
  flush,
  'tty_get0%f'(Reply),
  no_more(Reply).

/* does user want alternatives ? */
no_more(0'\n) :- !.     % <return> to stop
no_more(0';) :-         % ';' for more solutions
  skip(0'\n), !,
  fail.
no_more(_) :-           % ignore anything else
  skip(0'\n).

trace :-
  thread(Th),
  set_prop(Th, trace, on),
  defined((??)/1), !.
trace :-
  load(tracer).

notrace :-
  thread(Th),
  del_prop(Th, trace).

tty_get0(Ch) :-
  current_input(Orig),
  tty_get0(Orig, Ch).

tty_get0(Orig, Ch) :-
  thread(Th),
  get_prop(Th, initial, (_, In, _, _)),
  set_input(In),
  'tty_get0%f'(Ch), !,
  set_input(Orig).
tty_get0(Orig, _) :-
  set_input(Orig).
