/* Copyright (C) 1992 Imperial College */
style_check(all) :- !,
	set_prop('$style_check$', discontiguous, on),
	set_prop('$style_check$', multiple, on),
	set_prop('$style_check$', single_var, on).
style_check(discontiguous) :- set_prop('$style_check$', discontiguous, on).
style_check(multiple) :- set_prop('$style_check$', multiple, on).
style_check(single_var) :- set_prop('$style_check$', single_var, on).

no_style_check(all) :- !,
	set_prop('$style_check$', discontiguous, off),
	set_prop('$style_check$', multiple, off),
	set_prop('$style_check$', single_var, off).
no_style_check(discontiguous) :- set_prop('$style_check$', discontiguous, off).
no_style_check(multiple) :- set_prop('$style_check$', multiple, off).
no_style_check(single_var) :- set_prop('$style_check$', single_var, off).

'$ style_warning'(discontiguous, PA) :-
	PA \== '<LOAD>'/0,
	get_prop('$style_check$', discontiguous, on), !,
	write(user_error, 'WARNING: Clauses for '),
	writeq(user_error, PA),
	write(user_error, ' are not together in the source file\n').
'$ style_warning'(single_var, vars(Idx, PA, Vars)) :-
	get_prop('$style_check$', single_var, on), !,
	'$ return_clr_eol'(String),
	write(user_error, String),
	writeseq(user_error, ['WARNING: Singleton variables, clause ',Idx,of]),
	writeq(user_error, PA),
	writeseqnl(user_error, [': ',Vars]).
'$ style_warning'(_, _).
