/* Copyright (C) 1992 Imperial College */

/* 
0   ..  99 syntax error - occur in the reader only
100 .. 199 instantiation error - built-in predicate or primitive called
           with insufficiently instantiated arguments. eg. passed a variable
           when a value was expected.
200 .. 299 type error - a primitive argument is of the wrong type.  eg.
           passed an integer when an atom is expected.
300 .. 399 input/output errors - eg. trying to open a non-existent file.
400 .. 499 icp restrictions - eg. trying to redefine a built-in predicate.
500 .. 599 icp limits - table overflows, or any numerical limits.
600 .. 699 external limits - eg. running out of heap space, streams or
           memory files.
700 .. 799 TCP errors
800 .. 899 mbx errors
Special Errors :
999        Fail top-level goal
1000       abort
*/



system_fail(G, Error) :-
    defined(user_error/2), !,
    catch(user_error(G,Error), '$system_fail$'(G,E), E).
system_fail(G, Error) :-
    '$system_fail$'(G, Error).

'$system_fail$'(_, 999) :- !,
    fail.
'$system_fail$'(_,Error) :-
    Error < 100, !,
    'syntax_error%f'(Error).
'$system_fail$'(Goal, Error) :-
    Error < 999,
    error(Error, WhatToDo, Msg), !,
    goal_info(Error, Goal, Info),
    err_msg(Msg, WhatToDo, Info, Error),
    '?system_fail?'(WhatToDo).
'$system_fail$'(_, 1000) :-
    writenl(user_error, '\n--- ABORTED ---\n').
 
'?system_fail?'(error) :- !, fail.
'?system_fail?'(Goal) :- Goal.



system_error(G, Error) :-
    defined(user_error/2), !,
    catch(user_error(G,Error), '$system_error$'(G,E), E).
system_error(G, Error) :-
    '$system_error$'(G, Error).

'$system_error$'(_,Error) :-
    Error < 100, !,
    'syntax_error%f'(Error).
'$system_error$'(Goal, Error) :-
    Error < 999,
    error(Error, WhatToDo, Msg), !,
    goal_info(Error, Goal, Info),
    err_msg(Msg, WhatToDo, Info, Error),
    '?system_error?'(WhatToDo).
'$system_error$'(_, Error) :-    % where Error is 999 or 1000
    throw(Error).

err_msg([], _WhatToDo, _Info, _Error) :- !.
err_msg(Msg, WhatToDo, Info, Error) :-
    (WhatToDo==true->M='\nWARNING';M='\nERROR'),
    writeseq(user_error, [ M, Error, ':', Msg ]),
    writeqnl(user_error, Info).
 
'?system_error?'(error) :- !,
    throw(999).
'?system_error?'(Goal) :- Goal.

error(100, error, 'unbound variable in arithmetic expression :').
error(101, error, 'unbound variable in relational expression :').
error(102, error, 'unbound stream identifier in :').
error(103, error, 'unbound filemode in :').

error(200, error, 'non-integer in arithmetic expression :').
error(201, true,  'invalid clause :').
error(202, error, 'non-number in relational expression :').
error(203, error, 'non-atom filename in :').
error(204, true,  'non-atom in operator declaration :').
error(205, error, 'non-variable stream identifier in :').
error(206, error, 'invalid data for ram file in :').
error(207, error, 'non-integer argument in throw/1 :').
error(208, error, 'non-variable in argument 2 of'). 
error(209, error, 'non-variable argument in :'). 
error(210, error, 'invalid form of use :'). 
error(211, error, 'unterminated list in :'). 
error(212, error, 'invalid list of ASCII codes in :'). 
error(213, error, 'non-integer argument in :'). 
error(214, error, 'attempt to assert/retract a static predicate :').
error(215, error, 'attempt to assert/retract a system predicate :').
error(216, error, 'invalid clause in :').
error(217, error, 'invalid goal :').
error(218, error, 'non-number in arithmetic expression :').
error(219, error, 'invalid arithmetic expression :').

error(300, error, 'cannot open file').
error(301, error, 'invalid stream :'). 
error(302, error, 'cannot close stream :'). 
error(303, error, 'incorrect or unknown file type :'). 
error(304, error, 'error occurred while reading object file :'). 
error(305, error, 'error occurred while writing object file :'). 
error(306, error, 'invalid ram file :'). 
error(307, error, 'invalid port :'). 
error(308, error, 'port has pending read :'). 
error(309, error, 'port has pending write :'). 
error(310, error, 'port is being read by another thread :'). 
error(311, error, 'port is being written to by another thread :'). 
error(312, error, 'port is owned by another thread :'). 

error(400, error, 'file mode must be read, write or append :'). 
error(401, true,  'operator priority must be in the range 0..1200 :').
error(402, true,  'operator type must be fx, fy, xf, yf, xfx, xfy, yfx or yfy :').
error(403, error, 'predicate not defined :').
error(404, error, 'undefined property :'). 
error(405, error, 'undefined predicate in :'). 
error(408, error, 'system deadlock :').
error(409, error, 'invalid return code from service function :'). 
error(410, error, 'parlog thread exists already :'). 
error(411, error, 'invalid thread ID :'). 
error(412, error, 'cannot switch to parlog from this thread :'). 

error(500, error, 'compiler error :').
error(501, error, 'invalid instruction found during code generation :').
error(502, error, 'multiply-defined label found during code generation :').
error(503, error, 'term nested too deep :').
error(504, error, 'out of stack space :').
error(505, error, 'out of heap space :').
error(506, error, 'invalid ICP instruction :').
error(507, error, 'invalid tag type found :').
error(508, error, 'too many variables in term :').
error(509, error, 'term too large in property :').
error(510, error, 'term too large for pipe :').

error(600, error, 'division by zero in arithmetic expression :').
error(601, error, 'cannot open any more file streams :').
error(602, error, 'cannot open any more memory streams :').
error(603, error, 'no space for RAM file :').
error(604, error, 'code segment too large :').
error(605, error, 'symbol space full during code generation :').
error(606, error, 'out of space during code generation :').
error(607, error, 'out of code space :').
error(608, error, 'out of space in dictionary maintenance :').
error(609, error, 'out of space for constants :').
error(610, error, 'no space for new thread :').
error(611, error, 'no space for property :').
error(612, error, 'out of space in term reader :').
error(613, error, 'out of system heap space :').
error(614, fail, []).		/* illegal instruction */

error(700, fail, 'Bad sequence of TCP instructions :').
error(701, fail, 'Socket closed :').
error(702, fail, []).		/* TIMEOUT */
error(703, fail, 'Invalid socket descriptor :').
error(710, fail, socket(Err, Msg)) :- errno(Err, Msg).
error(711, fail, setsockopt(Err, Msg)) :- errno(Err, Msg).
error(712, fail, bind(Err, Msg)) :- errno(Err, Msg).
error(713, fail, listen(Err, Msg)) :- errno(Err, Msg).
error(714, fail, accept(Err, Msg)) :- errno(Err, Msg).
error(715, fail, connect(Err, Msg)) :- errno(Err, Msg).
error(716, fail, ioctl(Err, Msg)) :- errno(Err, Msg).
error(717, fail, send(Err, Msg)) :- errno(Err, Msg).
error(718, fail, recv(Err, Msg)) :- errno(Err, Msg).
error(719, fail, sendto(Err, Msg)) :- errno(Err, Msg).
error(720, fail, recvfrom(Err, Msg)) :- errno(Err, Msg).
error(721, fail, close(Err, Msg)) :- errno(Err, Msg).
error(722, fail, getsockname(Err, Msg)) :- errno(Err, Msg).
error(723, fail, gethostname(Err, Msg)) :- errno(Err, Msg).
error(724, fail, gethostbyname(Err, Msg)) :- errno(Err, Msg).
error(725, fail, getpeername(Err, Msg)) :- errno(Err, Msg).
error(726, fail, gethostbyaddr(Err, Msg)) :- errno(Err, Msg).
error(727, fail, getservbyname(Err, Msg)) :- errno(Err, Msg).
error(728, fail, getservbyport(Err, Msg)) :- errno(Err, Msg).
error(729, fail, getsockopt(Err, Msg)) :- errno(Err, Msg).
error(730, error, 'cannot open any more sockets :').
error(731, error, 'data too long for buffer :').

error(800, error, 'Maibox initialisation :').
error(801, error, 'Timeout (mailbox) :').
error(802, error, 'Incorrect mailbox identifier :').
error(803, error, 'Mailbox permission denied :').
error(804, error, 'Invalid operation on linked mailbox :').
error(805, error, 'The mailbox is locked :').
error(806, error, 'The mailbox is empty :').
error(807, error, 'Attempt to commit or discard an unlocked mailbox :').
error(808, error, 'The machine on which the mailbox is located is shut down :').
error(809, error, 'An error has happened in the low level communications :').
error(810, error, 'Attempt to bind a mailbox to a service which already exists :').
error(811, error, 'The specified service does not exist in the internal database :').
error(812, error, 'The specified mailbox does not exist in the internal database :').
error(813, error, 'Unspecified Mailbox error :').
error(814, error, 'Unification failure error (mailbox) :').

error(_, debugicp, 'unknown error').

goal_info(300, open(File, _, _), File) :- !.
goal_info(403, Goal, Pred/Arity) :- !,
    functor(Goal, Pred, Arity).
goal_info(_, G, G).

/* BEWARE : THIS PREDICATE NAME IS HARD WIRED IN C CODE */
'$undefined$' :-
    'interrupt%f'(Goal),
    '$undefined0$'(Goal).

'$undefined0$'(Goal) :-
    functor(Goal, Pred, _),
    'prefix%f'(Pred, '$c$'), !,
    fail.
'$undefined0$'(Goal) :-
    defined(user_undefined/1), !,
    user_undefined(Goal).
'$undefined0$'(Goal) :-
    system_undefined(Goal).

system_undefined(Goal) :-
    functor(Goal, Pred, Arity),
    '$undefined1$'(Goal, Pred, Arity).

'$undefined1$'(Goal, Pred, Arity) :-
    '$ srcfile'(Pred, File, Type), file_exists(File), !,
    '$auto_consult$'(Goal, Pred, Arity, File, Type).
'$undefined1$'(Goal, Pred, Arity) :-
    '$auto_load$'(Pred),
    defined(Pred/Arity), !,
    Goal.
'$undefined1$'(Goal, Pred, Arity) :-
    '$undefined2$'(Goal, Pred/Arity).

'$auto_consult$'(Goal, Pred, Arity, _, _) :-
    '$auto_load$'(Pred), !,
    (   defined(Pred/Arity) ->
	Goal
    ;   '$undefined2$'(Goal, Pred/Arity)
    ).
'$auto_consult$'(Goal, Pred, Arity, File, _) :-
    reconsult(Pred),
    writeseqnl(user_error, ['... auto-consulted', File]),
    defined(Pred/Arity), !,
    Goal.
'$auto_consult$'(Goal, Pred, Arity, _, _) :-
    '$undefined2$'(Goal, Pred/Arity).

'$auto_load$'(Pred) :-
    '$ icpfile'(Pred, File),
    file_exists(File),
    load(Pred),
    writeseqnl(user_error, ['... auto-loaded', File]).

'$undefined2$'(Goal, Pred) :-
    thread(Th),
    get_prop(Th, undefined, Flag), !,
    '$undefined3$'(Flag, Goal, Pred).
'$undefined2$'(Goal, Pred) :-
    writeseqnl(user_error, ['undefined predicate :', Pred]),
    '?undefined?'(Goal, Pred).

'$undefined3$'(warning, _, Pred) :- !,
	writeseqnl(user_error, ['undefined predicate :', Pred]),
	fail.
'$undefined3$'(error, _, _) :- !,
	throw(403).
'$undefined3$'(fail, _, _) :- !, fail.

'?undefined?'(Goal, Pred) :-
    write(user_error, '\n\
Options :\n\
   l   - load binary file\n\
   c   - consult source file\n\
   u   - consult user\n\
   s   - succeed goal\n\
   f   - fail goal\n\
   b   - bind goal\n\
  <CR> - abort goal\n\
   ?   - display this list\n\n'),
    write(user_error, '? '), flush_output(user_error),
    tty_get0(Ch),
    '%undefined%'(Ch, Goal, Pred).

'%undefined%'(0'l, Goal, _) :- !,
    skip(10),
    write(user_error, 'load which file ? '), flush_output(user_error),
   catch((read(user, File), load(File), Goal), system_fail(Goal,C),C).
'%undefined%'(0'c, Goal, _) :- !,
    skip(10),
    write(user_error, 'consult which file ? '), flush_output(user_error),
    catch((read(user, File), consult(File), Goal), system_fail(Goal,C),C).
'%undefined%'(0'u, Goal, _) :- !,
    skip(10),
    write(user_error, '[user]\n'),
    catch((consult(user), set_input(user), Goal), system_fail(Goal,C),C).
'%undefined%'(0's, _, _) :- !,
    skip(10).
'%undefined%'(0'f, _, _) :- !,
    skip(10),
    fail.
'%undefined%'(0'b, Goal, _) :- !,
    skip(10),
    writeseq(user_error, ['   unify', Goal, 'with' ]), flush_output(user_error),
    catch(read(user, Goal), system_fail(Goal,C),C).
'%undefined%'(0'\n, G, _) :- !,
    system_error(G, 403).
'%undefined%'(_, Goal, Pred) :-
    skip(10),
    '?undefined?'(Goal, Pred).
