/*  $Id: autoload.pl,v 1.1 92/02/25 10:34:34 jan Exp Locker: jan $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/


:- module(pce_autoload,
	[ pce_autoload/2
	, pce_autoload_all/0
	]).

:- dynamic
	trap/1.
?- dynamic
	autoload/2.

%	pce_autoload(+ClassName, +FileSpec)
%
%	States class `ClassName' can be created by loading the Prolog
%	file `FileSpec'.  This will actually be done if either the class
%	is actually needed by PCE or pce_autoload_all/0 is called.

pce_autoload(Class, library(Library)) :-
	retractall(autoload(Class, _)),
	assert(autoload(Class, library(Library))).
pce_autoload(Class, File) :-
	retractall(autoload(Class, _)),
	absolute_file_name(File, Path),
	assert(autoload(Class, Path)).


%	pce_autoload_all/0
%
%	Load all classes declared using the autoload/2 directive.  Useful
%	for debugging purposes.

pce_autoload_all :-
	autoload(Class, File),
	\+ get(@classes, member, Class, _),
	ensure_loaded(File),
	fail.
pce_autoload_all.


?- send(@pce?exception_handlers, append,
	attribute(undefined_class, message(@prolog, trap, @arg1))).

trap(Class) :-
	autoload(Class, File),
	ensure_loaded(File).
