% File:		debug.pl
% Module:	pce_debug
% Where:	PCE-3 Library
% Purpose:	Tracing and Debugging predicates
% Author:	Anjo Anjewierden, Jan Wielemaker
% Notice:	Copyright (c) 1988, University of Amsterdam
% Works with:	Quintus Prolog, SWI-Prolog
% History:	09/06/87 (JW; Created)
%		11/08/88 (AA; Moduled)


/*
:- module(pce_debug, 
	[ debugpce/0	
	, nodebugpce/0
	, leashpce/3		% not implemented
	, nospypce/1		% +@Object | +ClassName
	, spypce/1		% +@Object | +ClassName
	, tracepce/0
	, notracepce/0
	]
*/


%   tracepce/0
%   notracepce/0
%
%   tracepce/0 turns the PCE tracer on and notracepce/0 turns it off.  The
%   PCE tracer is similar to the standard Prolog tracer in that it shows
%   entering, exiting and failing all virtual machine instructions.  The
%   tracer options are listed on the display when ? is typed to the prompt.

tracepce :-
	send(@pce, trace, @on).
notracepce :-
	send(@pce, trace, @off).


%   debugpce/0
%   nodebugpce/0
%
%   debugpce/0 turns the PCE debugger on and nodebugpce/0 turns off.  If
%   debugging is on PCE enters the tracer at all leashed ports when a
%   virtual machine instruction (new, send, get) is encountered on a spied
%   object or an instance of a spied class.

debugpce :-
	send(@pce, debug, @on).
nodebugpce :-
	send(@pce, debug, @off).


%   debugpce(+Subject)
%   nodebugpce(+Subject)
%   
%   Start/stop printing debugging messages on `Subject'. System maintenance
%   usage only.

debugpce(Subject) :-
	send(@pce, debug_subject, Subject).

nodebugpce(Subject) :-
	send(@pce, nodebug_subject, Subject).

%   spypce(+@Object)
%   spypce(+ClassName)
%   nospypce(+@Object)
%   nospypce(+ClassName)
%
%   spypce/1 puts a spy-point on Object and nospypce/1 removes a spy-point
%   from Object.  Object is either an object name or the name of a class.
%   In the latter case all instances of the class have a spy-point.  The
%   PCE debugger is automatically turned on.

spypce(Object) :-
	send(@pce, spy, Object, @on).
nospypce(Object) :-
	send(@pce, spy, Object, @off).
