/*  $Id: operator.pl,v 1.1 92/02/25 10:35:08 jan Exp Locker: jan $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/


:- module(operator,
	[ push_operators/1
	, pop_operators/0
	]).

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Often, one  wants to define  operators to improve  the  readibility of
some very  specific code.  Operators in  Prolog are global objects and
changing operators changes syntax  and  possible semantics of existing
sources.   For this   reason   it is   desirable to  reset    operator
declarations after   the code that  needs  them   has been read.  This
module defines a  rather cruel  method to do  this.  In  the future it
might be better to  limit operator definitions  to  the file they  are
declated (like style_check/1).

Usage:

:- push_operators(
	[ op(900, fx, hello_world)
	, op(600, xf, *)
	]).
	
hello_world World :-
	....

:- pop_operators.
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

?- dynamic
	operator_stack/1.

push_operators(New) :-
	maplist(undo_operator, New, Undo),
	checklist(call, New),
	asserta(operator_stack(Undo)).

pop_operators :-
	retract(operator_stack(Undo)), !,
	checklist(call, Undo).

undo_operator(op(_P, T, N), op(OP, OT, N)) :-
	same_op_type(T, OT),
	current_op(OP, OT, N), !.
undo_operator(op(_P, T, N), op(0, T, N)).
	
same_op_type(T, OT) :-
	op_type(T, Type),
	op_type(OT, Type).

op_type(fx,  prefix).
op_type(fy,  prefix).
op_type(xfx, infix).
op_type(xfy, infix).
op_type(yfx, infix).
op_type(yfy, infix).
op_type(xf,  postfix).
op_type(yf,  postfix).

%	push_compile_operators.
%	Push the current

push_compile_operators :-
	push_operators(
		[ op(1200, xfx, :->)
		, op(1200, xfx, :<-)
		, op(1190, xfx, ::)
		, op(100,  xf,  *)
		, op(125,  xf,  ?)
		, op(150,  xf,  ...)
		, op(100,  xfx, ..)
		]).

pop_compile_operators :-
	pop_operators.
