/* Copyright (C) 1992 Imperial College */
/* descriptor for a ram file */
typedef struct {
    strpo		current,
			write,
			start,
			end;
} ram_des, *rampo;

#define		PIPESIZE	0x400

/* descriptor for a pipe */
typedef struct {
    strpo		look_ptr, read_ptr, write_ptr;
    struct io_desc	*iport, *oport;
    strpo		start, end;
    int			status;
} pipe_des, *pipepo;

/* pipe status bits */
#define P_EMPTY		001	/* anything to read ?   */
#define P_LOCK		002	/* is pipe in use ?     */
#define P_RSUSP		004	/* suspended on read ?  */
#define P_WSUSP		010	/* suspended on write ? */

/* generic I/O descriptor */
typedef struct io_desc {
    union {
	FILE	*file_d;
	rampo	ram_d;
	pipepo	pipe_d;
	int	socket_d;
    } desc;
    int		pid;
    long	last_nl_pos;
    long	nl_count;
    threadpo	th;
    long	susp;
    twoBytes	io_typ;
    twoBytes	end_of_file;
} io_descriptor, *iopo;

#define fdes(p)		((p)->desc.file_d)
#define ramd(p)		((p)->desc.ram_d)
#define piped(p)	((p)->desc.pipe_d)
#define th_id(p)	((p)->th)
#define suspnd(p)	((p)->susp)
#define io_type(p)	((p)->io_typ)
#define ended(p)	((p)->end_of_file)

/* possible descriptor types */
#define OUT_SOCK	-4
#define OUT_PIPE	-3
#define OUT_RAM		-2
#define OUT_STREAM	-1
#define CLOSED		 0
#define IN_STREAM	 1
#define IN_RAM		 2
#define IN_PIPE		 3
#define IN_SOCK		 4

#define is_stream(x)	(abs(io_type(x)) == 1)
#define is_ram(x)	(abs(io_type(x)) == 2)
#define is_pipe(x)	(abs(io_type(x)) == 3)
#define is_sock(x)	(abs(io_type(x)) == 4)

extern	io_descriptor	io[];

extern	iopo		current_input,
			current_output;

extern	CHARTYPE	(*charin)(),
			pr_read_stream(),
			pr_read_stream0(),
			pr_read_ram();

extern	bool		(*charout)(),
			pr_write_stream(),
			pr_write_ram(),
			(*charback)(),
			pr_unread_stream(),
			pr_unread_ram();
