/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  which data area/processor tests
 */
#define	ismaster(pr)	(1)		/* always true */


/*
 *  dereference, wait for argument
 */
#define	deref(x)				\
	while ( IsRef(x) && !IsUnb(*ToPtr(x)) )	\
		x = (Word) *ToPtr(x);


#define wait_for_argument(x)			\
	while (IsRef(x))			\
	{	if (IsUnb(*ToPtr(x)))		\
		{	VarTbl[Nsuspv++] = x;	\
			return(SUSPEND);	\
		}				\
		x = (Word) *ToPtr(x);		\
	}


/*
 *  non-local variable assignment:  must lock to set variable
 *  (we use atomic exchange facility if possible)  and must
 *  wake any processes suspended on that variable.
 */

#define assign(ref, val)			\
	{	Process	*ps_list;		\
						\
		ps_list = UnbVal(*ToPtr(ref));	\
		*ToPtr(ref) = val;		\
						\
		if (ps_list)			\
			wake(ps_list);		\
	}


/*
 *  add a process to the local run queue
 */
#define enqueue_process(ps)			\
	*PR->q_back = ps;			\
	PR->q_back++;				\
	if (PR->q_back == PR->q_end)		\
		PR->q_back = PR->q_bot;		\



/*
 *  argument stack allocation
 */
#define alloc_stack(i)				\
	m_st->m_top;				\
	m_st->m_top += i


#define dealloc_stack(p, n)			\
	if ((p + n) == SP)			\
	{	SP = p;				\
		while (*--SP == 0)		\
			;			\
		SP++;				\
	}					\
	else					\
	{	register Word *sp = p;		\
		register int  sn  = n;		\
						\
		while (sn-- > 0)		\
			*sp++ = 0;		\
	}


/*
 *  process stack allocation
 */
#define	alloc_ps(ps)				\
	if (p_free)				\
	{	ps = p_free;			\
		p_free = p_free->link;		\
	}					\
	else					\
	{	ps = p_top++;			\
		if (p_top >= p_end)		\
			alloc_proc();		\
	}

#define dealloc_ps(ps)				\
	{	ps->link = p_free;		\
		p_free = ps;			\
	}


/*
 *  block argument copying
 */
#define copyargs(from, to, len)		\
	{	register Word *p, *q;	\
		register int n;		\
					\
		p = from;		\
		q = to;			\
		n = len;		\
		while (n-- > 0)		\
			*q++ = *p++;	\
	}

#define pushargs(from, len)		\
	{	register Word *p;	\
		register int n;		\
					\
		p = from;		\
		n = len;		\
		while (n-- > 0)		\
			*SP++ = *p++;	\
	}
