/* Copyright (C) 1992 Imperial College */
/*
    primitives.h - header file for all prolog primitives
    Damian Chu
    Imperial College 1989
 */
#include "icp.h"
#include "io.h"

extern cell	A[REGISTERS];

/* shadow registers */
extern threadpo	TH;
extern codepo	sP, CP, ERR_PT;
extern cellpo	H, HB, HMAX, CHMAX, BLS, TR, S;
extern choicepo	B, SB, CSB, GC_B, CATCH;
extern envpo	E, CE;
extern twoBytes	ERROR;

extern bool	gc_test();
extern double	usertime();
extern char	*installdir();

extern jmp_buf	icp_interrupt;

#define throw(n)	{ ERROR = (twoBytes)(n); \
			  B = CATCH;		 \
			  return(FAIL); }
