#!/bin/sh

# if you want to run the icp system from a directory other than the
# installed one, set the environment variable ICP_INSTALLDIR.

changequote(,)
ARCH=`/bin/arch`

ICP_INSTALLDIR=${ICP_INSTALLDIR:=@INSTALLDIR@}
export ICP_INSTALLDIR

ICP_PATH=${ICP_PATH:=.}
ICP_PATH=${ICP_PATH}:${ICP_INSTALLDIR}/prolog/skilaki
ifelse(@m4xpce@,yes, ICP_PATH=${ICP_PATH}:${ICP_INSTALLDIR}/prolog/xpce)
export ICP_PATH

if [ $# -eq 1 ]
then
	if [ $1 = "help" -o $1 = "-help" -o $1 = "-?" ]
	then
		echo "usage: `basename $0` Options"
		echo "  where Options is a combination of"
		echo "	-b FILE		: set bootfile to FILE"
		echo "	-h NUM		: set heap size to NUM K (default 48K)"
		echo "	-s NUM		: set stack size to NUM K (default 16K)"
		echo "	-n		: do not use prolog startup file"
		echo "	-nn		: do not use parlog startup file"
		echo "	-f FILE		: set prolog startup file to FILE"
		echo "	-ff FILE	: set parlog startup file to FILE"
		echo "	-z STRING	: pass query STRING to prolog"
		echo "	-zz STRING	: pass query STRING to parlog"
		echo "	-F CHARSET	: set character encoding (default latin1)"
		echo "	<other flags>	: passed to Parlog"
		exit 0
	fi
fi

exec ${ICP_INSTALLDIR}/bin/${ARCH}/icp $*
