%** meta_decl
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

/* drugs db */
template(has_age(X,Y),[],['Is',X,'''s age',Y,?]).
template(has_age(X,Y),[Y],['What is',X,'''s age?']).
template(has_age(X,Y),[X],['Who has age',Y,?]).
template(complains_of(X,Y),[],['Does',X,complain,of,Y,?]).
template(complains_of(X,Y),[Y],['What does',X,complain,of,?]).
template(complains_of(X,Y),[X],['Who complains of',Y,?]).
template(less_than(X,Y),[],['Is', (X < Y),?]).
template(less_than(X,Y),[Y],['Enter a number less than',X]).
template(less_than(X,Y),[X],['Enter a number greater than or equal to',Y]).
template(suffers_from(X,Y),[],['Does',X,suffer,from,Y,?]).
template(suffers_from(X,Y),[Y],['What does',X,suffer,from,?]).
template(suffers_from(X,Y),[X],['Who suffer from',Y,?]).
template(person(P), [P], ['Is', P, 'a person']).

ask_limits(has_age(_,Y), [Y], (1,1)).

default_answer(complains_of(_,Y), [Y], [pain]).
default_answer(complains_of(_,Y), [Y], [diarrhoea]).

suggested_answer(complains_of(_,Y), [Y], [diarrhoea]).
suggested_answer(complains_of(_,Y), [Y], [pain]).
suggested_answer(complains_of(X,Y), [X,Y], [fred, diarrhoea]).

default_answer(complains_of(X,Y), [X,Y], [fred, pain]).

valid_answer(has_age(_,Y), [Y]) :-
	integer(Y),
	Y > 0,
	Y < 150.

