%** icp_compat
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/
/* user_channels(In, Out). */
user_channels(user_input, user_output).

builtin(Term) :- predicate_property(Term, system).

toground5(Term,Gterm,Vars,VarNames,UsedNames) :-
	toground(Term,Gterm,Vars,VarNames,UsedNames).

f_vread(File, Clause, VN) :-
	gread(File, GClause, VarNames),
	tohollow(GClause, Clause, VarNames, Vars),
	join_lists(Vars, VarNames, VN).

isin(_,T) :- var(T), !, fail.
isin(X,[H|_]) :- X == H.
isin(X,[_|T]) :- nonvar(T), isin(X,T).

adddict(Term, List, List) :-
	memberdict(Term, List),
	!.
adddict(Term, List, [Term|List]).

memberdict((V=N), [(V1=N)|_]) :- V == V1, !.
memberdict((V=N), [(V=N1)|_]) :- N == N1, !.
memberdict((V=N), [_|Rest]) :- memberdict((V=N), Rest).

splitdict([], [], []).
splitdict([H1=H2|Rest], [H1|Rest1], [H2|Rest2]) :-
	splitdict(Rest, Rest1, Rest2).

toground(Term) :- numbervars(Term, 0, _).
