%** negation
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

do_negation(on,Conj,Uvars,Vu,Residue,Pruf,ResPrufs,Qin,Qout) :- !,
	varsin(Uvars,Vu),
	findAllResidues(Conj,Vu,Residue,Pruf,AnswerList),
	processResList(AnswerList,Vu,ResPrufs,Qin,Q),
	reduceResidue(negation, Q, Qout).
do_negation(off,Conj,_,_,_,_,_,_,_) :- 
	call(Conj), !, fail.
do_negation(off,_,_,_,_,_,residues_off,Qin,Qin).

/************************************************************
Uses a findall which stops if an unconditional solution, without 
binding of variables, is found.
If negation results in binding of variable, forms part of conditional
answer.
eg.
		x(a)       y(X) :- not(x(X))
should give
		y(X) if X \= a
Residues will appear on list in order found (FIFO) - see collectList
************************************************************/

findAllResidues(Conj,Vu,Residue,Pruf,AnswerList) :-
	findall([Vu,Actual,Pruf],
		stopOnCheck(
			Conj,
			(Residue = []-[], varsin(Vu,Vu), Actual = stop),
			(Actual = Residue)
		), AnswerList
	),
	!,
	\+ member([_,stop,_], AnswerList).

stopOnCheck(Goal, Check,CheckFail) :-
	Goal,
	(Check-> !; CheckFail).

/************************************************************
processing residues (and proofs) found
this puts final residues on Qin in reverse order - consistent with
qualification order everywhere else
************************************************************/
processResList([],_,[],Quals,Quals) :- !.
processResList([[Bindings,PQ-NQ,Pruf]|X],Vu,[Pruf|Y],PQin-NQin,Qout) :-
	addEqualities(Vu,Bindings,PQ,PQ1),
	negateList(PQ1, NQ, PQ2, NQ2),
	append(PQ2, PQin, PQ3),
	append(NQ2, NQin, NQ3),
	!,
	processResList(X,Vu,Y,PQ3-NQ3, Qout).

negateList([], not(NP-NN), NN, NP) :- !.
negateList(P, N, [], [not(P-N)]).

addEqualities([],[],Residue,Residue) :- !.
addEqualities([Var|X], [Binding|Y],Residue, FullResidue) :-
	constructEquality(Var,Binding,FullResidue,More), !,
	addEqualities(X,Y,Residue,More).

constructEquality(Var,Binding,More,More) :- 
	var(Binding),!,
	Binding = Var.
constructEquality(Var,Binding,[Var=Binding |More],More).

