%** residue
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

final_reduceResidue(on, PQi-NQi, Qo) :-
	eliminatePositiveEqualities(PQi, PQ1),
	simplifyPredicates(PQ1-NQi, Q2, Status),
	!,
	Status = true,
	maybe_more_final_reduction(PQ1-NQi, Q2, Qo).
final_reduceResidue(off, Q, Q).

maybe_more_final_reduction(Q, Q, Q) :- !.
maybe_more_final_reduction(_, Qi, Qo) :- !,
	final_reduceResidue(on, Qi, Qo).

eliminatePositiveEqualities([], []) :- !.
eliminatePositiveEqualities([X=Y|Rest], Reduced) :-
	X = Y, !,
	write('ran equality '), write(X=Y),nl,
	eliminatePositiveEqualities(Rest, Reduced).
eliminatePositiveEqualities([Head|Rest], [Head|Reduced]) :-
	!,
	eliminatePositiveEqualities(Rest, Reduced).

reduceResidue(Type, Qi, Qo) :-
	reduceStatus(Type, on),
	!,
	reduceResidue(Qi, Qo).
reduceResidue(_, Q, Q).

reduceResidue(Qi, Qo) :-
	simplifyPredicates(Qi, Qo, Status),
	!,
	Status = true.
reduceResidue(Q,Q) :-
	write('Reduce residue failed for'-Q), nl.

simplifyPredicates(Qi, Qo, Status) :-
	simplifyPreds(Qi, Qo1, [], Status1),
	!,
	maybe_simplify_again(Qi, Qo1, Status1, Qo, Status).

maybe_simplify_again(Q, Q, Status, Q, Status) :- !.
maybe_simplify_again(_, _, fail, [], fail) :- !.
maybe_simplify_again(Qi, Q, true, Qo, Status) :-
	write('********************************************'),nl,
	write(Qi), nl,
	write('->'), write(Q), nl,
	write('********************************************'),nl,
	!,
	simplifyPredicates(Q, Qo, Status).

simplifyPreds(PQi-NQi, Qo, Delete, Status) :-
	simplifyPositive(PQi, PQo, Delete, PStatus), !,
	continueSimplifyPreds(PStatus, PQo, NQi, Qo, Delete, Status).

continueSimplifyPreds(fail, _, _, []-[], _, fail) :- !.
continueSimplifyPreds(true, PQi, NQi, PQo-NQo, Delete, Status) :-
	append(PQi, Delete, NewDelete), !,
	simplifyNegative(NQi, PQi, NQo, PQo, NewDelete, Status).

simplifyPositive([], [], _, true) :- !.
simplifyPositive([A=B|Rest], Simplified, Delete, Status) :-
	A == B,
	write('located valid equality         >'), write(A=B), write('<'), nl,
	!,
	simplifyPositive(Rest, Simplified, Delete, Status).
simplifyPositive([A=B|_], [], _, fail) :-
	\+ A = B,
	!,
	write('located unsatisfiable equality >'), write(A=B), write('<'), nl.
simplifyPositive([Goal|Rest], Simplified, Delete, Status) :-
	exactlyOn(Delete, Goal),
	write('located identical goal         >'), write(Goal), write('<'), nl,
	!,
	simplifyPositive(Rest, Simplified, Delete, Status).
simplifyPositive([builtin(Goal)|Rest], Simplified, Delete, Status) :-
	builtinResidue(Goal, Test),
	\+ call(Test),
	write('located evaluable builtin    >'), write(Goal), write('<'), nl,
	!,
	call(Goal),
	simplifyPositive(Rest, Simplified, Delete, Status).
simplifyPositive([Goal|Rest], [Goal|Simplified], Delete, Status) :-
	simplifyPositive(Rest, Simplified, Delete, Status).

simplifyNegative([], PQ, [], PQ, _, true) :- !.
simplifyNegative([not(NegQi)|NQi], PQi, NQo, PQo, Delete, Status) :-
	!,
	simplifyPreds(NegQi, NegQo, Delete, NStatus),
	!,
	continueNeg(NStatus, NegQo, NQi, PQi, NQo, PQo, Delete, Status).
simplifyNegative(Goal, _, _, _, _, _) :-
	write('******'-'Unexpected Negative Goal List'-Goal), !, fail.

continueNeg(fail, _, NQi, PQi, NQo, PQo, Delete, Status) :- !,
	simplifyNegative(NQi, PQi, NQo, PQo, Delete, Status).
continueNeg(true, []-[], _, _, _, _, _, fail) :- !.
continueNeg(_, []-[not(PQ-NQ)], NQi, PQi, NewNQo, PQo, Delete, Status) :-
	append(PQ, PQi, NewPQi),
	append(PQ, Delete, NewDelete),
	append(NQ, NQo, NewNQo),
	!,
	simplifyNegative(NQi, NewPQi, NQo, PQo, NewDelete, Status).
continueNeg(_, NegQo, NQi, PQi, [not(NegQo)|NQo], PQo, Delete, Status) :-
	simplifyNegative(NQi, PQi, NQo, PQo, Delete, Status).

/* fails if finds a 'good' match */
exactlyOn([Goal|_], Search) :-
	Goal == Search, !.
exactlyOn([Goal|Rest], Search) :-
	\+ \+ Goal = Search,
	!,
	write('unifiable goal found '), write(Goal), nl,
	exactlyOn(Rest, Search).
exactlyOn([_|Rest], Search) :-
	exactlyOn(Rest, Search).

reduceStatus(Type, Status) :-
	getCompilerOptions([quals,reduce],[on,on]), !,
	Status = on,
	reduceType(Type).

reduceType(final).
reduceType(resolution) :- getCompilerOptions([redRes], [on]).
reduceType(qualification) :- getCompilerOptions([redQual], [on]).
reduceType(negation) :- getCompilerOptions([redNeg], [on]).

