%** runtime
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

find_residue(Goal,Flags,Quals,Proof, VN) :-
	findUniversalVars(Goal,Uvars),
	translateBody(Goal,Uvars,TGoal,Extras,_,query, VN), 
	Extras = extras(Flags,[],q([]-[],QualsF),Proof, Proof, _),
	(
		Flags = flags(_,on,_)
	->
		reduceStatus(final, Reduce)
	;
		Reduce = off
	), !,
	call(TGoal),
	final_reduceResidue(Reduce, QualsF, QualsF1),
	beautify_quals(QualsF1, Quals).

beautify_quals(PQ-NQ, Quals) :-
	beautify_negated_quals(NQ, NQ1), !,
	reverse(PQ, PQ1),
	append(PQ1, NQ1, Quals).

beautify_negated_quals([], []) :- !.
beautify_negated_quals([not(Q)|R], [not(Q1)|R1]) :-
	beautify_quals(Q, Q1), !,
	beautify_negated_quals(R, R1).

invoke_unknown(IntX,QualX, Pred, Goal, Quals, Pruf, Why, VN) :-
	getStubberType(Pred, Type),
	member(Type, ['qualifier only', interactive]), !,
	invoke_QtU(Type,IntX,QualX,Goal,Quals,Pruf, Why, VN).
invoke_unknown(_, _, _, Goal, q(Q,Q), prolog(Goal), _, _) :-
	call(Goal).

invoke_QtU(Type, IntX, _,Goal,q(Q,Q),user(Goal), Why, VN) :-
	query_external(Goal, on, IntX, Type, VN, Why).
invoke_QtU(Type, IntX, on,Goal,q(PQi-NQi,Qo),assumed(Goal), _, _) :- !,
	ok_for_residue(Type, IntX, Goal),
	reduceResidue(qualification, [Goal|PQi]-NQi, Qo).

ok_for_residue('qualifier only', _, _) :- !.
ok_for_residue(_, on, Goal) :- told_status(Goal, assumable).
ok_for_residue(_, off, Goal) :- \+ told_status(Goal, complete).

query_external(Goal, UseTolds,IntX, Type, VN, Why) :-
	extract_var_list(VN, Vars, VarNames),
	told_status(Goal, Status),
	set_prop(query, whyProof, Goal=Why),
	findall(Vars, been_told(Goal), Known), !,
	maybe_query_external(UseTolds, Status, IntX, Vars, Goal, Known, Type, VarNames).

maybe_query_external(on, _, _,  Vars, _, Known, _, _) :-
	member(Vars, Known).
/* forms
maybe_query_external(_, incomplete, on, _, Goal, _, interactive, _) :-
	Goal = link_comment(ListPreds,ListVarsAndValues),!,write(ni),nl,
	link_comment(ListPreds,ListVarsAndValues),write('no').
maybe_query_external(_, incomplete, on, _, Goal, _, interactive, _) :- 
	Goal = form(NameForm,ListVarsInput),!,
	form_user(NameForm,ListVarsInput).
*/
maybe_query_external(_, incomplete, on, Vars, Goal, Known, interactive, VN) :-
	length(Known, Number),
	query_user(Vars, Goal, Number, VN).

undefinedHook(Call, Tatom) :-	
	getCompilerOptions([error_handler], [on]),
	Call =.. [NewPred|NewArgs],
	skilakiName(Pred, NewPred),
	extraArgs(Args, NewArgs,Extras),
	fixGoal(Args, Pred, Goal),
	unknownCall(Extras, Pred, Goal, Tatom).

fixGoal([], Pred, Pred) :- !.
fixGoal(Args, Pred, Goal) :- Goal =.. [Pred|Args].


