%** stubs
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

processUndefined(Xrefs, Stubs) :-
	getCompilerOptions([error_handler], [Error]),
	makeStubs(Error, Xrefs, Stubs),
	makeStubDecls(Xrefs).

makeStubDecls([]) :- !.
makeStubDecls([pred(Pred/Arity, NewPred/NewArity)|Rest]) :-
	set_prop(Pred, d_stubCode, [NewPred,NewArity,Arity]),
	makeStubDecls(Rest).

makeStubs(on, _, []).
makeStubs(off, Xrefs, Stubs) :-
	makeStubs(Xrefs, Stubs).

makeStubs([], []) :- !.
makeStubs([pred(Pred/Arity, NewPred/_)|Rest], [stub(Pred/Arity,[NewClause])|RestNew]) :-
	makeStub(Pred, Arity, NewPred, NewClause),
	makeStubs(Rest, RestNew).

makeStub(Pred, Arity, NewPred, (NewHead:-NewBody)) :-
	functor(Goal, Pred, Arity),
	Goal =.. [Pred|Args],
	extendAtom(Pred,Args,NewPred,NewArgs,Extras),
	unknownCall(Extras, Pred, Goal, NewBody),
	NewHead =.. [NewPred|NewArgs].

maybeKillStubs(on) :- !,
	killStubs.
maybeKillStubs(off) :-
	get_cons(d_stubCode,Stubs),
	makeListStubs(Stubs).

makeListStubs([]) :- !.
makeListStubs([Pred|T]) :-
	makeListStub(Pred),
	makeListStubs(T).

makeListStub(Pred) :-
	get_prop(Pred, d_stubCode, [NewPred,_,Arity]),
	kill(NewPred),
	makeStub(Pred, Arity, NewPred, NewClause),
	assert(NewClause),
	fail.
makeListStub(_).

getStubberType(Pred, Type) :-
	get_prop(Pred, d_stubber, Type1), !,
	Type1=Type.
getStubberType(_, Type) :-
	getCompilerOptions([stubber], [Type]).

killStubs :-
	get_cons(d_stubCode,Stubs),
	killObsoleteStubs(Stubs),
	del_cons(d_stubCode),
	del_cons(d_stubber).

killObsoleteStubs([]) :- !.
killObsoleteStubs([Stub|Stubs]) :-
	get_prop(Stub,d_stubCode,[StubSource|_]),
	kill(StubSource),
	!,
	killObsoleteStubs(Stubs).

deleteStubDeclaration(Rel) :-
	del_prop(Rel, d_stubCode),
	del_prop(Rel,d_stubber).

declareDoggieRelifNeeded(Selection, Pred) :-
		getStubberType(Pred, Selection), !.
declareDoggieRelifNeeded(Selection, Pred) :-
	declareDoggieRel(Selection, Pred).

declareDoggieRel(Type,Rel) :- 
	member(Type, [interactive, 'qualifier only', neither]),
	set_prop(Rel,d_stubber,Type).

change_undefined :-
	get_cons(d_stubCode,Stubs),
	changeUndefinedDialog(Stubs, Selected),
	change_undefined(Selected).

change_undefined([]) :- !.
change_undefined([Pred|T]) :-
	getStubberType(Pred, Current),
	predicateToldVal(Pred, Told),
	predicateToldStop(Pred, Stop),
	displayUnknownInfo(Told, Stop, Pred, Current, StillTold, StillStop, Selected),
	commit_deletions(Told, Stop, StillTold, StillStop),
	declareDoggieRelifNeeded(Selected, Pred),
	change_undefined(T).

cleanUndefined([], _, R, R) :- !.
cleanUndefined(tree(Key, Value, Left, Right), Dict, R1, R3) :-
	\+ defined(Value),
	\+ member(pred(Key, _), Dict), !,
	cleanUndefined(Left, Dict, R1, [pred(Key,Value)|R2]),
	cleanUndefined(Right, Dict, R2, R3).
cleanUndefined(tree(_, _, Left, Right), Dict, R1, R3) :-
	cleanUndefined(Left, Dict, R1, R2),
	cleanUndefined(Right, Dict, R2, R3).


