%** translator
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

translateClause((Head:-Body),Index,TClause,PA,Xrefs, VN) :- !,
	TClause = (THead:-FullBody), PA = Pred/Arity,
	translateAtom(Head,Pred,Arity,THead,ExtrasH, _, _), 
	ExtrasH = extras(Flags,Calls,q(Qin,Qout), p(Head,Index,PrufB), Why, _), 
	ExtrasB = extras(Flags,[Pred/Arity|Calls],q(Qred,Qout),PrufB, Why, _),
	findUniversalVars((Head,Body),Gvars), !,
	translateBody(Body,Gvars,TBody,ExtrasB,Xrefs,clause, VN),
	maybeAddFilter(TBody,Qin,Qred,FullBody).
translateClause(Atom,Index,Tatom,Pred/Arity,_, _) :- 
	Extras = extras(_,_,q(Q,Q),p(Atom,Index,[]), _, _),
	translateAtom(Atom,Pred,Arity,Tatom,Extras, _, _).

maybeAddFilter(true,Q,Q,true) :- !.
maybeAddFilter(TBody,Qin,Qred,(reduceResidue(resolution, Qin, Qred),TBody)) :-
	getCompilerOptions([quals,reduce,redRes], [on,on,on]), !.
maybeAddFilter(TBody,Q,Q,TBody).

translateBody(true,_,true, extras(_,_,q(Q,Q),[], _, _), _, _, _) :- !.
translateBody((Lit,Morelits),Gvars,(TLit,TMorelits), Extras,Xrefs,State, VN) :-
	Extras = extras(Flags,Calls,q(Qi,Qo),[PrufL|PrufB], Why, _),
	ExtrasL = extras(Flags,Calls,q(Qi,Qc),PrufL, Why, _), 
	ExtrasB = extras(Flags,Calls,q(Qc,Qo),PrufB, Why, _),
	translateLiteral(Lit,Gvars,TLit,ExtrasL,Xrefs,State, VN), !,
	translateBody(Morelits,Gvars,TMorelits,ExtrasB,Xrefs,State, VN).
translateBody(Literal,Gvars,TLiteral,Extras,Xrefs,State, VN) :- 
	translateLiteral(Literal,Gvars,TLiteral,Extras,Xrefs,State, VN).

translateLiteral(\+(Conj),Cl_vars,TLiteral,Extras,Xrefs,State, VN) :- !,
	translateNegation(Conj,Cl_vars,TLiteral,Extras,Xrefs,State, VN).
translateLiteral(not(Conj),Cl_vars,TLiteral,Extras,Xrefs,State, VN) :- !,
	translateNegation(Conj,Cl_vars,TLiteral,Extras,Xrefs,State, VN).
translateLiteral(Literal,_,TLiteral,Extras,_,_, _) :-
	specialLiteral(Literal,TLiteral,Extras), !.
translateLiteral(Atom,_,Tatom,Extras,Xrefs,State, VN) :-
	translateAtom(State, Atom,_,_,Tatom,Extras,VN, Xrefs).

translateNegation(Conj,Cl_vars,TLiteral,Extras,Xrefs,State, VN) :-
	Extras = extras(Flags,Calls,q(Qi,Qo),notp(Vu,Conj, ResidP),Why,_),
	ExtrasB = extras(Flags,Calls,q([]-[],ConjQ),ConjP, Why, _),
	Flags = flags(_,QualF,_),
	varsin(Conj, NegVars),
	intersect(Cl_vars,NegVars,Uvars),  /* uvars actually present */
	TLiteral = do_negation(QualF,TConj,Uvars,Vu,ConjQ,ConjP,ResidP,Qi,Qo), 
	/* in case nested neg later, extend universal vars I*/
	findUniversalVars((dummy(Cl_vars),Conj),Gvars),  
	translateBody(Conj,Gvars,TConj,ExtrasB,Xrefs,State, VN).

specialLiteral('!','!',extras(_,_,q(Q,Q),builtin('!'), _, _)) :- !.
specialLiteral(Literal,TLiteral,Extras) :-
	builtin(Literal),
	getCompilerOptions([quals], [on]),
	builtinResidue(Literal, Test),
	call(Test),
	TLiteral=do_builtin(QualF, Test, Literal, Proof, Qual), !,
	Extras = extras(flags(_,QualF,_),_,Qual,Proof, _, _).
specialLiteral(Literal,Literal,Extras) :-
	builtin(Literal), !,
	Extras = extras(_,_,q(Q,Q),builtin(Literal), _, _).
specialLiteral(Literal,Literal,Extras) :-
	functor(Literal, Pred, Arity),
	defined(Pred/Arity),
	Extras = extras(_,_,q(Q,Q),prolog(Literal), _, _).

translateAtom(clause, Atom,Pred,Arity,Tatom,Extras,VN, Xrefs) :- !,
	translateAtom(Atom,Pred,Arity,Tatom,Extras,VN, Xrefs).
translateAtom(query, Atom,Pred,Arity,Tatom,Extras,VN, Xrefs) :-
	translateAtom(Atom,Pred,Arity,PossTatom,Extras,VN, Xrefs),
	possibleDirectUnknown(PossTatom, Tatom,Atom,Extras, VN).

translateAtom(Atom,Pred,Arity,Tatom,Extras,VN, Xrefs) :-
	Atom =.. [Pred|Args],
	length(Args,Arity),
	extendAtom(Pred,Args,NewPred,NewArgs,Extras),
	fix_var_names(VN, Args, VNames),
	Extras = extras(_,_,_,_, _, VNames),
	Tatom =.. [NewPred|NewArgs],
	length(NewArgs, NewArity),
	insertOccurrence(Pred/Arity, NewPred/NewArity, Xrefs).

possibleDirectUnknown(Tatom, Tatom,_,_,_) :-
	functor(Tatom, Pred, Arity),
	defined(Pred/Arity), !.
possibleDirectUnknown(Tatom, Tatom,_,_,_) :-
	getCompilerOptions([error_handler], [on]).
possibleDirectUnknown(_, Tatom,Goal,Extras, VN) :-
	Goal =.. [Pred|Args],
	fix_var_names(VN, Args, VNames),
	Extras = extras(_,_,_,_, _, VNames),
	unknownCall(Extras, Pred, Goal, Tatom).

unknownCall(extras(flags(IntF,QualF,_), _, Quals, Proof, Why, VN), Pred, Goal, Call) :-
	Call = invoke_unknown(IntF,QualF,Pred,Goal,Quals,Proof,Why,VN).

extendAtom(Pred,Args,NewPred,NewArgs,Extras) :-
	skilakiName(Pred,NewPred),
	extraArgs(Args, NewArgs, Extras).

argumentForm([X|Y],[X,Extras|Y],extras(Flags,Calls,Quals,Proof,Why,VarNames)) :-
	getCompilerOptions([int,quals,proof,why,leash],
			[IntC,QualC,ProofC,WhyC,LeashC]),
	Flags = flags(IntF,QualF,LeashF),
	sometimesSet(IntC,IntF),
	sometimesSet(QualC,QualF),
	sometimesSet(LeashC,LeashF),
	addArgument(LeashC,Calls,Rest,CallsIn),
	addArgument(QualC,Quals,CallsIn,WhyIn),
	addArgument(ProofC,Proof,WhyIn,QualsIn),
	addArgument(WhyC,Why,QualsIn,[VarNames]),
	Extras =.. [extras,Flags|Rest].
argumentForm([],[Extras],ExtrasF) :-
	argumentForm([_],[_,Extras],ExtrasF).

addArgument(on,Arg,[Arg|Rest],Rest).
addArgument(off,_,Rest,Rest).

sometimesSet(off,off).
sometimesSet(on,_).

chokerClause(Pred, Arity,(Head:-Body)) :-
	length(Args,Arity), 
	extendAtom(Pred,Args,NewPred,NewArgs,Extras), !,
	Head =.. [NewPred|NewArgs], ThisGoal =.. [Pred|Args],
	Extras = extras(Flags,[X|Calls],q(Qin,Qout),choked(ThisGoal), _, _),
	Flags = flags(_,_,on),
	(
		reduceStatus(resolution, on)
	->
		Body = (member(Pred/Arity,[X|Calls]),!,reduceResidue(resolution, Qin,Qred)),
		Qout = [choked(ThisGoal)|Qred]
	;
		Body = (member(Pred/Arity,[X|Calls]),!),
		Qout = [choked(ThisGoal)|Qin]
	).


/* any variable inside negation only is existential; all others universal */
findUniversalVars(Conj,Gvars) :-
	positiveAtoms(Conj,Atoms), !,
	varsin(Atoms,Gvars).

positiveAtoms(not(_), dummy) :- !.
positiveAtoms((A,B),(AA,BB)) :- !,
	positiveAtoms(A,AA), positiveAtoms(B,BB).
positiveAtoms(A,A).

intersect([],_,[]) :- !.
intersect([U|X],Other,Result) :-
	(on_exactly(U,Other) -> Result=[U|More] ; Result=More), !,
	intersect(X,Other,More).

on_exactly(U,[V|_]) :- U == V, !.
on_exactly(U,[_|X]) :- on_exactly(U,X).

insertOccurrence(PA, New, tree(PA, New, _, _)) :- !.
insertOccurrence(PA, New, tree(PA1, _, L, _)) :-
	PA @< PA1, !,
	insertOccurrence(PA, New, L).
insertOccurrence(PA, New, tree(_, _, _, R)) :-
	insertOccurrence(PA, New, R).

skilakiName(Name, CompiledName) :-
	concat('## ', Name, CompiledName).

fix_var_names(VN, _, VN) :-
	var(VN), !.
fix_var_names(VN, Args, VNames) :-
	varsin(Args, Vars),
	extract_sub_list(Vars, VN, VNames).

