%** utilities
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

de_listify([], true) :- !.
de_listify([A], A) :- !.
de_listify([A|LB], (A, B)) :- de_listify(LB, B).

flatten([], R, R) :- !.
flatten(tree(Key, Value, Left, Right), R1, R3) :-
	flatten(Left, R1, [pred(Key,Value)|R2]),
	flatten(Right, R2, R3).

read_dialog(dlg(Desc,Button), Button) :-
	Call =.. [dialog|Desc],
	call(Call), !.
read_dialog(_, 2).   /* failed, so button 2 */

valuesdict([], _, []).
valuesdict([Key|RestK], Dict, [Value|RestV]) :-
	member((Key=Value), Dict), !,
	valuesdict(RestK, Dict, RestV).

update_dict([], New, New).
update_dict([(Key=_)|Old], Change, [(Key=Value)|New]) :-
	remove((Key=Value), Change, Change1), !,
	update_dict(Old, Change1, New).
update_dict([(Key=Value)|Old], Change, [(Key=Value)|New]) :-
	update_dict(Old, Change, New).

join_lists([], [], []) :- !.
join_lists([H1|T1], [H2|T2], [(H1=H2)|T]) :- !,
	join_lists(T1, T2, T).

extract_sub_list([], _, []) :- !.
extract_sub_list([Var|Rest], List, [(Var=Name)|New]) :-
	member((Key=Name), List),
	Key == Var, !,
	extract_sub_list(Rest, List, New).

extract_var_list([], [], []) :- !.
extract_var_list([(Var=Name)|Rest], [Var|Vars], [Name|Names]) :-
	var(Var), !,
	extract_var_list(Rest, Vars, Names).
extract_var_list([_|Rest], Vars, Names) :-
	!,
	extract_var_list(Rest, Vars, Names).

terms_to_atoms([], []) :- !.
terms_to_atoms([T|RT], [A|RA]) :-
	pname(T, A), !,
	terms_to_atoms(RT, RA).

subsumes(General, Term) :-
	\+ \+ (toground(Term),General = Term).

