/* Copyright (C) 1992 Imperial College */
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <limits.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "fd_events.h"


/*
 *	In the execute_event() function (sched.c) it has to be added code for 
 *	the events E_ASYNC_READ and E_ASYNC_EXCEPT. These events will call to
 *	the global_read_select() and global_except_select() functions.
 */
#define procptr					void *
#define is_a_parlog_process(proc_ptr)		(GET_PROC_TYPE(proc_ptr) == PARLOG_MACH)
#define is_a_prolog_process(proc_ptr)		(GET_PROC_TYPE(proc_ptr) == PROLOG_MACH)

/*
 *		Process Macros
 */
#define PARLOG_MACH			0x00000000
#define PROLOG_MACH			0x80000000

#define PT_MASK				0x80000000
#define PPROC_MASC			0x00FFFFFF
#define PPROC_SHIFT			0
#define MK_PARLOG_PROC_PTR(proc)	((procptr)((PARLOG_MACH)|(((int)(proc))<<PPROC_SHIFT)))
#define MK_PROLOG_PROC_PTR(proc)	((procptr)((PROLOG_MACH)|(((int)(proc))<<PPROC_SHIFT)))
#define GET_PROC_NUMB(proc)		((procptr)(((unsigned)(proc)&PPROC_MASC)>>PPROC_SHIFT))
#define GET_PROC_TYPE(proc)		((unsigned)(proc)&PT_MASK)
/*
 *
 */

#define FD_READ		0
#define FD_WRITE	1
#define FD_EXCEPT	2
#define NTYPES		3

#define POLL	0
#define BLOCK	UINT_MAX

#define OK	0
#define TIMEOUT	1

#define FALSE	0
#define TRUE	1

/*
 *	The next variable it's a variabale from the JAM machine
 */

/* ...
struct fd_request {
	struct fd_request 	*next;
	unsigned	time;
	int		status;
	int		type;
	int		fd;
	procptr		proc_ptr;
	};
 ... */


struct request_queue {
	struct fd_request *request;
	int		msg_avail;
	int 		error;
	};

typedef	functptr		fa[NTYPES];
typedef	struct request_queue	re[NTYPES];

struct event {
	int	type;
	union {
		fa	*function;
		re	*requ;
		} u;
	};
static struct event *events;

#define TYPE(fd)		(events[(fd)].type)
#define FUNCTION(fd,ty)		((*(events[(fd)].u.function))[(ty)])
#define REQ(fd,ty)		((*(events[(fd)].u.requ))[(ty)])
#define is_system_event(fd)	(TYPE(fd) == SYSTEM)
#define is_user_event(fd)	(TYPE(fd) == USER)
#define isnt_user_event(fd)	(TYPE(fd) != USER)

static int initialise = FALSE;

static int pwec[NTYPES] = {0 , 0 , 0};	/* process waiting for (read, write, except) events counter	*/
static int pgid;
static int kb;

fd_set	check_mask;
static int	num_fd;
static struct timeval timeout;

#define get_pwec(ty)			(pwec[ty])

#define max(x, y)			(((x)>=(y))?(x):(y))
#define time_conversion(x)		(((x)==POLL)?POLL:((x)==BLOCK)?BLOCK:((x)+time(NULL)))
#define isasynchtype(ty)		((ty == FD_READ)||(ty == FD_EXCEPT))
#define ispolltype(ty)			(ty == FD_WRITE)
#define free_request(x)			free(x)
#define set_error(fd, type, errnum)	REQ((fd),(type)).error = (errnum);
#define first(qptr)			((qptr)->next)
#define last(qptr)			(qptr)
#define set_ok(fd, type)		REQ((fd),(type)).request = 			\
						set_status_ok_and_resume_first(REQ((fd),(type)).request)
#define set_timeout(fd, type, time)	REQ((fd),(type)).request = 			\
						set_status_timeout_and_resume(REQ((fd),(type)).request, (time))

/*---------------------------------------------------------------------------*/
inc_pwec(type)
int type;
{
	if (initialise)
		++pwec[type];
}
/*---------------------------------------------------------------------------*/
dec_pwec(type)
int type;
{
	if (initialise)
		--pwec[type];
}
/*---------------------------------------------------------------------------*/
int
proc_waiting_for_events()
{
	if (!initialise) {
		return(FAIL); }
	return(pwec[FD_READ]+pwec[FD_WRITE]+pwec[FD_EXCEPT]);
}
/*---------------------------------------------------------------------------*/
int
set_asynch(fd, type, funct_read, funct_write, funct_except)
int 		fd;
int 		type;	/* SYSTEM || USER	*/
functptr	funct_read, funct_write, funct_except;
{
	int err = 0;

	if (!initialise) {
		return(-4); }
	if (fcntl(fd, F_SETOWN, pgid) == -1) {
		err += -2; }
	if (fcntl(fd, F_SETFL, FASYNC) == -1) {
		err += -1; }
	FD_SET(fd, &check_mask);
	num_fd = max(num_fd, fd+1);
	if ((is_system_event(fd))&&(events[fd].u.function))
		free(events[fd].u.function);
	else if ((is_user_event(fd))&&(events[fd].u.requ))
		free(events[fd].u.requ);
	TYPE(fd) = type;
	if (is_system_event(fd)) {
		events[fd].u.function = (fa *)malloc(sizeof(fa));
		FUNCTION(fd,FD_READ) = funct_read;
		FUNCTION(fd,FD_WRITE) = funct_write;
		FUNCTION(fd,FD_EXCEPT) = funct_except;}
	else {
		events[fd].u.requ = (re *)malloc(sizeof(re));
		REQ(fd,FD_READ).request = NULL;
		REQ(fd,FD_READ).msg_avail = 0;
		REQ(fd,FD_WRITE).request = NULL;
		REQ(fd,FD_WRITE).msg_avail = 0;
		REQ(fd,FD_EXCEPT).request = NULL;
		REQ(fd,FD_EXCEPT).msg_avail = 0;}
	return(err);
}
/*---------------------------------------------------------------------------*/
int
set_synch(fd)
int fd;
{
	int err = 0, i;

	if (!initialise) {
		return(-4); }
	if (fcntl(fd, F_SETFL, 0) == -1) {
		err += -1; }
	FD_CLR(fd, &check_mask);
	if (fd == num_fd+1) {
		for (i = fd-1; (i >= 0)&&(! FD_ISSET(i, &check_mask)); --i)
			;
		num_fd = i + 1; }
	if ((is_system_event(fd))&&(events[fd].u.function))
		free(events[fd].u.function);
	else if ((is_user_event(fd))&&(events[fd].u.requ))
		free(events[fd].u.requ);
	TYPE(fd) = NULL;
	return(err);
}
/*---------------------------------------------------------------------------*/
resume_process(proc_ptr)
unsigned proc_ptr;
{
#ifdef HERMES
	if (is_a_parlog_process(proc_ptr))
		resume_parlog_proc(GET_PROC_NUMB(proc_ptr));
	else
#endif
		resume_prolog_proc(GET_PROC_NUMB(proc_ptr));
}
/*---------------------------------------------------------------------------*/
static struct fd_request *set_status_timeout_and_resume(qptr, ti)
struct fd_request *qptr;
int ti;
{
	struct fd_request *ptr;

	if (qptr) {
		ptr = last(qptr);
		while (ptr->next != last(qptr))
			if (ptr->next->time <= ti) {
				ptr->next->status = TIMEOUT;
				resume_process(ptr->next->proc_ptr);
				ptr->next = ptr->next->next; }
			else
				ptr = ptr->next;
		if (last(qptr)->time <= ti) {
			last(qptr)->status = TIMEOUT;
			resume_process(last(qptr)->proc_ptr);
			if (first(qptr) == last(qptr))
				return(NULL);
			ptr->next = first(qptr);
			return(ptr); }
		}
	return(qptr);
}
/*---------------------------------------------------------------------------*/
static struct fd_request *set_status_ok_and_resume_first(qptr)
struct fd_request *qptr;
{
	if (qptr)
		if (first(qptr) == last(qptr)) {	/* there is only one	*/
			last(qptr)->status = OK;
			resume_process(last(qptr)->proc_ptr);
			return(NULL); }
		else {
			first(qptr)->status = OK;
			resume_process(first(qptr)->proc_ptr);
			first(qptr) = first(qptr)->next;
			return(last(qptr)); }
	return(qptr);
}
/*---------------------------------------------------------------------------*/
static struct fd_request *enqueue(rr, qptr)
struct fd_request *rr, *qptr;
{
	if (qptr) {
		first(rr) = first(qptr);
		first(qptr) = last(rr);
		return(last(rr)); }
	else {
		first(rr) = last(rr);
		return(last(rr)); }
}
/*---------------------------------------------------------------------------*/
struct fd_request *
c_make_fd_request(fd, type, timeout)
int fd;
int type;		/* FD_READ, FD_WRITE, FD_EXCEPT	*/
unsigned timeout;	/* BLOCK, POLL, time	*/
{
	struct fd_request *rr;
	unsigned ti;

	if (!initialise) {
		return(NULL); }
	ti = time_conversion(timeout);

	if (! (rr = (struct fd_request *)malloc(sizeof(struct fd_request)))) {
		set_error(fd, type, MEMORY_ERR);
		return(NULL); }
	rr->time = ti;
	rr->type = type;
	rr->fd = fd;
	rr->proc_ptr = NULL;	/* to be safe	*/

	return(rr);
}
/*---------------------------------------------------------------------------*/
int
c_enqueue_fd_request(req, mach_type)
struct fd_request *req;
unsigned mach_type;
{
	if (!initialise) {
		return(FAIL); }
	if (isnt_user_event(req->fd)) {
		return(FAIL); }
	if (req->proc_ptr)		/* It has been resumed	*/
		if (req->status == OK) {
			dec_pwec(req->type);
			free_request(req);
			return(SUCCESS); }
		else {
			dec_pwec(req->type);
			set_error(req->fd, req->type, TIMEOUT_ERR);
 			free_request(req);
			return(FAIL); }
						/*	Check for msg available	*/
	if (REQ(req->fd,req->type).msg_avail) {
		REQ(req->fd,req->type).msg_avail = 0;
		free_request(req);
		return(SUCCESS); }
						/* Enqueue the request and Suspend itself	*/
	if ((ispolltype(req->type))&&(get_pwec(req->type) == 0))
		activate_write_poll();
	inc_pwec(req->type);

#ifdef HERMES
	if (mach_type == PARLOG)
		req->proc_ptr = MK_PARLOG_PROC_PTR(GetParlogProcessPtr(0));
	else
#endif
		req->proc_ptr = MK_PROLOG_PROC_PTR(GetPrologProcessPtr(0));

	REQ(req->fd,req->type).request = enqueue(req,REQ(req->fd,req->type).request);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
void
global_read_select()
{
	fd_set	read_mask;
	int fd;
	int ti;

	ti = time(NULL);

	read_mask = check_mask;
	if (select(num_fd, &read_mask, (fd_set *)NULL, (fd_set *)NULL, &timeout) < 0)
		return;
	for (fd = 0; fd < num_fd; ++fd)
		if (FD_ISSET(fd, &read_mask))
			if (is_system_event(fd))
				FUNCTION(fd,FD_READ)(fd);
			else /* if (is_user_event(fd)) */
				if (REQ(fd,FD_READ).request)
					set_ok(fd, FD_READ);
				else
					REQ(fd,FD_READ).msg_avail = 1;
		else if (is_user_event(fd))
				set_timeout(fd, FD_READ, ti);
}
/*---------------------------------------------------------------------------*/
void
read_select(fd)
int fd;
{
	fd_set	read_mask;
	int ti;

	ti = time(NULL);

	FD_ZERO(&read_mask);
	FD_SET(fd, &read_mask);
	if (select(fd+1, &read_mask, (fd_set *)NULL, (fd_set *)NULL, &timeout) < 0)
		return;
	if (FD_ISSET(fd, &read_mask))
		if (is_user_event(fd))
			if (REQ(fd,FD_READ).request)
				set_ok(fd, FD_READ);
			else
				REQ(fd,FD_READ).msg_avail = 1;
		else /* if (is_system_event(fd)) */
			FUNCTION(fd,FD_READ)(fd);
	else if (is_user_event(fd))
			set_timeout(fd, FD_READ, ti);
}
/*---------------------------------------------------------------------------*/
void
global_except_select()
{
	fd_set	except_mask;
	int fd;
	int ti;

	ti = time(NULL);

	except_mask = check_mask;
	if (select(num_fd, (fd_set *)NULL, (fd_set *)NULL, &except_mask, &timeout) < 0)
		return;
	for (fd = 0; fd < num_fd; ++fd)
		if (FD_ISSET(fd, &except_mask))
			if (is_system_event(fd))
				FUNCTION(fd,FD_EXCEPT)(fd);
			else /* if (is_user_event(fd)) */
				if (REQ(fd,FD_EXCEPT).request)
					set_ok(fd, FD_EXCEPT);
				else
					REQ(fd,FD_EXCEPT).msg_avail = 1;
		else if (is_user_event(fd))
				set_timeout(fd, FD_EXCEPT, ti);
}
/*---------------------------------------------------------------------------*/
void
except_select(fd)
int fd;
{
	fd_set	except_mask;
	int ti;

	ti = time(NULL);

	FD_ZERO(&except_mask);
	FD_SET(fd, &except_mask);
	if (select(fd+1, (fd_set *)NULL, (fd_set *)NULL, &except_mask, &timeout) < 0)
		return;
	if (FD_ISSET(fd, &except_mask))
		if (is_user_event(fd))
			if (REQ(fd,FD_EXCEPT).request)
				set_ok(fd, FD_EXCEPT);
			else
				REQ(fd,FD_EXCEPT).msg_avail = 1;
		else /* if (is_system_event(fd)) */
			FUNCTION(fd,FD_EXCEPT)(fd);
	else if (is_user_event(fd))
			set_timeout(fd, FD_EXCEPT, ti);
}
/*---------------------------------------------------------------------------*/
void
global_write_select()
{
	fd_set	write_mask;
	int fd, ti;

	ti = time(NULL);

	write_mask = check_mask;
	if (select(num_fd, (fd_set *)NULL, &write_mask, (fd_set *)NULL, &timeout) < 0)
		return;
	for (fd = 0; fd < num_fd; ++fd)
		if (FD_ISSET(fd, &write_mask))
			if (is_system_event(fd))
				FUNCTION(fd,FD_WRITE)(fd);
			else /* if (is_user_event(fd)) */
				if (REQ(fd,FD_WRITE).request)
					set_ok(fd, FD_WRITE);
				else
					REQ(fd,FD_WRITE).msg_avail = 1;
		else if (is_user_event(fd))
				set_timeout(fd, FD_WRITE, ti);
}
/*---------------------------------------------------------------------------*/
void
write_select(fd)
int fd;
{
	fd_set	write_mask;
	int ti;

	ti = time(NULL);

	FD_ZERO(&write_mask);
	FD_SET(fd, &write_mask);
	if (select(fd+1, (fd_set *)NULL, &write_mask, (fd_set *)NULL, &timeout) < 0)
		return;
	if (FD_ISSET(fd, &write_mask))
		if (is_user_event(fd))
			if (REQ(fd,FD_WRITE).request)
				set_ok(fd, FD_WRITE);
			else
				REQ(fd,FD_WRITE).msg_avail = 1;
		else /* if (is_system_event(fd)) */
			FUNCTION(fd,FD_WRITE)(fd);
	else if (is_user_event(fd))
			set_timeout(fd, FD_WRITE, ti);
}
/*---------------------------------------------------------------------------*/
write_poll()
{
	global_write_select();
	if (get_pwec(FD_WRITE)) {
		/* Requeue in Run Queue     OJOJOJOJOJO */
		}
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
activate_write_poll()
{
	/*	OJOJOJOJOJOJO	*/
}
/*---------------------------------------------------------------------------*/
int
c_init_fd_events()
{
	extern void sig_io(), sig_urg();

	if (initialise) {
		return(-1); }
	initialise = TRUE;
	
/*	This is the reason for SIGTTIN during debugging !!
	if (setpgid(0,0) == -1) {
		return(-1); }
*/
	pgid = getpid();

	kb = fileno(stdin);

	events = (struct event *)calloc(getdtablesize(), sizeof(struct event));

	timeout.tv_sec = 0;
	timeout.tv_usec = 0;

	FD_ZERO(&check_mask);
	num_fd = 0;

	signal(SIGIO, sig_io);
	signal(SIGURG, sig_urg);

	return(0);
}
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
