/* Copyright (C) 1992 Imperial College */
#include <limits.h>
#include <stdio.h>

#ifndef FAIL
#	define FAIL			0
#	define SUCCESS			1
#	define SUSPEND_FOR_EVENT	4
#endif

#define POLL			0
#define BLOCK			UINT_MAX

#define PRIVATE			static
#define	PUBLIC

#define BUFINTSIZE		512
#define BUFCHARSIZE		(BUFINTSIZE*sizeof(int))

#define PARLOG			0
#define PROLOG			1

#define NORMAL			0x00000100
#define OOB			0x00000200

#define OPEN			0x00000000	/* it isn't used	*/
#define SEND			0x00000001
#define LSEND			0x00000002
#define RECV			0x00000003
#define LOOK			0x00000004
#define COMMIT			0x00000005
#define DISCARD			0x00000006
#define CHECKRECV		0x00000007
#define CLOSE			0x00000008
#define LINK_I			0x00000009
#define LINK_O			0x0000000A
#define UNLINK_I		0x0000000B
#define UNLINK_O		0x0000000C
#define GETLINKS		0x0000000D
#define CLEAR			0x0000000E
#define BIND			0x0000000F
#define GETID			0x00000010
#define GETNAME			0x00000011
#define INIT			0x00000012
#define GETIDNAME		0x00000013
#define CLOSEDBPTR		0x00000014

#define MASK_OOB		0x00000F00
#define MASK_TYPE		0x000000FF

#define MK_OPERATION(ty,op)		((ty)|(op))
#define GET_OOB(type)			((type) & MASK_OOB)
#define GET_TYPE(type)			((type) & MASK_TYPE)

#define USER_READ		0x00000020
#define USER_WRITE		0x00000010
#define GROUP_READ		0x00000008
#define GROUP_WRITE		0x00000004
#define OTHERS_READ		0x00000002
#define OTHERS_WRITE		0x00000001

/*
 *		REQUEST STATUS	(Error	Codes)
 */
#define	INIT_STATUS		 0
#define	OK			 1
#define	TIMEOUT			 2
#define	MCLOSED			 3
#define	PERMISS			 4
#define	LINKED			 5
#define	LOCKED			 6
#define	MEMPTY			 7
#define	SEQUENCE		 8
#define	CLOSED_MACH		 9
#define	TCP_ERR			10
#define	DUPLICATE_SRV		11
#define	SERV_NOTFOUND		12
#define	ID_NOTFOUND		13
#define	ERRCOND			14
#define EUNIFY			15

#define procptr			void *
#define data_word		data_bytes
#define Request			struct mbx_request *

typedef struct DataBytes {
	int	size;
	int	links;
	char	buff[1];
	}	*data_bytes;
struct	mbx_request	{
	struct mbx_request	*next;
	procptr		proc_ptr;
	unsigned	timeout;
	unsigned	mbx;
	unsigned	passwd;
	unsigned	operation;
	unsigned	status;
	data_word	data;
	int			euid;
	int			egid;
	};

#define alloc_p_data(x)			(alloc_dataword(x))
#define alloc_b_data(x)			(alloc_dataword(2*sizeof(int)+(x)))
#define alloc_int_data(val)		(alloc_int_dataword(val))
#define alloc_str_data(str)		(alloc_str_dataword(str))

PUBLIC int	init_mbx(/* char *machine, char *service */);
PUBLIC int	open_mailbox(/* unsigned permiss, unsigned readpwd, unsigned writepwd */);
PUBLIC Request	alloc_mbx_request(/* unsigned timeout, mbx, pwd, operat, data */);
PUBLIC int	make_mbx_request(/* void *req, unsigned proc_type, unsigned *err, unsigned *id, data_word *data */);
PUBLIC int	check_mbx_timeout( /* */);

PUBLIC data_word	alloc_dataword( /* global size */ );
PUBLIC data_word	alloc_int_dataword( /* int value */ );
PUBLIC data_word	alloc_str_dataword( /* char *str */ );
PUBLIC int		remove_dw( /* data_word data */ );
