/* Copyright (C) 1992 Imperial College */
#include "ret.h"
#include "objs.h"
#include "macros.h"
#include "instr.h"
#include "proc.h"

#include "mbx_interface.h"

#define IsInt(x)	(IsShort(x)||IsLong(x))

			/*	ATTENTION with check_mbx_timeout()	*/

	/*		TimeOuts 		*/
PRIVATE Word atom_block;
PRIVATE Word atom_poll;

	/*		Flags 			*/
PRIVATE Word atom_oob_data;
PRIVATE Word atom_normal_data;

	/*		Permiss 		*/
PRIVATE Word atom_none;
PRIVATE Word atom_read;
PRIVATE Word atom_write;
PRIVATE Word atom_read_write;

	/*		Error Codes		*/
PRIVATE Word atom_ok;
PRIVATE Word atom_timeout;
PRIVATE Word atom_closed;
PRIVATE Word atom_permiss;
PRIVATE Word atom_linked;
PRIVATE Word atom_locked;
PRIVATE Word atom_empty;
PRIVATE Word atom_sequence;
PRIVATE Word atom_closed_mach;
PRIVATE Word atom_tcp_err;
PRIVATE Word atom_duplicate_serv;
PRIVATE Word atom_serv_notfound;
PRIVATE Word atom_id_notfound;
PRIVATE Word atom_error;
PRIVATE Word atom_unify;
PRIVATE Word atom_usage;

PRIVATE Word mbx_errno;

#define CHECK_mbx_error(Err) \
	{switch (Err) { \
		case TIMEOUT: mbx_fail(atom_timeout); \
		case MCLOSED: mbx_fail(atom_closed); \
		case PERMISS: mbx_fail(atom_permiss); \
		case LINKED: mbx_fail(atom_linked); \
		case LOCKED: mbx_fail(atom_locked); \
		case MEMPTY: mbx_fail(atom_empty); \
		case SEQUENCE: mbx_fail(atom_sequence); \
		case CLOSED_MACH: mbx_fail(atom_closed_mach); \
		case TCP_ERR: mbx_fail(atom_tcp_err); \
		case DUPLICATE_SRV: mbx_fail(atom_duplicate_serv); \
		case SERV_NOTFOUND: mbx_fail(atom_serv_notfound); \
		case ID_NOTFOUND:mbx_fail(atom_id_notfound); \
		case ERRCOND: mbx_fail(atom_error); \
		case EUNIFY: mbx_fail(atom_unify); \
	} \
	mbx_fail(atom_error);}

#define CHECK_mbx_timeout(Register, Ti, Message) \
	{if (IsInt(Register)) \
		Ti = int_val(Register); \
	else if (IsConst(Register) && (Register == atom_block)) \
		Ti = BLOCK; \
	else if (IsConst(Register) && (Register == atom_poll))  \
		Ti = POLL; \
	else { \
		bu_error(Register, Message); \
		mbx_fail(atom_usage); \
	}}


#define CHECK_mbx_data_type(Register, Flag, Message) \
	{if (IsConst(Register) && (Register == atom_normal_data)) \
		Flag = NORMAL; \
	else if (IsConst(Register) && (Register == atom_oob_data)) \
		Flag = OOB; \
	else { \
		bu_error(Register, Message); \
		mbx_fail(atom_usage); \
	}}

mbx_fail(Error)	{mbx_errno = Error; return(FAIL);}

/****************************************************************/
/*              Functions Declarations                          */
/****************************************************************/
int	C_mbx_init0();
int	C_mbx_init1();
int	C_mbx_create();
int	C_mbx_send1();
int	C_mbx_recv1();
int	C_mbx_look1();
int	C_mbx_commit1();
int	C_mbx_discard1();
int	C_mbx_check1();
int	C_mbx_close1();
int	C_mbx_link_i1();
int	C_mbx_link_o1();
int	C_mbx_unlink_i1();
int	C_mbx_unlink_o1();
int	C_mbx_getlinks1();
int	C_mbx_clear1();
int	C_mbx_bind1();
int	C_mbx_getid1();
int	C_mbx_getname1();
int	C_mbx_initdb1();
int	C_mbx_getdb1();
int	C_mbx_closedb1();
int	C_mbx_req1();
int	C_mbx_req2();
int	C_mbx_req3();
int	C_mbx_req4();
int	C_mbx_error();

/*----------------------------------------------------------------------------*/
/* already defined in fd_events/parlog_iface.c
 *
 *	procptr GetParlogProcessPtr()
 *	{
 *		return(PS);
 *	}
 */
/*----------------------------------------------------------------------------*/
/* already defined in fd_events/parlog_iface.c
 *
 *	resume_parlog_proc(proc)
 *	procptr proc;
 *	{
 *		enqueue_process(proc);
 *	}
 */
/*----------------------------------------------------------------------------*/
PRIVATE char buff[BUFCHARSIZE];
PRIVATE char *read_buff;
PRIVATE int ibuf;

PRIVATE init_write_buf()
{
	ibuf = 0;
}
PRIVATE init_read_buf(buf)
char *buf;
{
	read_buff = buf;
}
PRIVATE write_to_buf(c)
char	c;
{
	buff[ibuf++] = c;
}
PRIVATE char read_from_buf()
{
	return(*read_buff++);
}
/*----------------------------------------------------------------------------*/
data_word word_to_dataword(data)
Word data;
{
	data_word res;

	init_write_buf();
	h_encoded_write(data, write_to_buf);
	res = alloc_b_data(ibuf);
	bcopy(buff,res->buff,ibuf);
	return(res);
}
/*----------------------------------------------------------------------------*/
int dataword_to_word(data, res)
data_word data;
Word res;
{
	init_read_buf(data->buff);
	return(h_encoded_read(res, read_from_buf));
}
/*----------------------------------------------------------------------------*/
int make_links_list(res)
Word res;
{
	return(unify(res,make_atom("Link_list")));
}
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* use this version if not using foreign interface			      */
/*----------------------------------------------------------------------------*/
int parlog_init_mbx(mach, serv)
char *mach, *serv;
{
	static int here = 0;

	if (init_mbx(mach, serv) == FAIL)
		return(FAIL);

	if (!here) {
/*
 *	Initialise Predefined Atoms
 */
		(void) C_mbx_init0((Word *) NULL);
/*
 *	Initialise Predicates
 */
		define_c_predicate("mbx_init0", 0, C_mbx_init0, enter_c, 1);
		define_c_predicate("mbx_init1", 2, C_mbx_init1, enter_c, 1);
		define_c_predicate("mbx_create", 6, C_mbx_create, enter_c, 1);
		define_c_predicate("mbx_send1", 6, C_mbx_send1, enter_c, 1);
		define_c_predicate("mbx_recv1", 5, C_mbx_recv1, enter_c, 1);
		define_c_predicate("mbx_look1", 5, C_mbx_look1, enter_c, 1);
		define_c_predicate("mbx_commit1", 5, C_mbx_commit1, enter_c, 1);
		define_c_predicate("mbx_discard1",5,C_mbx_discard1, enter_c,1);
		define_c_predicate("mbx_check1", 5, C_mbx_check1, enter_c, 1);
		define_c_predicate("mbx_close1", 4, C_mbx_close1, enter_c, 1);
		define_c_predicate("mbx_link_i1", 5, C_mbx_link_i1, enter_c, 1);
		define_c_predicate("mbx_link_o1", 5, C_mbx_link_o1, enter_c, 1);
		define_c_predicate("mbx_unlink_i1",5,C_mbx_unlink_i1,enter_c,1);
		define_c_predicate("mbx_unlink_o1",5,C_mbx_unlink_o1,enter_c,1);
		define_c_predicate("mbx_getlinks1",4,C_mbx_getlinks1,enter_c,1);
		define_c_predicate("mbx_clear1", 5, C_mbx_clear1, enter_c, 1);
		define_c_predicate("mbx_bind1", 5, C_mbx_bind1, enter_c, 1);
		define_c_predicate("mbx_getid1", 4, C_mbx_getid1, enter_c, 1);
		define_c_predicate("mbx_getname1",4,C_mbx_getname1,enter_c, 1);
		define_c_predicate("mbx_initdb1", 2, C_mbx_initdb1, enter_c, 1);
		define_c_predicate("mbx_getdb1", 4, C_mbx_getdb1,  enter_c, 1);
		define_c_predicate("mbx_closedb1",3,C_mbx_closedb1,enter_c,1);
		define_c_predicate("mbx_req1", 1, C_mbx_req1, enter_c, 1);
		define_c_predicate("mbx_req2", 2, C_mbx_req2, enter_c, 1);
		define_c_predicate("mbx_req3", 2, C_mbx_req3, enter_c, 1);
		define_c_predicate("mbx_req4", 3, C_mbx_req4, enter_c, 1);
		define_c_predicate("mbx_error", 1, C_mbx_error, enter_c, 1);
		here = 1;
	}

	return(SUCCESS);
}

C_mbx_init0(Args)
Word    *Args;
{
	static int here=0;

	if (!here) {
		atom_block		= make_atom("block");
		atom_poll		= make_atom("poll");
		atom_oob_data		= make_atom("oob");
		atom_normal_data	= make_atom("normal");
		atom_none		= make_atom("none");
		atom_read		= make_atom("read");
		atom_write		= make_atom("write");
		atom_read_write		= make_atom("read_write");
		atom_ok			= make_atom("ok");
		atom_timeout		= make_atom("timeout");
		atom_closed		= make_atom("closed");
		atom_permiss		= make_atom("permiss");
		atom_linked		= make_atom("linked");
		atom_locked		= make_atom("locked");
		atom_empty		= make_atom("empty");
		atom_sequence		= make_atom("sequence");
		atom_closed_mach	= make_atom("closed_mach");
		atom_tcp_err		= make_atom("tcp_err");
		atom_duplicate_serv	= make_atom("duplicate_serv");
		atom_serv_notfound	= make_atom("serv_notfound");
		atom_id_notfound	= make_atom("id_notfound");
		atom_error		= make_atom("error");
		atom_unify		= make_atom("unify");
		atom_usage		= make_atom("usage");
		here = 1;
	}
	mbx_errno = atom_ok;

	return(SUCCESS);
}

/*----------------------------------------------------------------------------*/
/*	mbx_init(Machine?, Service?).					      */
/*----------------------------------------------------------------------------*/
C_mbx_init1(Args)
Word	*Args;
{
	wait_for_argument(A0);
	if (!IsAtom(A0)) {
		bu_error(A0, "mbx_init/3: 1st arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A1);
	if (!IsAtom(A1)) {
		bu_error(A1, "mbx_init/3: 2nd arg incorrect");
		mbx_fail(atom_usage);
	}

/*
 *	Initialise Predefined Atoms
 */
	(void) C_mbx_init0(Args);

	if (init_mbx(string_val(A0),string_val(A1)) == FAIL) {
		mbx_fail(atom_error);
	}

	return(SUCCESS);
}
/*----------------------------------------------------------------------------*/
/*	mbx_create(Id^, UserPer?, GroupPer?, OthersPer?,		      */
/*				ReadPwd?, WritePwd?).			      */
/*----------------------------------------------------------------------------*/
C_mbx_create(Args)
Word	*Args;
{
	int mbx;
	unsigned permiss = 0;

	wait_for_argument(A1);
	if (IsConst(A1) && (A1 == atom_read))
		permiss |= USER_READ;
	else if (IsConst(A1) && (A1 == atom_write))
		permiss |= USER_WRITE;
	else if (IsConst(A1) && (A1 == atom_read_write))
		permiss |= (USER_READ | USER_WRITE);
	else if (IsConst(A1) && (A1 == atom_none))
		;
	else {
		bu_error(A1, "mbx_create/6: 2nd arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A2);
	if (IsConst(A2) && (A2 == atom_read))
		permiss |= GROUP_READ;
	else if (IsConst(A2) && (A2 == atom_write))
		permiss |= GROUP_WRITE;
	else if (IsConst(A2) && (A2 == atom_read_write))
		permiss |= (GROUP_READ | GROUP_WRITE);
	else if (IsConst(A2) && (A2 == atom_none))
		;
	else {
		bu_error(A2, "mbx_create/6: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A3);
	if (IsConst(A3) && (A3 == atom_read))
		permiss |= OTHERS_READ;
	else if (IsConst(A3) && (A3 == atom_write))
		permiss |= OTHERS_WRITE;
	else if (IsConst(A3) && (A3 == atom_read_write))
		permiss |= (OTHERS_READ | OTHERS_WRITE);
	else if (IsConst(A3) && (A3 == atom_none))
		;
	else {
		bu_error(A3, "mbx_create/6: 4th arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A4);
	if (! IsInt(A4)) {
		bu_error(A4, "mbx_create/6: 5th arg incorrect");
		mbx_fail(atom_usage);
	}
	if (! IsInt(A5)) {
		bu_error(A5, "mbx_create/6: 6th arg incorrect");
		mbx_fail(atom_usage);
	}

	if ((mbx = open_mailbox(permiss, int_val(A4), int_val(A5))) < 0) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A0, make_int(mbx)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_send(Id?, Flag?, TimeOut?, Term?, WPwd?) <-			      */
/*		mbx_send1(Id?, Flag?, TimeOut?, Term?, WPwd?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_send1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_send/6: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_send/6: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_send/6: 3rd arg incorrect");

	wait_for_argument(A3);
	wait_for_argument(A4);
	if (! IsInt(A4)) {
		bu_error(A4, "mbx_send/6: 5th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A4),
			MK_OPERATION(flag,SEND),word_to_dataword(A3)))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A5, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_recv(Id?, Flag?, TimeOut?, Term^, RPwd?) <-			      */
/*		mbx_recv1(Id?, Flag?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req2(Req?, Term^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_recv1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_recv/6: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_recv/6: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_recv/6: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_recv/6: 5th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,RECV),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_look(Id?, Flag?, TimeOut?, Term^, RPwd?) <-			      */
/*		mbx_look1(Id?, Flag?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req2(Req?, Term^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_look1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_look/6: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_look/6: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_look/6: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_look/6: 5th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,LOOK),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_commit(Id?, Flag?, TimeOut?, RPwd?) <-			      */
/*		mbx_commit1(Id?, Flag?, TimeOut?, RPwd?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_commit1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_commit/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_commit/5: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_commit/5: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_commit/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,COMMIT),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_discard(Id?, Flag?, TimeOut?, RPwd?) <-			      */
/*		mbx_discard1(Id?, Flag?, TimeOut?, RPwd?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_discard1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_discard/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_discard/5: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_discard/5: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_discard/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,DISCARD),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_check(Id?, Flag?, TimeOut?, RPwd?) <-			      */
/*		mbx_check1(Id?, Flag?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_check1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_check/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_check/5: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_check/5: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_check/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,CHECKRECV),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_close(Id?, TimeOut?, RPwd?) <-				      */
/*		mbx_close1(Id?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_close1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_close/4: 1st arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_close/4: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_close/4: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,CLOSE),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_link(IdI?, RPwd?, IdO?, WPwd?, TimeOut?) <-			      */
/*		mbx_link_i(IdI?, RPwd?, IdO?, TimeOut?) &		      */
/*		mbx_link_o(IdO?, WPwd?, IdI?, TimeOut?).		      */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*	mbx_link_i(IdI?, RPwd?, IdO?, TimeOut?) <-			      */
/*		mbx_link_i1(IdI?, RPwd?, IdO?, TimeOut?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_link_i1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word IdO;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_link/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A1);
	if (! IsInt(A1)) {
		bu_error(A1, "mbx_link/5: 2nd arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_link/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A3);
	CHECK_mbx_timeout(A3, ti, "mbx_link/5: 5th arg incorrect");

	IdO = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,LINK_I),IdO))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_link_o(IdO?, WPwd?, IdI?, TimeOut?) <-			      */
/*		mbx_link_o1(IdO?, WPwd?, IdI?, TimeOut?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_link_o1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word IdI;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_link/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	if (! IsInt(A1)) {
		bu_error(A1, "mbx_link/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_link/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A3);
	CHECK_mbx_timeout(A3, ti, "mbx_link/5: 5th arg incorrect");

	IdI = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,LINK_O),IdI))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_unlink(IdI?, RPwd?, IdO?, WPwd?, TimeOut?) <-		      */
/*		mbx_unlink_i(IdI?, RPwd?, IdO?, TimeOut?) &		      */
/*		mbx_unlink_o(IdO?, WPwd?, IdI?, TimeOut?).		      */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*	mbx_unlink_i(IdI?, RPwd?, IdO?, TimeOut?) <-			      */
/*		mbx_unlink_i1(IdI?, RPwd?, IdO?, TimeOut?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_unlink_i1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word IdO;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_unlink/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A1);
	if (! IsInt(A1)) {
		bu_error(A1, "mbx_unlink/5: 2nd arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_unlink/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A3);
	CHECK_mbx_timeout(A3, ti, "mbx_unlink/5: 5th arg incorrect");

	IdO = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,UNLINK_I),IdO))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_unlink_o(IdO?, WPwd?, IdI?, TimeOut?) <-			      */
/*		mbx_unlink_o1(IdO?, WPwd?, IdI?, TimeOut?, Req^) &	      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_unlink_o1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word IdI;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_unlink/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A1);
	if (! IsInt(A1)) {
		bu_error(A1, "mbx_unlink/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}
	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_unlink/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A3);
	CHECK_mbx_timeout(A3, ti, "mbx_unlink/5: 5th arg incorrect");

	IdI = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,UNLINK_O),IdI))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getlinks(Id?, TimeOut?, RPwd?, Term^) <-			      */
/*		mbx_getlinks1(Id?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req2(Req?, Term^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_getlinks1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_getlinks/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_getlinks/5: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_getlinks/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,CLOSE),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_clear(Id?, Flag?, TimeOut?, RPwd?) <-			      */
/*		mbx_clear1(Id?, Flag?, TimeOut?, RPwd?, Req^) &		      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_clear1(Args)
Word	*Args;
{
	unsigned flag, ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_clear/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_data_type(A1, flag, "mbx_clear/5: 2nd arg incorrect");

	wait_for_argument(A2);
	CHECK_mbx_timeout(A2, ti, "mbx_clear/5: 3rd arg incorrect");

	wait_for_argument(A3);
	if (! IsInt(A3)) {
		bu_error(A3, "mbx_clear/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,CLEAR),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_bind(Id?, TimeOut?, RPwd?, Term?) <-			      */
/*		mbx_bind1(Id?, TimeOut?, RPwd?, Term?, Req^) &		      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_bind1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word service;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_bind/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_bind/5: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_bind/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A3);
	if (! IsAtom(A3)) {
		bu_error(A3, "mbx_bind/5: 4th arg incorrect");
		mbx_fail(atom_usage);
	}

	service = alloc_str_data(string_val(A3));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,BIND),service))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getid(Term?, TimeOut?, Pwd?, Id^) <-			      */
/*		mbx_getid1(Term?, TimeOut?, Pwd?, Req^) &		      */
/*		mbx_req3(Req?, Id^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_getid1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;
	data_word service;

	wait_for_argument(A0);
	if (! IsAtom(A0)) {
		bu_error(A0, "mbx_getid/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_getid/5: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_getid/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	service = alloc_str_data(string_val(A0));

	if (! (req = alloc_mbx_request(ti,NULL,int_val(A2),
			MK_OPERATION(NULL,GETID),service))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getname(Id?, TimeOut?, Pwd?, Term^) <-			      */
/*		mbx_getname1(Id?, TimeOut?, Pwd?, Req^) &		      */
/*		mbx_req2(Req?, Term^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_getname1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_getname/5: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_getname/5: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_getname/5: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,GETNAME),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_initdb(Ptr^, TimeOut?) <-					      */
/*		mbx_initdb1(TimeOut?, Req^) &				      */
/*		mbx_req3(Req?, Ptr^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_initdb1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	CHECK_mbx_timeout(A0, ti, "mbx_initdb/3: 2nd arg incorrect");

	if (! (req = alloc_mbx_request(ti,NULL,NULL,
			MK_OPERATION(NULL,INIT),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A1, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getdb(Ptr?, TimeOut?, Pwd?, Term^, Id^) <-			      */
/*		mbx_getdb1(Ptr?, TimeOut?, Pwd?, Req^) &		      */
/*		mbx_req4(Req?, Id^, Term^).				      */
/*----------------------------------------------------------------------------*/
C_mbx_getdb1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_getdb/6: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_getdb/6: 2nd arg incorrect");

	wait_for_argument(A2);
	if (! IsInt(A2)) {
		bu_error(A2, "mbx_getdb/6: 3rd arg incorrect");
		mbx_fail(atom_usage);
	}

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,GETIDNAME),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_closedb(Ptr?, TimeOut?) <-					      */
/*		mbx_closedb1(Ptr?, TimeOut?, Req^) &			      */
/*		mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
C_mbx_closedb1(Args)
Word	*Args;
{
	unsigned ti;
	struct mbx_request *req;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A0, "mbx_closedb/3: 1st arg incorrect");
		mbx_fail(atom_usage);
	}

	wait_for_argument(A1);
	CHECK_mbx_timeout(A1, ti, "mbx_closedb/3: 2nd arg incorrect");

	if (! (req = alloc_mbx_request(ti,int_val(A0),NULL,
			MK_OPERATION(NULL,CLOSEDBPTR),(data_word)NULL))) {
		mbx_fail(atom_error);
	}
	mbx_errno = atom_unify;
	return(unify(A2, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_req1(Req?).							      */
/*----------------------------------------------------------------------------*/
C_mbx_req1(Args)
Word	*Args;
{
	struct mbx_request *req;
	unsigned err, id;
	data_word data;

	wait_for_argument(A0);
	req = (struct mbx_request *)int_val(A0);
	
	if (make_mbx_request(req, PARLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	remove_dw(data);
	if (err == OK)
		return(SUCCESS);
	CHECK_mbx_error(err);
}

/*----------------------------------------------------------------------------*/
/*	mbx_req2(Req?, Term).						      */
/*----------------------------------------------------------------------------*/
C_mbx_req2(Args)
Word	*Args;
{
	struct mbx_request *req;
	unsigned err, id, op;
	data_word data;
	int aux;

	wait_for_argument(A0);
	req = (struct mbx_request *)int_val(A0);
	op = req->operation;
	if (make_mbx_request(req, PARLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	if (err == OK) {
		switch (op) {
			/* case GETIDNAME:	*/
			case GETNAME:
				aux = unify(A1, make_atom(data->buff));
				break;
			case GETLINKS:
				aux = make_links_list(A1);
				break;
			default:
				aux = dataword_to_word(data, A1);
				break;
			}
			remove_dw(data);
			mbx_errno = atom_error;
			return(aux);
	}
	CHECK_mbx_error(err);
}

/*----------------------------------------------------------------------------*/
/*	mbx_req3(Req?, Id^).						      */
/*----------------------------------------------------------------------------*/
C_mbx_req3(Args)
Word	*Args;
{
	struct mbx_request *req;
	unsigned err, id;
	data_word data;

	wait_for_argument(A0);
	req = (struct mbx_request *)int_val(A0);
	
	if (make_mbx_request(req, PARLOG, &err, &id,&data) == SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	remove_dw(data);
	if (err == OK) {
		mbx_errno = atom_unify;
		return(unify(A1,make_int((int)id)));
	}
	CHECK_mbx_error(err);
}

/*----------------------------------------------------------------------------*/
/*	mbx_req4(Req?, Id^, Term^).					      */
/*----------------------------------------------------------------------------*/
C_mbx_req4(Args)
Word	*Args;
{
	int aux;
	struct mbx_request *req;
	unsigned err, id; /* , op; */
	data_word data;

	wait_for_argument(A0);
	req = (struct mbx_request *)int_val(A0);
	/* op = GET_TYPE(req->operation);	*/
	if (make_mbx_request(req, PARLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	if (err == OK) {
		/* if ((op == GETIDNAME)||(op == GETNAME))		*/
			aux = unify(A2, make_atom(data->buff));
		/* else							*/
		/*	aux = dataword_to_word(data, A2);		*/
		remove_dw(data);
		mbx_errno = atom_unify;
		return(unify(A1,make_int((int)id)) & aux);
	}
	CHECK_mbx_error(err);
}
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*	mbx_error(Error^).						      */
/*----------------------------------------------------------------------------*/
C_mbx_error(Args)
Word    *Args;
{
	return(unify(A0, mbx_errno));
}
