/* Copyright (C) 1992 Imperial College */
#include "primitives.h"

#include "mbx_interface.h"

extern	symbpo define_symbol();
extern	bool pr_encoded_read();
extern	bool pr_encoded_write();
extern	define_C_predicate();

#define h_encoded_read(x,y)	pr_encoded_read(x,y)
#define h_encoded_write(x,y)	pr_encoded_write(x,y)
#define int_val(x)		intvl(x)
#define make_int(x)		((int)(x))	/* to use with unify_int() */

			/*	ATTENTION with check_mbx_timeout()	*/

	/*		TimeOuts 		*/
PRIVATE symbpo atom_block;
PRIVATE symbpo atom_poll;

	/*		Flags 			*/
PRIVATE symbpo atom_oob_data;
PRIVATE symbpo atom_normal_data;

	/*		Permiss 		*/
PRIVATE symbpo atom_none;
PRIVATE symbpo atom_read;
PRIVATE symbpo atom_write;
PRIVATE symbpo atom_read_write;

#define CHECK_mbx_error(Err) \
	{switch (Err) { \
		case TIMEOUT: throw(801); \
		case MCLOSED: throw(802); \
		case PERMISS: throw(803); \
		case LINKED: throw(804); \
		case LOCKED: throw(805); \
		case MEMPTY: throw(806); \
		case SEQUENCE: throw(807); \
		case CLOSED_MACH: throw(808); \
		case TCP_ERR: throw(809); \
		case DUPLICATE_SRV: throw(810); \
		case SERV_NOTFOUND: throw(811); \
		case ID_NOTFOUND: throw(812); \
		case ERRCOND: throw(813); \
		case EUNIFY: throw(814); \
	} \
	throw(813);}

#define CHECK_mbx_timeout(Register, Ti) \
	{if (IsInt(Register)) \
		Ti = int_val(Register); \
	else if (IsSymb(Register) && samesymb(symbvl(Register), atom_block)) \
		Ti = BLOCK; \
	else if (IsSymb(Register) && samesymb(symbvl(Register), atom_poll))  \
		Ti = POLL; \
	else \
		throw(210); }

#define CHECK_mbx_data_type(Register, Flag) \
	{if (IsSymb(Register) && samesymb(symbvl(Register), atom_normal_data)) \
		Flag = NORMAL; \
	else if (IsSymb(Register) && samesymb(symbvl(Register),atom_oob_data)) \
		Flag = OOB; \
	else \
		throw(210); }

/****************************************************************/
/*              Functions Declarations                          */
/****************************************************************/
bool	pr_mbx_init0();
bool	pr_mbx_init1();
bool	pr_mbx_create();
bool	pr_mbx_send1();
bool	pr_mbx_recv1();
bool	pr_mbx_look1();
bool	pr_mbx_commit1();
bool	pr_mbx_discard1();
bool	pr_mbx_check1();
bool	pr_mbx_close1();
bool	pr_mbx_link_i1();
bool	pr_mbx_link_o1();
bool	pr_mbx_unlink_i1();
bool	pr_mbx_unlink_o1();
bool	pr_mbx_getlinks1();
bool	pr_mbx_clear1();
bool	pr_mbx_bind1();
bool	pr_mbx_getid1();
bool	pr_mbx_getname1();
bool	pr_mbx_initdb1();
bool	pr_mbx_getdb1();
bool	pr_mbx_closedb1();
bool	pr_mbx_req1();
bool	pr_mbx_req2();
bool	pr_mbx_req3();
bool	pr_mbx_req4();
/*----------------------------------------------------------------------------*/
/* already defined in fd_events/prolog_iface.c
 *
 *	procptr GetPrologProcessPtr()
 *	{
 *		return(TH);
 *	}
 */
/*----------------------------------------------------------------------------*/
/* already defined in fd_events/prolog_iface.c
 *
 *	resume_prolog_proc(proc)
 *	procptr proc;
 *	{
 *		add_to_runq(proc,FALSE);
 *	}
 */
/*----------------------------------------------------------------------------*/
PRIVATE char buff[BUFCHARSIZE];
PRIVATE char *read_buff;
PRIVATE int ibuf;

PRIVATE init_write_buf()
{
	ibuf = 0;
}
PRIVATE init_read_buf(buf)
char *buf;
{
	read_buff = buf;
}
PRIVATE write_to_buf(c)
char	c;
{
	buff[ibuf++] = c;
}
PRIVATE char read_from_buf()
{
	return(*read_buff++);
}
/*----------------------------------------------------------------------------*/
data_word pr_word_to_dataword(data)
cellpo data;
{
	data_word res;

	init_write_buf();
	h_encoded_write(data, write_to_buf);
	res = alloc_b_data(ibuf);
	bcopy(buff,res->buff,ibuf);
	return(res);
}
/*----------------------------------------------------------------------------*/
int pr_dataword_to_word(data, res)
data_word data;
cellpo res;
{
	init_read_buf(data->buff);
	return(h_encoded_read(res, read_from_buf));
}
/*----------------------------------------------------------------------------*/
bool unify_at(argmt,atom)
cellpo argmt;
symbpo atom;
{
	if (IsVar(argmt)) {
		mkreset(argmt);
		mksymb(argmt,atom);
		return(SUCCEED);
	}
	if (IsSymb(argmt)&&samesymb(symbvl(argmt),atom))
		return(SUCCEED);
	return(FAIL);
}
/*----------------------------------------------------------------------------*/
bool unify_int(argmt,numb)
cellpo argmt;
int numb;
{
	if (IsVar(argmt)) {
		mkreset(argmt);
		mkint(argmt,numb);
		return(SUCCEED);
	}
	if (IsInt(argmt)&&(intvl(argmt) == numb))
		return(SUCCEED);
	return(FAIL);
}
/*----------------------------------------------------------------------------*/
int pr_make_links_list(res)
cellpo res;
{
	return(unify_at(res,define_symbol("Link_list")));
}
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* use this version if not using foreign interface 			      */
/*----------------------------------------------------------------------------*/
int prolog_init_mbx()
{
	static int here=0;

	if (!here) {
/*
 *	Initialise Predefined Atoms
 */
		(void) pr_mbx_init0();
/*
 *	Initialise Predicates
 */
		define_C_predicate("pr_mbx_init0", 	0, pr_mbx_init0);
		define_C_predicate("pr_mbx_init1", 	2, pr_mbx_init1);
		define_C_predicate("pr_mbx_create", 	7, pr_mbx_create);
		define_C_predicate("pr_mbx_send1", 	6, pr_mbx_send1);
		define_C_predicate("pr_mbx_recv1", 	5, pr_mbx_recv1);
		define_C_predicate("pr_mbx_look1", 	5, pr_mbx_look1);
		define_C_predicate("pr_mbx_commit1", 	5, pr_mbx_commit1);
		define_C_predicate("pr_mbx_discard1", 	5, pr_mbx_discard1);
		define_C_predicate("pr_mbx_check1", 	5, pr_mbx_check1);
		define_C_predicate("pr_mbx_close1", 	4, pr_mbx_close1);
		define_C_predicate("pr_mbx_link_i1", 	5, pr_mbx_link_i1);
		define_C_predicate("pr_mbx_link_o1", 	5, pr_mbx_link_o1);
		define_C_predicate("pr_mbx_unlink_i1", 	5, pr_mbx_unlink_i1);
		define_C_predicate("pr_mbx_unlink_o1", 	5, pr_mbx_unlink_o1);
		define_C_predicate("pr_mbx_getlinks1", 	4, pr_mbx_getlinks1);
		define_C_predicate("pr_mbx_clear1", 	5, pr_mbx_clear1);
		define_C_predicate("pr_mbx_bind1", 	5, pr_mbx_bind1);
		define_C_predicate("pr_mbx_getid1", 	4, pr_mbx_getid1);
		define_C_predicate("pr_mbx_getname1", 	4, pr_mbx_getname1);
		define_C_predicate("pr_mbx_initdb1", 	2, pr_mbx_initdb1);
		define_C_predicate("pr_mbx_getdb1", 	4, pr_mbx_getdb1);
		define_C_predicate("pr_mbx_closedb1", 	3, pr_mbx_closedb1);
		define_C_predicate("pr_mbx_req1", 	2, pr_mbx_req1);
		define_C_predicate("pr_mbx_req2", 	3, pr_mbx_req2);
		define_C_predicate("pr_mbx_req3", 	3, pr_mbx_req3);
		define_C_predicate("pr_mbx_req4", 	4, pr_mbx_req4);
		here = 1;
	}
	return(SUCCEED);
}

bool pr_mbx_init0()
{
	static int here=0;

	if (!here) {
		atom_block		= define_symbol("block");
		atom_poll		= define_symbol("poll");
		atom_oob_data		= define_symbol("oob");
		atom_normal_data	= define_symbol("normal");
		atom_none		= define_symbol("none");
		atom_read		= define_symbol("read");
		atom_write		= define_symbol("write");
		atom_read_write		= define_symbol("read_write");
		here = 1;
	}
	return(SUCCEED);
}

/*----------------------------------------------------------------------------*/
/*	mbx_init(Machine?, Service?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_init1()
{
	register cellpo	A0 = &A[1], A1 = &A[2];

	delnk(A0);
	delnk(A1);

	if (NotSymb(A0))
		throw(210);
	if (NotSymb(A1))
		throw(210);

/*
 *	Initialise Predefined Atoms
 */
	(void) pr_mbx_init0();

	if (init_mbx(string_val(A0),string_val(A1)) == FAIL)
		throw(800);

	return(SUCCEED);
}
/*----------------------------------------------------------------------------*/
/* mbx_create(Id^, UserPer?, GroupPer?, OthersPer?, ReadPwd?, WritePwd?).     */
/*----------------------------------------------------------------------------*/
bool pr_mbx_create()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5],
			A5 = &A[6];
	int mbx;
	unsigned permiss = 0;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);
	delnk(A5);

	if (IsSymb(A1) && (samesymb(symbvl(A1), atom_read)))
		permiss |= USER_READ;
	else if (IsSymb(A1) && (samesymb(symbvl(A1), atom_write)))
		permiss |= USER_WRITE;
	else if (IsSymb(A1) && (samesymb(symbvl(A1), atom_read_write)))
		permiss |= (USER_READ | USER_WRITE);
	else if (IsSymb(A1) && (samesymb(symbvl(A1), atom_none)))
		;
	else
		throw(210);

	if (IsSymb(A2) && (samesymb(symbvl(A2), atom_read)))
		permiss |= GROUP_READ;
	else if (IsSymb(A2) && (samesymb(symbvl(A2), atom_write)))
		permiss |= GROUP_WRITE;
	else if (IsSymb(A2) && (samesymb(symbvl(A2), atom_read_write)))
		permiss |= (GROUP_READ | GROUP_WRITE);
	else if (IsSymb(A2) && (samesymb(symbvl(A2), atom_none)))
		;
	else
		throw(210);

	if (IsSymb(A3) && (samesymb(symbvl(A3), atom_read)))
		permiss |= OTHERS_READ;
	else if (IsSymb(A3) && (samesymb(symbvl(A3), atom_write)))
		permiss |= OTHERS_WRITE;
	else if (IsSymb(A3) && (samesymb(symbvl(A3), atom_read_write)))
		permiss |= (OTHERS_READ | OTHERS_WRITE);
	else if (IsSymb(A3) && (samesymb(symbvl(A3), atom_none)))
		;
	else
		throw(210);

	if (NotInt(A4))
		throw(210);

	if (NotInt(A5))
		throw(210);

	if ((mbx = open_mailbox(permiss, int_val(A4), int_val(A5))) < 0)
		throw(813);
	return(unify_int(A0, make_int(mbx)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_send(Id?, Flag?, TimeOut?, Term?, WPwd?) :-			      */
/*		pr_mbx_send1(Id?, Flag?, TimeOut?, Term?, WPwd?, Req^),       */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_send1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5],
			A5 = &A[6];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);
	delnk(A5);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A4))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A4),
			MK_OPERATION(flag,SEND),pr_word_to_dataword(A3))))
		return(FAIL);
	return(unify_int(A5, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_recv(Id?, Flag?, TimeOut?, Term^, RPwd?) :-			      */
/*		pr_mbx_recv1(Id?, Flag?, TimeOut?, RPwd?, Req^),	      */
/*		pr_mbx_req2(Req?, Term^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_recv1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,RECV),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_look(Id?, Flag?, TimeOut?, Term^, RPwd?) :-			      */
/*		pr_mbx_look1(Id?, Flag?, TimeOut?, RPwd?, Req^),	      */
/*		pr_mbx_req2(Req?, Term^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_look1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,LOOK),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_commit(Id?, Flag?, TimeOut?, RPwd?) :-			      */
/*		pr_mbx_commit1(Id?, Flag?, TimeOut?, RPwd?, Req^),	      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_commit1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,COMMIT),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_discard(Id?, Flag?, TimeOut?, RPwd?, Stat^) <-		      */
/*		pr_mbx_discard1(Id?, Flag?, TimeOut?, RPwd?, Req^) &	      */
/*		pr_mbx_req1(Req?, Stat^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_discard1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,DISCARD),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_check(Id?, Flag?, TimeOut?, RPwd?, Stat^) <-		      */
/*		pr_mbx_check1(Id?, Flag?, TimeOut?, RPwd?, Req^) &		      */
/*		pr_mbx_req1(Req?, Stat^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_check1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag);

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,CHECKRECV),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_close(Id?, TimeOut?, RPwd?, Stat^) <-			      */
/*		pr_mbx_close1(Id?, TimeOut?, RPwd?, Req^) &		      */
/*		pr_mbx_req1(Req?, Stat^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_close1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,CLOSE),(data_word)NULL)))
		return(FAIL);

	return(unify_int(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_link(IdI?, RPwd?, IdO?, WPwd?, TimeOut?) :-			      */
/*		mbx_link_i(IdI?, RPwd?, IdO?, TimeOut?),		      */
/*		mbx_link_c(IdO?, WPwd?, IdI?, TimeOut?).		      */
/*	mbx_link_o(IdO?, WPwd?, IdI?, TimeOut?) :-			      */
/*		mbx_link_o(IdO?, WPwd?, IdI?, TimeOut?).		      */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*	mbx_link_i(IdI?, RPwd?, IdO?, TimeOut?) :-			      */
/*		mbx_link_i1(IdI?, RPwd?, IdO?, TimeOut?, Req^),		      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_link_i1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned ti;
	struct mbx_request *req;
	data_word IdO;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);
	if (NotInt(A1))
		throw(210);
	if (NotInt(A2))
		throw(210);

	CHECK_mbx_timeout(A3, ti);

	IdO = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,LINK_I),IdO)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_link_o(IdO?, WPwd?, IdI?, TimeOut?) :-			      */
/*		mbx_link_o1(IdO?, WPwd?, IdI?, TimeOut?, Req^),		      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_link_o1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned ti;
	struct mbx_request *req;
	data_word IdI;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);
	if (NotInt(A1))
		throw(210);
	if (NotInt(A2))
		throw(210);

	CHECK_mbx_timeout(A3, ti);

	IdI = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,LINK_O),IdI)))
		return(FAIL);

	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_unlink(IdI?, RPwd?, IdO?, WPwd?, TimeOut?) :-		      */
/*		mbx_unlink_i(IdI?, RPwd?, IdO?, TimeOut?),		      */
/*		mbx_unlink_c(IdO?, WPwd?, IdI?, TimeOut?).		      */
/*	mbx_unlink_c(IdO?, WPwd?, IdI?, TimeOut?) <-			      */
/*			mbx_unlink_o(IdO?, WPwd?, IdI?, TimeOut?),	      */
/*	mbx_unlink_c(IdO?, WPwd?, IdI?, TimeOut?).			      */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*	mbx_unlink_i(IdI?, RPwd?, IdO?, TimeOut?, Req^) :-		      */
/*		mbx_unlink_i1(IdI?, RPwd?, IdO?, TimeOut?, Req^),	      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_unlink_i1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned ti;
	struct mbx_request *req;
	data_word IdO;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);
	if (NotInt(A1))
		throw(210);
	if (NotInt(A2))
		throw(210);

	CHECK_mbx_timeout(A3, ti);

	IdO = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,UNLINK_I),IdO)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_unlink_o(IdO?, WPwd?, IdI?, TimeOut?) :-			      */
/*		mbx_unlink_o1(IdO?, WPwd?, IdI?, TimeOut?, Req^),	      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_unlink_o1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned ti;
	struct mbx_request *req;
	data_word IdI;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);
	if (NotInt(A1))
		throw(210);
	if (NotInt(A2))
		throw(210);

	CHECK_mbx_timeout(A3, ti);

	IdI = alloc_int_dataword(int_val(A2));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A1),
			MK_OPERATION(NULL,UNLINK_O),IdI)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getlinks(Id?, TimeOut?, RPwd?, Term^) :-			      */
/*		pr_mbx_getlinks1(Id?, TimeOut?, RPwd?, Req^),		      */
/*		pr_mbx_req2(Req?, Term^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_getlinks1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,CLOSE),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_clear(Id?, Flag?, TimeOut?, RPwd?) :-			      */
/*		pr_mbx_clear1(Id?, Flag?, TimeOut?, RPwd?, Req^),	      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_clear1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned flag, ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_data_type(A1, flag)

	CHECK_mbx_timeout(A2, ti);

	if (NotInt(A3))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A3),
			MK_OPERATION(flag,CLEAR),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_bind(Id?, TimeOut?, RPwd?, Term?) :-			      */
/*		pr_mbx_bind1(Id?, TimeOut?, RPwd?, Term?, Req^),	      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_bind1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4],
			A4 = &A[5];
	unsigned ti;
	struct mbx_request *req;
	data_word service;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);
	delnk(A4);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		throw(210);
	if (NotSymb(A3))
		throw(210);

	service = alloc_str_data(string_val(A3));

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,BIND),service)))
		return(FAIL);
	return(unify_int(A4, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getid(Term?, TimeOut?, Pwd?, Id^) :-			      */
/*		pr_mbx_getid1(Term?, TimeOut?, Pwd?, Req^),		      */
/*		pr_mbx_req3(Req?, Id^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_getid1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4];
	unsigned ti;
	struct mbx_request *req;
	data_word service;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);

	if (NotSymb(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		return(FAIL);

	service = alloc_str_data(string_val(A0));

	if (! (req = alloc_mbx_request(ti,0L,int_val(A2),
			MK_OPERATION(NULL,GETID),service)))
		return(FAIL);
	return(unify_int(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getname(Id?, TimeOut?, Pwd?, Term^) :-			      */
/*		pr_mbx_getname1(Id?, TimeOut?, Pwd?, Req^),		      */
/*		pr_mbx_req2(Req?, Term^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_getname1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,GETNAME),(data_word)NULL)))
		return(FAIL);

	return(unify_int(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_initdb(Ptr^, TimeOut?) :-					      */
/*		pr_mbx_initdb1(TimeOut?, Req^),				      */
/*		pr_mbx_req3(Req?, Ptr^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_initdb1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);

	CHECK_mbx_timeout(A0, ti);

	if (! (req = alloc_mbx_request(ti,0L,(long)NULL,
			MK_OPERATION(NULL,INIT),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A1, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_getdb(Ptr?, TimeOut?, Pwd?, Term^, Id^) :-			      */
/*		pr_mbx_getdb1(Ptr?, TimeOut?, Pwd?, Req^),		      */
/*		pr_mbx_req4(Req?, Id^, Term^).				      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_getdb1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3],
			A3 = &A[4];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);
	delnk(A3);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (NotInt(A2))
		throw(210);

	if (! (req = alloc_mbx_request(ti,int_val(A0),int_val(A2),
			MK_OPERATION(NULL,GETIDNAME),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A3, make_int((int)req)));
}
/*----------------------------------------------------------------------------*/
/*	mbx_closedb(Ptr?, TimeOut?) :-					      */
/*		pr_mbx_closedb1(Ptr?, TimeOut?, Req^),			      */
/*		pr_mbx_req1(Req?).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_closedb1()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3];
	unsigned ti;
	struct mbx_request *req;

	delnk(A0);
	delnk(A1);
	delnk(A2);

	if (NotInt(A0))
		throw(210);

	CHECK_mbx_timeout(A1, ti);

	if (! (req = alloc_mbx_request(ti,int_val(A0),(long)NULL,
			MK_OPERATION(NULL,CLOSEDBPTR),(data_word)NULL)))
		return(FAIL);
	return(unify_int(A2, make_int((int)req)));
}

/*----------------------------------------------------------------------------*/
/*	pr_mbx_req1(Req?).						      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_req1()
{
	register cellpo	A0 = &A[1];
	struct mbx_request *req;
	unsigned err, id;
	data_word data;

	delnk(A0);

	req = (struct mbx_request *)int_val(A0);
	
	if (make_mbx_request(req, PROLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	remove_dw(data);
	if (err == OK)
		return(SUCCESS);
	CHECK_mbx_error(err);
}
/*----------------------------------------------------------------------------*/
/*	pr_mbx_req2(Req?, Term^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_req2()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2];
	struct mbx_request *req;
	unsigned err, id, op;
	data_word data;
	int aux;

	delnk(A0);
	delnk(A1);

	req = (struct mbx_request *)int_val(A0);
	op = req->operation;
	if (make_mbx_request(req, PROLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	if (err == OK) {
		switch (op) {
			/* case GETIDNAME:	*/
			case GETNAME:
				aux = unify_at(A1, define_symbol(data->buff));
				break;
			case GETLINKS:
				aux = pr_make_links_list(A1);
				break;
			default:
				aux = pr_dataword_to_word(data, A1);
				break;
		}
		remove_dw(data);
		return(aux);
	}
	CHECK_mbx_error(err);
}
/*----------------------------------------------------------------------------*/
/*	pr_mbx_req3(Req?, Id^).						      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_req3()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2];
	struct mbx_request *req;
	unsigned err, id;
	data_word data;

	delnk(A0);
	delnk(A1);

	req = (struct mbx_request *)int_val(A0);
	
	if (make_mbx_request(req, PROLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	remove_dw(data);
	if (err == OK)
		return(unify_int(A1,make_int(id)));
	CHECK_mbx_error(err);
}
/*----------------------------------------------------------------------------*/
/*	pr_mbx_req4(Req?, Id^, Term^).					      */
/*----------------------------------------------------------------------------*/
bool pr_mbx_req4()
{
	register cellpo	A0 = &A[1],
			A1 = &A[2],
			A2 = &A[3];
	int aux;
	struct mbx_request *req;
	unsigned err, id; /* , op; */
	data_word data;

	delnk(A0);
	delnk(A1);
	delnk(A2);

	req = (struct mbx_request *)int_val(A0);
	/* op = GET_TYPE(req->operation);	*/
	if (make_mbx_request(req, PROLOG, &err, &id, &data)
			== SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	if (err == OK) {
		/* if ((op == GETIDNAME)||(op == GETNAME))	*/
			aux = unify_at(A2, define_symbol(data->buff));
		/* else						*/
		/*	aux = pr_dataword_to_word(data, A2);	*/
		remove_dw(data);
		return(unify_int(A1,make_int(id)) & aux);
	}
	CHECK_mbx_error(err);
}
/*----------------------------------------------------------------------------*/
