/* Copyright (C) 1992 Imperial College */
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>

extern void exit();

#define USE_STACK
#include "mbx.h"

#define MAX_SERV		512
#define MAX_PTR			512

#define insert(array,pt,size,size_elem)   									\
	{	bcopy((char*)&(array)[(pt)],(char*)&(array)[(pt)+1],(size-(pt))*size_elem);		\
		++size;	}

#define remove(array,pt,size,size_elem)   									\
	{	bcopy((char*)&(array)[(pt)+1],(char*)&(array)[(pt)],(size-((pt)+1))*size_elem);	\
		--size;	}

struct mach_inf {
	int sock;
	struct sockaddr_in mach_add;
	};
struct db_inf {
	int mbx_number;
	int mbx_permiss;
	int read_passwd;
	int write_passwd;
	int user;
	int group;
	char mbx_service[1];
	};

struct db_ptr {
	unsigned ptr;
	int		index;
	};

static struct mach_inf *mach_list[MAX_MACH];

static struct db_inf *services[MAX_SERV];
static int num_serv = 0;

static struct db_ptr db_pointers[MAX_PTR];

static int buff[BUFINTSIZE];

static int count = 1;

static fd_set mask;

#define alloc_mach_inf		((struct mach_inf *)malloc(sizeof(struct mach_inf)))
#define free_mach_inf(ptr)	(free((char*)ptr))
#define free_db_inf(ptr)	(free((char*)ptr))
/*---------------------------------------------------------------------------*/
/*
 *		Data Base Management
 */
/*---------------------------------------------------------------------------*/
struct db_inf *alloc_db_inf(dbreq)
struct db_req *dbreq;
{
	struct db_inf *ptr;

	if (ptr = (struct db_inf*)malloc(sizeof(struct db_inf)+strlen(dbreq->service))) {
		ptr->mbx_number = dbreq->mbx;
		ptr->mbx_permiss = dbreq->permiss;
		ptr->read_passwd = dbreq->read_passwd;
		ptr->write_passwd = dbreq->write_passwd;
		ptr->user = dbreq->euid;
		ptr->group = dbreq->egid;
		(void) strcpy(ptr->mbx_service,dbreq->service); }
	return(ptr);
}
/*---------------------------------------------------------------------------*/
int init_db_ptr(pointer)		/*	Naive	*/
unsigned pointer;
{
	int i;
	
	for (i=0; i<MAX_PTR; ++i)
		if (db_pointers[i].ptr == 0) {
			db_pointers[i].ptr = pointer;
			db_pointers[i].index = 0;
			return(TRUE); }
	return(FALSE);
}
/*---------------------------------------------------------------------------*/
int search_db_ptr(pointer, index)	/*	Naive	*/
unsigned pointer;
int *index;
{
	int i;
	
	for (i=0; i<MAX_PTR; ++i)
		if (db_pointers[i].ptr == pointer) {
			if (db_pointers[i].index >= num_serv) {
				close_db_ptr(pointer);
				return(FALSE); }
			*index = db_pointers[i].index++;
			return(TRUE); }
	return(FALSE);
}
/*---------------------------------------------------------------------------*/
int close_db_ptr(pointer)	/*	Naive	*/
unsigned pointer;
{
	int i;
	
	for (i=0; i<MAX_PTR; ++i)
		if (db_pointers[i].ptr == pointer) {
			db_pointers[i].ptr = 0;
			return(TRUE); }
	return(FALSE);
}
/*---------------------------------------------------------------------------*/
int search_mbx(mbx_number, index)	/*	Naive	*/
unsigned mbx_number;
int *index;
{
	int i;
	
	for (i=0; i<num_serv; ++i)
		if (services[i]->mbx_number == mbx_number) {
			*index = i;
			return(TRUE); }
	return(FALSE);
}
/*---------------------------------------------------------------------------*/
int search_service(service,index)
char *service;
int *index;
{
	int sup = num_serv-1, inf = 0, med = inf;
	int cmp;

	while (inf <= sup) {
		med = (sup + inf) / 2;
		if ((cmp = strcmp(service, services[med]->mbx_service)) < 0)
			sup = med - 1;
		else if (cmp > 0)
			inf = med + 1;
		else {
			*index = med;
			return(TRUE); }
		}
	if (sup < med) {
		*index = med;
		return(FALSE); }
	else {
		*index = med+1;
		return(FALSE); }
}
/*---------------------------------------------------------------------------*/
int remove_mbx_mach(mach_number)	/*	Naive	*/
int mach_number;
{
	int i;
	
	for (i=0; i<num_serv; ++i)
		if (GET_MBX_MACH(services[i]->mbx_number) == mach_number) {
		 	free_db_inf(services[i]);
			remove(services, i, num_serv, sizeof(struct db_inf*)); }
}
/*---------------------------------------------------------------------------*/
int close_mach(mach_number)
int mach_number;
{
#ifdef _DEBUG_
	printf("Closing Machine %d\n",mach_number);
#endif
	FD_CLR(mach_list[mach_number]->sock,&mask);
	(void) close(mach_list[mach_number]->sock);
	free_mach_inf(mach_list[mach_number]);
	mach_list[mach_number] = NULL;
	push_stack(mach_number);
	
	remove_mbx_mach(mach_number);

	return(0);
}
/*---------------------------------------------------------------------------*/
int add_mbx_db(dbreq)
struct db_req *dbreq;
{
	int index;

#ifdef _DEBUG_
	printf("Add_DataBase Msg Received.");
	printf("\tMbx %u. Service %s\n",dbreq->mbx,dbreq->service);
#endif

	if (search_service(dbreq->service,&index))
		return(DUPLICATE_SRV);
	insert(services, index, num_serv, sizeof(struct db_inf*));
	if (services[index] = alloc_db_inf(dbreq))
		return(BIND);
	return(ERRCOND);
}
/*---------------------------------------------------------------------------*/
int remove_mbx_from_db(dbreq)
struct db_req *dbreq;
{
	int index;

#ifdef _DEBUG_
	printf("Remove_DataBase Msg Received.");
	printf("\tMbx %u.\n",dbreq->mbx);
#endif

	if ((search_mbx(dbreq->mbx,&index))&&
		((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_READ))||
		  ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_READ))||
		  ((services[index]->mbx_permiss & OTHERS_READ)))&&
		 (services[index]->read_passwd == dbreq->read_passwd))) {
		 	free_db_inf(services[index]);
			remove(services, index, num_serv, sizeof(struct db_inf*));
			return(CLOSE);
			}
	return(ID_NOTFOUND);
}
/*---------------------------------------------------------------------------*/
int getid_mbx_db(dbreq,mbx)
struct db_req *dbreq;
unsigned *mbx;
{
	int index;

#ifdef _DEBUG_
	printf("GetId Msg Received.");
	printf("\tService %s\n",dbreq->service);
#endif

	if ((search_service(dbreq->service,&index))&&
		(((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_WRITE))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_WRITE))||
		   ((services[index]->mbx_permiss & OTHERS_WRITE)))&&
		  (services[index]->write_passwd == dbreq->write_passwd))||
		 ((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_READ))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_READ))||
		   ((services[index]->mbx_permiss & OTHERS_READ)))&&
		  (services[index]->read_passwd == dbreq->read_passwd)))) {
		  		*mbx = services[index]->mbx_number;
				return(GETID); }
	return(SERV_NOTFOUND);
}
/*---------------------------------------------------------------------------*/
int getname_mbx_db(dbreq,service)
struct db_req *dbreq;
char *service;
{
	int index;

#ifdef _DEBUG_
	printf("GetName Msg Received.");
	printf("\tMbx %u\n",dbreq->mbx);
#endif

	if ((search_mbx(dbreq->mbx,&index))&&
		(((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_WRITE))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_WRITE))||
		   ((services[index]->mbx_permiss & OTHERS_WRITE)))&&
		  (services[index]->write_passwd == dbreq->write_passwd))||
		 ((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_READ))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_READ))||
		   ((services[index]->mbx_permiss & OTHERS_READ)))&&
		  (services[index]->read_passwd == dbreq->read_passwd)))) {
		  		(void) strcpy(service,services[index]->mbx_service);
				return(GETNAME); }
	return(ID_NOTFOUND);
}
/*---------------------------------------------------------------------------*/
int getidname_mbx_db(dbreq,mbx,service)
struct db_req *dbreq;
unsigned *mbx;
char *service;
{
	int index;

#ifdef _DEBUG_
	printf("GetIdName Msg Received.");
	printf("\tPtr %u\n",dbreq->mbx);
#endif

	while (search_db_ptr(dbreq->mbx,&index)) {
		if (((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_WRITE))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_WRITE))||
		   ((services[index]->mbx_permiss & OTHERS_WRITE)))&&
		  (services[index]->write_passwd == dbreq->write_passwd))||
		 ((((services[index]->user == dbreq->euid)&&(services[index]->mbx_permiss & USER_READ))||
		   ((services[index]->group == dbreq->egid)&&(services[index]->mbx_permiss & GROUP_READ))||
		   ((services[index]->mbx_permiss & OTHERS_READ)))&&
		  (services[index]->read_passwd == dbreq->read_passwd))) {
		  		*mbx = services[index]->mbx_number;
		  		(void) strcpy(service,services[index]->mbx_service);
				return(GETIDNAME); }
		}
	return(SERV_NOTFOUND);
}
/*---------------------------------------------------------------------------*/
/*	ATTENTION:	the next function is duplicated in mbx.c
/*---------------------------------------------------------------------------*/
int is_db_enq_op(operation)
unsigned operation;
{
	switch (operation) {
		case	GETID:
		case	GETNAME:
		case	GETIDNAME:
							return(TRUE);
/*
 *		case	CLOSE:
 *		case	BIND:
 *		case	INIT:
 *		case	CLOSEDBPTR:
 */
		default:
							return(FALSE);
		}
}
/*---------------------------------------------------------------------------*/
int process_connection(sock)
int sock;
{
	int number, nbytes;
	struct db_req	dbreq;
	struct db_res	dbres;

	if ((nbytes = recv(sock, (char*)&dbreq, sizeof(struct db_req), 0)) < 0) {
		perror("receiving message");
		return(-1); }
	if (nbytes == 0) {
		for (number = 1; /* (number < MAX_MACH)&& */ (mach_list[number]?(mach_list[number]->sock != sock):TRUE); ++number)
			;
/*		if (number < MAX_MACH)	*/
			close_mach(number);
		return(0); }
	switch (dbreq.operation) {
		case CLOSE:
			dbres.status = remove_mbx_from_db(&dbreq);
			break;
		case BIND:
			dbres.status = add_mbx_db(&dbreq);
			break;
		case GETID:
			dbres.status = getid_mbx_db(&dbreq, &dbres.mbx);
			break;
		case GETNAME:
			dbres.status = getname_mbx_db(&dbreq, dbres.service);
			break;
		case INIT:
			dbres.status = (init_db_ptr(dbreq.mbx)?INIT:ERRCOND);
			break;
		case GETIDNAME:
			dbres.status = getidname_mbx_db(&dbreq, &dbres.mbx, dbres.service);
			break;
		case CLOSEDBPTR:
			dbres.status = (close_db_ptr(dbreq.mbx)?CLOSEDBPTR:ERRCOND);
			break;
		}

#ifdef	FULL_REPORT_ERROR
	if (dbreq.operation == CLOSE)
		return(0);
#else
	if (is_db_enq_op(dbreq.operation))
#endif
		{
		dbres.proc_ptr = dbreq.proc_ptr;
		if (send(sock,(char*)&dbres,sizeof(struct db_res),0) < 0) {
			perror("sending a database reply");
			return(-1); }
		}
	return(0);
}
/*---------------------------------------------------------------------------*/
/*
 *		Accepting New Connections
 */
/*---------------------------------------------------------------------------*/
int mk_conn_list(buff, mach_list, mach_number)
struct list_conn *buff;
struct mach_inf **mach_list;
int mach_number;
{
	int i, j;
	
	for (i=1, j=0; i<MAX_MACH;++i)
		if ((mach_list[i]) && (i != mach_number)) {
			bcopy((char*)&mach_list[i]->mach_add, (char*)&buff->mach_inf[j].mach_add, sizeof(struct sockaddr_in));
			buff->mach_inf[j++].mach_number = i;
			}
	buff->number_of_mach = j;
	buff->number_given = mach_number;
	buff->type = CONNECT_LIST;
	
	return(0);
}
/*---------------------------------------------------------------------------*/
int get_conn_msg(buff,add)
struct msg_conn *buff;
struct sockaddr_in *add;
{
	if (buff->type != CONNECT_MSG) {
		return(-1); }
	bcopy((char*)&buff->mach_add,(char*)add, sizeof(struct sockaddr_in));
	
	return(0);
}
/*---------------------------------------------------------------------------*/
int accept_new_connections(sock)
int sock;
{
	int mach_number, nbytes;

	if (stack_empty)
		mach_number = count++;
	else
		pop_stack(mach_number);
	mach_list[mach_number] = alloc_mach_inf;
	if ((mach_list[mach_number]->sock = accept(sock, (struct sockaddr *)0, (int *)0)) == -1) {
		perror("accept");
		return(-1); }
	FD_SET(mach_list[mach_number]->sock, &mask);
	if (mk_conn_list(buff, mach_list, mach_number) < 0) {
		return(-1); }
	if (send(mach_list[mach_number]->sock,(char*)buff,LIST_SIZE(buff), 0) < 0) {
		perror("sending connect list");
		return(-1); }
	if ((nbytes = recv(mach_list[mach_number]->sock, (char*)buff, BUFCHARSIZE, 0)) < 0) {
		perror("receiving connect message");
		return(-1); }
	else if (nbytes == 0) {
		close_mach(mach_number);
		return(0); }
	if (get_conn_msg(buff,&(mach_list[mach_number]->mach_add)) < 0) {
		return(-1); }
	return(0);
}
/*---------------------------------------------------------------------------*/
/*
 *			Main Program
 */
/*---------------------------------------------------------------------------*/
int open_socket_server(service_name)
char *service_name;
{
	struct servent *sp;
	struct sockaddr_in add;
	int length = sizeof add;
	int sock;

	if ((sp = getservbyname(service_name, "tcp")) == NULL) {
		(void) fprintf(stderr,"error: service %s not found\n", service_name);
		return(-1); }
	add.sin_port = sp->s_port;
	add.sin_addr.s_addr = INADDR_ANY;
	add.sin_family = AF_INET;
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		(void) fprintf(stderr,"error: cannot create a socket\n");
		return(-1); }
	if (bind(sock, (struct sockaddr *)&add, length) < 0) {
		(void) fprintf(stderr,"error: server is already running or socket is in use\n");
		return(-1); }
	if (listen(sock, 5)) {
		(void) fprintf(stderr,"error: cannot listen on socket\n");
		return(-1);
	}
	return(sock);
}
/*---------------------------------------------------------------------------*/
main(argc, argv)
int argc;
char *argv[];
{
	char *service_name;
	fd_set read_mask;
	int i;
	
	if (argc != 2) {
		(void) fprintf(stderr,"usage: %s service\n", argv[0]);
		exit(1); }
	init_stack;
	service_name = argv[1];
	mach_list[0] = alloc_mach_inf;
	if ((mach_list[0]->sock = open_socket_server(service_name)) < 0) {
		exit(1); }

	FD_ZERO(&mask);
	FD_SET(mach_list[0]->sock, &mask);

	if (gethostname((char*)buff, BUFCHARSIZE) < 0) {
		(void) fprintf(stderr, "error: cannot get hostname\n");
		exit(1); }
	(void) fprintf(stdout, "Server [%s] started on machine %s\n", service_name, (char*)buff);
	
	while (TRUE) {
		read_mask = mask;
		if (select(MAX_MACH, &read_mask, (fd_set *)NULL, (fd_set *)NULL, (struct timeval *)NULL) < 0)
			perror("select");
		if (mach_list[0] && FD_ISSET(mach_list[0]->sock, &read_mask))
			accept_new_connections(mach_list[0]->sock);
		for (i=1; i<MAX_MACH; ++i)
			if (mach_list[i] && FD_ISSET(mach_list[i]->sock, &read_mask))
				process_connection(mach_list[i]->sock);
		}
}
/*---------------------------------------------------------------------------*/
