/* Copyright (C) 1992 Imperial College */
#include <stdio.h>
#include "objs.h"
#include "proc.h"
#include "mem.h"
#include "macros.h"
#include "ret.h"
#include "hermes.h"

extern	threadpo	newthread();
extern	codepo		search_symbol();
extern	iopo		getNextIO();
extern	void		timeslice();
extern	fourBytes	init_heapsize,
			init_stacksize;
extern	symbpo		fork_sym;
extern	Word		funct_port;
extern	int		h_deadlock;
extern	int		wait_pipe;
extern	int		ports[];
extern	iopo		next_io;

	bool		h_debug = FALSE;



c_debug(Args)
Word	*Args;
{
	deref(A0);
	if (A0 == make_atom("on") )
		h_debug = TRUE;
	else if (A0 == make_atom("off") )
		h_debug = FALSE;
	else if (IsShort(A0))
		h_debug = ShortVal(A0);
	else
	{	bu_error(A0, "debug/1: arg must be 'on' or 'off'");
		return(FAIL);
	}
	return(SUCCESS);
}


c_is_iport(Args)
Word	*Args;
{
	Word	port;

	wait_for_argument(A0);
	if (!IsStruct(A0) || *StructVal(A0) != funct_port)
		return(FAIL);

	port = *(StructVal(A0) + 1);
	deref(port);
	if (!IsShort(port)) 
		return(FAIL);

	return(io_type(io + ShortVal(port)) == IN_PIPE);
}


c_is_oport(Args)
Word	*Args;
{
	Word	port;

	wait_for_argument(A0);
	if (!IsStruct(A0) || *StructVal(A0) != funct_port)
		return(FAIL);

	port = *(StructVal(A0) + 1);
	deref(port);
	if (!IsShort(port)) 
		return(FAIL);

	return(io_type(io + ShortVal(port)) == OUT_PIPE);
}

c_new_thread(Args)
Word	*Args;
{	threadpo	th;

	if (!(th=newthread(init_heapsize, init_stacksize)))
	{	bu_error(A0, "new_thread/1: insufficient heap space");
		return(FAIL);
	}

	/* link new thread into chain */
	TH->prev->next = th;
	th->prev = TH->prev;
	th->next = TH;
	TH->prev = th;

	return( unify(A0, make_int(th)) );
}


c_fork(Args)
Word	*Args;
{	threadpo	th;
	Word		port;

	wait_for_argument(A0);
	if (!IsNumber(A0))
	{	bu_error(A0, "fork/2: arg incorrect");
		return(FAIL);
	}
	th = (threadpo) int_val(A0);
	
	wait_for_argument(A1);
	if (!IsStruct(A1) || *StructVal(A1) != funct_port)
	{	bu_error(A1, "fork/2: arg incorrect");
		return(FAIL);
	}

	port = *(StructVal(A1) + 1);
	deref(port);
	if (!IsShort(port)) 
	{	bu_error(A1, "fork/2: arg incorrect");
		return(FAIL);
	}

	th->current_input = io + ShortVal(port);
	th->P = search_symbol(fork_sym, 0);
	(void) add_to_runq(th, TRUE);
	return(SUCCESS);
}



/*
 *	Pipe I/O
 */

c_pipe(Args)
Word	*Args;
{
	register Word	*out, *in, *HP;
	iopo	io_in, io_out;
	pipepo	pipe_ptr;
	strpo	block;

	if (!(block = (strpo) malloc(PIPESIZE)) ||
	    !(pipe_ptr = (pipepo) malloc(sizeof(pipe_des))))
	{	bu_error(A0, "pipe/2: insufficient heap space");
		return(FAIL);
	}

	if (!(io_out=getNextIO())) 
	{	bu_error(A0, "pipe/2: cannot find free I/O descriptor");
		return(FAIL);
	}

	piped(io_out)   = pipe_ptr;
	th_id(io_out)   = NULL;
	suspnd(io_out)  = AsUnb(0);
	io_type(io_out) = OUT_PIPE;
	ended(io_out)   = FALSE;

	if (!(io_in=getNextIO())) 
	{	bu_error(A1, "pipe/2: cannot find free I/O descriptor");
		return(FAIL);
	}

	piped(io_in)    = pipe_ptr;
	th_id(io_in)    = NULL;
	suspnd(io_in)   = AsUnb(0);
	io_type(io_in)  = IN_PIPE;
	ended(io_in)    = FALSE;

	pipe_ptr->look_ptr  = block;
	pipe_ptr->read_ptr  = block;
	pipe_ptr->write_ptr = block;
	pipe_ptr->iport     = io_in;
	pipe_ptr->oport     = io_out;
	pipe_ptr->start     = block;
	pipe_ptr->end       = block + PIPESIZE;
	pipe_ptr->status    = P_EMPTY;

	HP = m_ht->m_top;
	out = HP;
	*HP++ = funct_port;
	*HP++ = ToShort(io_out - io);
	in = HP;
	*HP++ = funct_port;
	*HP++ = ToShort(io_in - io);
	m_ht->m_top = HP;

	return( unify(A0, AsStruct(out)) && unify(A1, AsStruct(in)) );
}


c_close_port(Args)
Word	*Args;
{
	Word	port;
	iopo	io_ptr;
	pipepo	pipe_ptr;

	wait_for_argument(A0);
	if (!IsStruct(A0) || *StructVal(A0) != funct_port)
	{	bu_error(A0, "close_port/1: arg incorrect");
		return(FAIL);
	}

	port = *(StructVal(A0) + 1);
	deref(port);
	if (!IsShort(port)) 
	{	bu_error(A0, "close_port/1: arg incorrect");
		return(FAIL);
	}

	io_ptr = io + ShortVal(port);

	if (!is_pipe(io_ptr))
	{	bu_error(A0, "close_port/1: arg not a port");
		return(FAIL);
	}

	pipe_ptr = piped(io_ptr);

	if (pipe_ptr->status & P_LOCK)
	{	VarTbl[Nsuspv++] = ToRef(&suspnd(io_ptr));
		return(SUSPEND);
	}

	if (io_type(io_ptr) == IN_PIPE) {
		if (pipe_ptr->status & P_RSUSP)
		{	bu_error(A0, "close_port/1: port has a suspended read");
			return(FAIL);
		}
		if (!pipe_ptr->oport)
			free((char *)pipe_ptr);
		else pipe_ptr->iport = NULL;
	}
	else if (io_type(io_ptr) == OUT_PIPE) {
		if (pipe_ptr->status & P_WSUSP)
		{	bu_error(A0, "close_port/1: port has a suspended write");
			return(FAIL);
		}
		if (pipe_ptr->status & P_RSUSP)
		{	if (h_debug)
				fprintf(user_error,
				"[ wake reader on port(%d) ]\n", pipe_ptr->iport - io);
			h_deadlock = 0;
			if (th_id(pipe_ptr->iport) == parlog_th)
			{	wait_pipe--;
				assign(ToRef(&suspnd(pipe_ptr->iport)), AsUnb(0));
			}
			else
				(void) add_to_runq(th_id(pipe_ptr->iport), FALSE);
			pipe_ptr->status &= ~P_RSUSP;
		}
		if (!pipe_ptr->iport) {
			free((char *)pipe_ptr->start);
			free((char *)pipe_ptr);
		}
		else pipe_ptr->oport = NULL;
	}

	io_type(io_ptr) = CLOSED;
	if (io_ptr < next_io)
		next_io = io_ptr;
	return(SUCCESS);
}


c_release_port(Args)
Word	*Args;
{
	Word	port;
	iopo	io_ptr;
	pipepo	pipe_ptr;

	wait_for_argument(A0);
	if (!IsStruct(A0) || *StructVal(A0) != funct_port)
	{	bu_error(A0, "release_port/1: arg incorrect");
		return(FAIL);
	}

	port = *(StructVal(A0) + 1);
	deref(port);
	if (!IsShort(port)) 
	{	bu_error(A0, "release_port/1: arg incorrect");
		return(FAIL);
	}

	io_ptr = io + ShortVal(port);

	if (!is_pipe(io_ptr))
	{	bu_error(A0, "release_port/1: arg not a port");
		return(FAIL);
	}

	if (th_id(io_ptr) && th_id(io_ptr) != TH)
	{	bu_error(A0, "release_port/1: not owner of port");
		return(FAIL);
	}

	pipe_ptr = piped(io_ptr);

	if (pipe_ptr->status & P_LOCK)
	{	VarTbl[Nsuspv++] = ToRef(&suspnd(io_ptr));
		return(SUSPEND);
	}

	th_id(io_ptr) = NULL;
	return(SUCCESS);
}

parlog_assign(Addr)
Word	*Addr;
{
	assign(ToRef(Addr), AsUnb(0));
}

c_timeslice(Args)
Word	*Args;
{
	wait_for_argument(A0);
	if (!IsShort(A0)) 
		return(FAIL);

	timeslice(ShortVal(A0));
	return(SUCCESS);
}

c_set_port(Args)
Word	*Args;
{
	wait_for_argument(A0);
	wait_for_argument(A1);
	if (!IsShort(A0) || !IsShort(A1)) 
		return(FAIL);

	ports[ShortVal(A0)] = ShortVal(A1);
	return(SUCCESS);
}

c_get_port(Args)
Word	*Args;
{
	wait_for_argument(A0);
	if (!IsShort(A0)) 
		return(FAIL);

	return( unify(A1, AsShort(ports[ShortVal(A0)])) );
}
