/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  the instruction set
 *
 *	instruction	assigned
 *	groupings	numbers
 *	------------	-------
 *	halt		 0
 *	get		 1-10
 *	wait		11-20
 *	put		21-30
 *	push		31-40
 *	write		41-45
 *	read		46-50
 *	control		51-70
 *	builtins	71-84
 *	enter		85-89
 */

#define	halt		 0

#define	get_x_variable	 1
#define	get_x_value	 2
#define	get_y_variable	 3
#define	get_y_value	 4
#define get_constant	 5
#define	get_nil		 6
#define	get_list_var_var 7
#define get_list_var_val 8
#define	get_list_val_var 9
#define	get_list_val_val 10

#define	wait_x_value	 11
#define wait_constant	 12
#define	wait_nil	 13
#define wait_structure	 14
#define	wait_list	 15
#define	wait_variable	 16
#define	wait_2_variables 17

#define put_x_variable	 21
#define put_x_value	 22
#define put_y_variable	 23
#define put_y_value	 24
#define put_constant	 25
#define put_nil		 26
#define put_structure	 27
#define put_list	 28

#define push_x_variable	 31
#define push_x_value	 32
#define push_y_variable	 33
#define push_y_value	 34
#define push_constant	 35
#define push_nil	 36
#define push_structure	 37
#define push_list	 38

#define write_x_variable 41
#define write_x_value	 42
#define write_constant	 43
#define write_nil	 44
#define write_void	 45

#define read_x_variable	 46
#define read_x_value	 47
#define read_constant	 48
#define read_nil	 49
#define read_void	 50

#define call		 51
#define call_last	 52
#define call_promoted	 53
#define call_promoted_last 54
#define process_switch	 55
#define proceed		 56
#define try		 57
#define trust		 58
#define otherwise	 59
#define	otherwise_restore 60
#define	begin_guard	 61
#define	end_guard	 62
#define commit		 63
#define fail		 64

#define allocate	 65
#define deallocate	 66

#define switch_on_term	 67
#define wait_switch_on_term 68

#define builtin_o	 71
#define builtin_i	 72
#define builtin_io	 73
#define builtin_ii	 74
#define builtin_nn	 75
#define	builtin_ioo	 76
#define	builtin_iio	 77
#define function_n	 78
#define function_nn	 79
#define increment	 80
#define decrement	 81
#define suspend_function 82

#define enter_c		 85
#define enter_io_c	 86
#define enter_interpret	 87
#define enter_trace	 88
#define enter_undefined	 89
