/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  mem structure
 *  n.b. total size should be a multiple of pagesize
 */
typedef	struct	mem	Mem;

struct	mem
{	short	m_type;		/*  segment type	*/
	short	m_prno;		/*  segment owner	*/
	Mem	*m_prev;	/*  previous segment	*/
	Mem	*m_next;	/*  next segment	*/
	Word	*m_top;		/*  top-of-seg ptr	*/
	Word	m_data[16000];	/*  the segment		*/
	Word	m_ovflw[380];	/*  spare tank		*/
};


/*  segment types  */
#define	M_CODE		0	/*  code/symbols area	*/
#define	M_PROC		1	/*  process area	*/
#define	M_STACK		2	/*  2,3 = stack spaces	*/
#define	M_HEAP		4	/*  4,5 = heap spaces	*/

#define	MNULL	(Mem *) 0
#define	addr_to_segment(x)	((Mem *)((int)(x) & ~(sizeof(Mem)-1)))

#define ProcessPtr(x)	(addr_to_segment(x)->m_type == M_PROC)
#define StackPtr(x)	(addr_to_segment(x)->m_type & M_STACK)
#define	HeapPtr(x)	(addr_to_segment(x)->m_type & M_HEAP)
#define	OldHeapPtr(x)	(addr_to_segment(x)->m_type == M_HEAP + oldh_gen)
#define HeapToPR(x)	(Pr0 + addr_to_segment(x)->m_prno)

#define InCurrHeapSeg(var)	(((int)var  & (int)m_ht) == (int)m_ht)
#define InCurrProcSeg(proc)	(((int)proc & (int)m_pt) == (int)m_pt)

#define	alloc_code_segment()	alloc_segment(M_CODE, MNULL)
#define alloc_proc_segment()	alloc_segment(M_PROC, m_pt)
#define alloc_stack_segment()	alloc_segment(M_STACK + s_gen, m_st)
#define alloc_heap_segment()	alloc_segment(M_HEAP + h_gen, m_ht)

#define alloc_new_proc_segment()    alloc_segment(M_PROC, MNULL)
#define alloc_new_stack_segment() \
		(s_gen = 1 - s_gen, alloc_segment(M_STACK + s_gen, MNULL))
#define alloc_new_heap_segment() \
		(h_gen = 1 - h_gen, alloc_segment(M_HEAP + h_gen, MNULL))

#define request_stack_segments(n)   request_segments(n, M_STACK + s_gen, m_st)
#define request_heap_segments(n)    request_segments(n, M_HEAP + h_gen, m_ht)



extern	Mem	**mem_free;		/*  global free memory ptr   */
extern	int	*mem_nfree;		/*  no. global free segments */
extern	Mem	*m_free;		/*  local mem freelist ptr   */
extern	int	m_nfree;		/*  no. local free segments  */

extern	Mem	*m_hb, *m_sb, *m_pb;	/*  ptrs to bottom segments  */
extern	Mem	*m_ht, *m_st, *m_pt;	/*  ptrs to top segments     */

extern	int	h_gen, s_gen;		/*  g.c. "generation" no.s   */


extern	Mem	*alloc_segment(), *get_new_segments(), *request_segments();
extern	char	*extend_shmem();
