/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  SHMEM.C  --  dummy routines to setup up "shared" memory and locks
 *		 for uniprocessor version
 */
#include <stdio.h>
#include <sysexits.h>


/*
 *  init_shmem  --  allocate nbytes of (contiguous) memory,
 *		    on the specified alignment boundary.
 */
char	*
init_shmem(nbytes, align)
int	nbytes, align;
{
	char	*memp;
	char	*memalign();

	memp = memalign((unsigned)align, (unsigned)nbytes);
	if (memp == NULL)
		err(EX_DATAERR, "can't allocate \"shared\" memory\n");
/* 7/1/92 dac begin */
	/* needed in ICP because Parlog is not
	   always initialised at the start */
	(void) memset(memp, 0, nbytes);
/* 7/1/92 dac end */

	return(memp);
}


/*
 *  extend_shmem  --  allocate a further nbytes of (contiguous) memory,
 *		      on the specified alignment boundary.
 */
char	*
extend_shmem(nbytes, align)
int	nbytes, align;
{
	char	*memp;
	char	*memalign();

	memp = memalign((unsigned)align, (unsigned)nbytes);
	if (memp == NULL)
		err(EX_DATAERR, "can't extend \"shared\" memory\n");

	return(memp);
}


/*
 *  init_locks  --  allocate n "locks"
 *		    returns a pointer to the start of the locks
 */
char	*
init_locks(nlocks)
int	nlocks;
{
	char	*lckp;
	char	*malloc();
	int	i;

	lckp = malloc((unsigned)nlocks);

	if (lckp == NULL)
		err(EX_DATAERR, "too many locks requested\n");

	/*
	 *  initialise (unlock) all locks
	 */
	for (i=0; i < nlocks; i++)
		lckp[i] = 0;

	return(lckp);
}
