/* Copyright (C) 1992 Imperial College */
#include "primitives.h"

#define foreign_out_integer(integerval, Nreg, arg, orig_arg) { \
	arg = &A[orig_arg]; \
	delnk(arg); \
	if (IsVar(arg)) { \
		mkreset(arg); \
		mkint(arg, integerval); \
	} else if (NotInt(arg) || (intvl(arg) != integerval)) \
		return(FAIL); \
}

#define foreign_out_float(floatval, Nreg, arg, orig_arg) { \
	arg = &A[orig_arg]; \
	delnk(arg); \
	if (IsVar(arg)) { \
		if (gc_test(4, Nreg)) { \
			arg = &A[orig_arg]; \
			delnk(arg); \
		} \
		mkreset(arg); \
		alloc_float(arg, floatval); \
	} else if (NotFloat(arg) || (floatvl(arg) != floatval)) \
		return(FAIL); \
}

#define foreign_out_atom(cstring, Nreg, arg, orig_arg) { \
	arg = &A[orig_arg]; \
	delnk(arg); \
	if (IsVar(arg)) \
		(void) bind_symbol(orig_arg, cstring, Nreg); \
	else if (NotSymb(arg) || strcmp(string_val(arg), cstring)) \
		return(FAIL); \
}
