/* Copyright (C) 1992 Imperial College */
/*
 *   A fdynamic or dynamic instruction occupies 8 code cells, from
 *   PC to PC+7.  The structure is as follows :
 *
 *      PC      PC+1      PC+2  PC+3        PC+4 PC+5         PC+6 PC+7
 *   fdynamic   arity    (next clause)   (time of birth)   (time of death)
 */

#define nextcl(P)	( *( fourBytes *)(P + 2) )
#define birth(P)	( *(ufourBytes *)(P + 4) )
#define death(P)	( *(ufourBytes *)(P + 6) )

#define live(cl, CLK)	( CLK > birth(cl) && CLK <= death(cl) )

#define findNext(clause, CLK) {			\
		if (nextcl(clause)) {		\
		    clause += nextcl(clause);	\
		    findFirst(clause, CLK);	\
		}				\
		else clause = NULL;		\
	}


#define	findFirst(clause, CLK) {				\
		while (!live(clause, CLK) && nextcl(clause))	\
		    clause += nextcl(clause);			\
		if (!live(clause, CLK))				\
		    clause = NULL;				\
	}

#define MAXDEATH	0xFFFFFFFFL

extern ufourBytes	C;
