/* Copyright (C) 1992 Imperial College */

#include <pwd.h>
#include <sys/stat.h>
#include <strings.h>
#include "icp.h"

#ifdef THINK_C
#define SRCDIR		":source:"
#else
#define SEP		":"
#define PROLOGDIR	"/prolog/"
#define SRCDIR		"source"
#define HERMESDIR	"/parlog/system/hermes"
#endif

extern char	*getenv();
extern strpo	*str_get_prop();

static char	*ic_inst_path=NULL, *ic_user_path=NULL;

static int	prolog_booted	= FALSE;
int		path_updated	= TRUE;


update_directories()
{
	char *pt;
	unsigned len;

	if (ic_user_path)
		free(ic_user_path);

	/* user path */
	if (pt = getenv("ICP_PATH")) {
		len = strlen(pt);
		ic_user_path = malloc(len+1);
		(void) strcpy(ic_user_path, pt);
	} else {
		ic_user_path = malloc(2);
		(void) strcpy(ic_user_path, ".");
	}

	path_updated = FALSE;
	if (prolog_booted)
		set_prolog_path();
}

void initialise_directories()
{
	char *install;
	unsigned len;

	if (!(install = getenv("ICP_INSTALLDIR"))) {
		(void) fprintf(stderr, "icp: please set ICP_INSTALLDIR\n");
		icp_exit(1);
	}

	update_directories();

	/* builtin path */
	len = 3 * strlen(install) + 3 * strlen(SEP) + 2 * strlen(PROLOGDIR)
		+ strlen(ARCH) + strlen(SRCDIR)
		+ strlen(HERMESDIR);
	ic_inst_path = malloc(len);
	(void) strcat(ic_inst_path, SEP);
	(void) strcat(ic_inst_path, install);
	(void) strcat(ic_inst_path, PROLOGDIR);
	(void) strcat(ic_inst_path, ARCH);
	(void) strcat(ic_inst_path, SEP);
	(void) strcat(ic_inst_path, install);
	(void) strcat(ic_inst_path, PROLOGDIR);
	(void) strcat(ic_inst_path, SRCDIR);
	(void) strcat(ic_inst_path, SEP);
	(void) strcat(ic_inst_path, install);
	(void) strcat(ic_inst_path, HERMESDIR);
/*
	(void) fprintf(stderr, "icp: search path is %s:%s\n", ic_user_path, ic_inst_path);
*/
}



char *
interpret_home(name, full_name)
char *name, *full_name;
{
	char *pt, *user, *start;

	pt = full_name;

	if (*name == '~') {
		struct passwd *pwd;

		name++;
		if ((*name == '/') || (*name == '\0')) {
			if ((start = getenv("HOME")) != NULL)
				while (*pt = *start++)
					pt++;
		}
		else {
			if ((user = index(name, '/')) != NULL)
				*user = '\0';
			pwd = getpwnam(name);
			if (user != NULL) {
				*user = '/';
				name = user;
			}
			else name += strlen(name);

			if (pwd != NULL) {
				start = pwd->pw_dir;
				while (*pt = *start++)
					pt++;
			}
		}
	}
	else if (*name == '.') {
		if (*(name+1) == '/' || *(name+1)== '\0') {
			(void) getwd(full_name);
			name++;
			pt = full_name + strlen(full_name);
		}
		else if (*(name+1) == '.' &&
			(*(name+2) == '/' || *(name+2)== '\0')) {
			(void) getwd(full_name);
			do {
				pt = rindex(full_name, '/');
				if (pt == full_name+1) {
					if (*(pt+1) != '\0')
						*(++pt) = '\0';
				}
				else *pt = '\0';
				name += 2;
				if (*name == '\0')
					return(pt);
				else name++;
			} while (*name == '.' && *(name+1) == '.' &&
				 (*(name+2) == '/' || *(name+2)== '\0'));
			name--;
		}
	}

	start = name;
	while (*pt = *start++)
		pt++;
	return(pt);
}

static int stat_from_delimited(name, path, full_name, buf)
char *name, *path, *full_name;
struct stat *buf;
{
	char *pt, *start, *end;

	if (path == NULL)
		return(FALSE);

	while (*path) {
		if ((end = index(path, ':')) != NULL)
			*end = '\0';
		(void) interpret_home(path, full_name);
		pt = full_name + strlen(full_name);
		if (end) {
			*end = ':';
			path = end+1;
		}
		else path += strlen(path);

		if (pt == full_name || (pt > full_name && *(pt - 1) != '/'))
			*pt++ = '/';
		start = name;
		while (*pt = *start++)
			pt++;
		if (!stat(full_name, buf))
			return(TRUE);
	}
	return(FALSE);
}

int ic_file_name_stats(name, full_name, file_exists, buf)
char *name, *full_name;
int file_exists;
struct stat *buf;
{
	register char *pt, *start;
	strpo *names;

	/* interpret shorthand for home directory */
	(void) interpret_home(name, full_name);

	if (!file_exists)	/* we are in write mode */
		return(TRUE);

	/* do not use ICP_PATH if there is a '/' in the name already */
	if (index(full_name, '/')) {
		if (!stat(full_name, buf))
			return(TRUE);
		else
			return(FALSE);
	}

	if (path_updated)
		update_directories();

	/* (we are in read mode) search in ICP_PATH */
	if (prolog_booted && (names = str_get_prop("$prolog$", "$icp_path$"))) {
		int i, ret=FALSE;
		strpo path;
		for (i=0; path=names[i]; i++) {
			pt = interpret_home(path, full_name);
			if (pt == full_name || (pt > full_name && *(pt - 1) != '/'))
				*pt++ = '/';
			start = name;
			while (*pt = *start++)
				pt++;
			(void) free((char*) names[i]);
			if (!stat(full_name, buf)) {
				ret = TRUE;
				break;
			}
		}
		while (names[i])
			(void) free(names[i++]);
		(void) free((char *) names);
		if (ret)
			return(ret);
	} else if (stat_from_delimited(name, ic_user_path, full_name, buf))
		return(TRUE);

	/* try system paths */
	return(stat_from_delimited(name, ic_inst_path, full_name, buf));
}

int ic_file_name(name, full_name, file_exists)
char *name, *full_name;
int file_exists;
{
	struct stat buf;

	return(ic_file_name_stats(name, full_name, file_exists, &buf));
}

FILE *open_ic_file(name, mode, file_exists)
strpo name;
char *mode;
int file_exists;
{
	char full_name[MAXFILENAME];
	FILE *fp = NULL;

	if (ic_file_name(name, full_name, file_exists))
		fp = fopen(full_name, mode);

	return(fp);
}

set_prolog_path()
{
	char **argv_path, *end, *pt;
	int len, i;

	pt = ic_user_path;

	/* calculate length */
	for (len=0, pt=ic_user_path; pt = index(pt, ':'); len++)
		pt++;

	argv_path = (char **) malloc((unsigned) (len+2) * sizeof(pt));
	/* store */
	for (i=0, pt=ic_user_path; end = index(pt, ':'); pt=end) {
		argv_path[i++] = pt;
		*end++ = '\0';
	}
	if (*pt)
		argv_path[i++] = pt;
	argv_path[i] = NULL;

	set_str_prop("$prolog$", "$icp_path$", argv_path);
	for (i = 0; i < len; i++)
		*(argv_path[i]+strlen(argv_path[i])) = ':';
	(void) free((char *) argv_path);
	prolog_booted = TRUE;
}
