/* Copyright (C) 1992 Imperial College */
/*	*******************************************************************
 *
 * 		The code has to be compiled with  -Bstatic  option
 *
 *	*******************************************************************/
#ifdef GNUDOS
#include <aout.h>
#else
#include <a.out.h>
#endif
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/param.h>

#include "primitives.h"
#include "foreign.h"
#include "symtab.h"

#define SIZE_NAME		256

#define MAX_PRIMITIV		1024
#define MAX_C_FUNCT		256
#define COMMAND_LINE_SIZE	1024
#define TMP_FILENAMELEN		22
#ifdef GNUDOS
#define TMP_FILE		"/tmp/icpsymta.XXX"
#else
#define TMP_FILE		"/tmp/icpsymtabXXXXXX"
#endif
#ifdef GNUDOS
#define SIGVTALRM	SIGFPE
#endif

extern int	debugLevel;	/* for setting granularity of trace */
extern int	signal_mask;

extern caddr_t sbrk();
extern void icp_exit();
extern char *getwd();
extern symbpo define_symbol();

#define round(x,s)	((((x)-1)&~((s)-1))+(s))
#define froundup(x,l)	(((x-1)|(l-1))+1)

#define shift_prim_tabl(pt)   { bcopy((char *) &prim_tabl[(pt)],(char *) &prim_tabl[(pt)+1],(prim_tabl_size-(pt))*sizeof(struct prim *)); \
				++prim_tabl_size; }

#define free_prim_struct(pt)	if ((char *)(pt)) free((char *)(pt))

/* name of program */
char			*basefile;
struct prim {
	strpo		name;
	funct_ptr	function; } ;

static struct prim	*prim_tabl[MAX_PRIMITIV];
static int 		prim_tabl_size = 0;

/*
 *	initialise_load_foreign(name)
 *
 *	name is the name of the emulator
 */
initialise_load_foreign(name)
char *name;
{
	uchar	pt[MAXPATHLEN];

	if (strchr(name, '/'))
		basefile = name;
	else {
		if (!getwd(pt)) {
			(void) fprintf(stderr, "{Warning: getwd failed (%s)}\n", pt);
			(void) strcpy(pt, ".");
		}
		basefile = malloc((unsigned)(strlen(pt)+strlen(name)+2));
		(void) strcpy(basefile, pt);
		(void) strcat(basefile, "/");
		(void) strcat(basefile, name);
	}
	prim_tabl_size = 0;
}

/*
 *	free_prim_tabl()
 *
 *	free the primitive table old values
 */
free_prim_tabl()
{
	struct prim **ptr;

	for (ptr = &prim_tabl[prim_tabl_size-1]; ptr >=  prim_tabl; --ptr)
		free_prim_struct(*ptr);
	prim_tabl_size = 0;
}

funct_ptr search_foreign(name, arit)
symbpo	name;
int	arit;
{
	strpo ptr, ptr1;
	int cmp, len;
	int sup = prim_tabl_size-1, inf = 0, med;
	uchar prim_name[SIZE_NAME];

#ifdef DEBUG
	debug(1, fprintf(stderr, "{searching foreign table for ");
		 printName(name, stderr);
		 (void) fprintf(stderr, "/%d}\n", arit));
#endif

	ptr = symbname(name);
	len = symblngth(name);
	ptr1 = prim_name;
	while (len--)
		*ptr1++ = *ptr++;
	(void) sprintf(ptr1, "%d", arit);

	while (sup >= inf) {
		med = (sup + inf) / 2;
		if (!(cmp = strcmp(prim_name, prim_tabl[med]->name)))
			return(prim_tabl[med]->function);
		else if (cmp > 0)
			inf = med + 1;
		else 
			sup = med - 1;
		}
	return((funct_ptr)NULL);
}

static struct prim *alloc_prim_struct(name, function)
strpo name;
funct_ptr function;
{
	struct prim *ptr;

	ptr = (struct prim *)malloc(sizeof(struct prim));
	ptr->name = name;
	ptr->function = function;
	return(ptr);
}

insert_primitive(prim_name, function)
strpo prim_name;
funct_ptr function;
{
	int sup = prim_tabl_size-1, inf = 0, med;
	int cmp;

	if (sup < inf) {
		prim_tabl[prim_tabl_size++] = alloc_prim_struct(prim_name, function);
		return; }
	cmp = strcmp(prim_name, prim_tabl[inf]->name);
	if (cmp == 0)
		return;
	else if (cmp < 0) {
		shift_prim_tabl(inf);
		prim_tabl[inf] = alloc_prim_struct(prim_name, function);
		return; }
	cmp = strcmp(prim_name, prim_tabl[sup]->name);
	if (cmp == 0)
		return;
	else if (cmp > 0) {
		prim_tabl[prim_tabl_size++] = alloc_prim_struct(prim_name, function);
		return; }
	while (sup >= inf) {
		med = (sup + inf) / 2;
		cmp = strcmp(prim_name, prim_tabl[med]->name);
		if (cmp == 0)
			return;
		else if (cmp > 0)
			inf = med + 1;
		else 
			sup = med - 1;
		}
	if (cmp < 1) {
		shift_prim_tabl(med);
		prim_tabl[med] = alloc_prim_struct(prim_name, function);
		return; }
	else {
		++med;
		shift_prim_tabl(med);
		prim_tabl[med] = alloc_prim_struct(prim_name, function);
		return; }
}

static char *c_function_name(prim_name)
cellpo prim_name;
/*
 *  prim_name must be in the following format:		name/arity
 *  and will be created another name as follow:		_name
 */
{
	strpo ptr1, ptr, c_name;
	unsigned  len;

	delnk(prim_name);
	ptr = string_val(prim_name);
	len = string_len(prim_name);
	c_name = ptr1 = (strpo) malloc(len+2);
	*ptr1++ = '_';
	while (len--)
		*ptr1++ = *ptr++;
	*ptr1 = '\0';
	return((char *)c_name);
}

strpo make_prolog_name(name, arit)
cellpo name, arit;
{
	strpo ptr1, ptr, c_name;
	unsigned  len;

	delnk(name);
	delnk(arit);

	ptr = string_val(name);
	len = string_len(name);
	c_name = ptr1 = (strpo) malloc(len+3);
	while (len--)
		*ptr1++ = *ptr++;
	(void) sprintf(ptr1, "%d", intvl(arit));
	return(c_name);
}

static char *getspace(nitems)
int nitems;
{
	register char *ptr;

	nitems = froundup(nitems, 512);
	if (! (ptr = (char *)sbrk(nitems))) {
		(void) fprintf(stderr, "ERROR: no space available\n");
		icp_exit(1); }
	bzero(ptr, nitems);
	return(ptr);
}

static strpo get_foreign_lib_args(lib_list)
cellpo lib_list;
{
	strpo result, lib_arg, pt;
	uchar file[MAXFILENAME];
	int len = 0;
	cellpo el;

	pt = result = (strpo) malloc(COMMAND_LINE_SIZE/2);

	while (IsList(lib_list)) {
		el = hd(lib_list);
		delnk(el);
		if (NotSymb(el))
			break;
		lib_arg = string_val(el);
		if (*lib_arg == '-') {		 /* ld argument */
			while (*pt = *lib_arg++) {
				pt++;
				if (++len >= COMMAND_LINE_SIZE/2) {
					free(result);
					return(NULL);
				}
			}
			*pt++ = ' ';
		} else if (ic_file_name(lib_arg, file, TRUE)) {
			lib_arg = file;
			while (*pt = *lib_arg++) {
				pt++;
				if (++len >= COMMAND_LINE_SIZE/2) {
					free(result);
					return(NULL);
				}
			}
			*pt++ = ' ';
		} else {
			(void) fprintf(stderr, "{bad foreign library argument : %s}\n",
			lib_arg);
			break;
		}
		lib_list = tl(lib_list);
		delnk(lib_list);
	}
	*pt = '\0';
	if (NotNil(lib_list)) {
		free(result);
		return(NULL);
	}
	return(result);
}

/*
 * load_foreign(obj_file, [pred1/ar1, pred2/ar2=Cname, ...], [lib1, lib2, ..])
 */

bool
pr_load_foreign()
{
	register cellpo	arg1 = &A[1],
			arg2 = &A[2],
			arg3 = &A[3],
			el;

	char *mktemp();

	uchar tmp_file[TMP_FILENAMELEN], file[MAXFILENAME], command[COMMAND_LINE_SIZE];
	strpo lib_args;
	char *br;
	int fd;
	int readsize, total;
	struct exec header;
	int old_mask;

	strpo ref_tabl[MAX_C_FUNCT];
	struct nlist nl[MAX_C_FUNCT];
	int nlptr = 0, i;

	delnk(arg1);
	delnk(arg2);
	delnk(arg3);

	if (NotSymb(arg1))
		return(FAIL);
	if (NotList(arg3) && NotNil(arg3))
		return(FAIL);

	if (!ic_file_name(string_val(arg1), file, TRUE)) {
		(void) fprintf(stderr, "ERROR: object file %s not found in search path\n",
				string_val(arg1));
		return(FAIL);
	}
	if (!(lib_args = get_foreign_lib_args(arg3))) {
		(void) fprintf(stderr, "ERROR: cannot load libraries\n");
		return(FAIL);
	}
	(void) fprintf(stderr, "\n{ loading foreign from %s %s}\n", file, lib_args);
	while (IsList(arg2)) {
		el = hd(arg2);
		delnk(el);
		if (IsTpl(el) && arity(el) == 3) {
			cellpo name, arit;
			dictionary dict;
			name = arg(el,1);
			delnk(name);
			arit = arg(el,2);
			delnk(arit);
			dict = get_entry(define_symbol(string_val(name)),
					(twoBytes) intvl(arit));
			if (dict->type && dict->type != EXTERNAL) {
				(void) fprintf(stderr, "ERROR: cannot redefine %s/%d\n",
					string_val(name), intvl(arit));
				return(FAIL);
			}
			else dict->type = EXTERNAL;
			ref_tabl[nlptr] = make_prolog_name(name, arit);
			nl[nlptr].n_un.n_name = c_function_name(functor(el));
			++nlptr;
			arg2 = tl(arg2);
			delnk(arg2); }
		else
			return(FAIL);
	}
	if (NotNil(arg2))
		return(FAIL);

	nl[nlptr].n_un.n_name = NULL;

	/* switch off interrupts */
	old_mask = sigblock(signal_mask);

	(void) strcpy(tmp_file, TMP_FILE);
	(void) mktemp(tmp_file);
	
	br = (char *)sbrk(0);

/*
 *	basefile must be linked with  -Bstatic  option
 */

	(void) sprintf(command, "ld -N -x -A %s -T %x -o %s %s %s -lc",
			basefile, br, tmp_file, file, lib_args);
	free(lib_args);		/* yac 4/2/92 */

	debug(1, printf("command line: %s\n", command));

	if (system(command)) {
		(void) unlink(tmp_file);
		(void) sigsetmask(old_mask);
		(void) fprintf(stderr, "ERROR: dynamic link command failed\n");
		return(FAIL); }

	if ((fd = open(tmp_file, O_RDONLY)) < 0) {
		(void) sigsetmask(old_mask);
		(void) fprintf(stderr, "ERROR: cannot open %s\n", tmp_file);
		return(FAIL); }
	if (read(fd, (char *)&header, sizeof(header)) != sizeof(header)) {
		(void) close(fd);
		(void) sigsetmask(old_mask);
		(void) fprintf(stderr, "ERROR: cannot read header of %s\n", tmp_file);
		return(FAIL); }
	readsize = round(header.a_text,4) + round(header.a_data,4);
	total = readsize + header.a_bss;
	total = round(total,512);

	br = getspace(total);
	if (read(fd, br, readsize) != readsize) {
		(void) close(fd);
		(void) sigsetmask(old_mask);
		(void) fprintf(stderr, "ERROR: cannot load %s\n", tmp_file);
		return(FAIL); }
	(void) close(fd);

	(void) nlist(tmp_file, nl);

	for (i = 0; i < nlptr; ++i) {
		if (nl[i].n_value) { 
			insert_primitive(ref_tabl[i], (funct_ptr)(nl[i].n_value));

			debug(1, printf("function_c: %s\tfunction prolog: %s\taddress: 0x%lX\n",
			nl[i].n_un.n_name, ref_tabl[i], nl[i].n_value));

			}
		else
			(void) fprintf(stderr,"{Warning: function %s not found}\n", nl[i].n_un.n_name);
		free(nl[i].n_un.n_name);
		}

	(void) unlink(tmp_file);

	/* restore interrupts */
	(void) sigsetmask(old_mask);

	return(SUCCEED);
}

define_C_predicate(name, arit, function)
strpo	name;
int	arit;
funct_ptr function;
{
	char *c_name = malloc((unsigned) strlen(name)+3);

	(void) sprintf(c_name, "%s%d", name, arit);
	insert_primitive(c_name, function);
}

