/* Copyright (C) 1992 Imperial College */
/*
 * Logic and Objects system 
 *
 * Fork - create a new process for executing a thread of execution 
 *
 */
#include "primitives.h"
#include "events.h"

extern threadpo	prolog_th, parlog_th;
extern symbpo	fork_sym, rpc_sym;

extern codepo	search_symbol();

extern fourBytes init_heapsize, init_stacksize;

#ifdef HERMES
extern	int	x_parlog;
int	jam_argc = 2;
/* allow up to 10 arguments */
char	*jam_argv[12] =	{	"jam",
				"hermes_boot.o",
				NULL, NULL, NULL, NULL, NULL,
				NULL, NULL, NULL, NULL, NULL
			};
bool	prolog_console_suspended = FALSE;
#endif

/*
 * reserve space at end of heap for handling interrupts
 * and unexpected overflow during pipe reads etc.
 */
#define SAFETY_BUFFER	400

threadpo 
newthread(heapsize, stacksize)
    fourBytes	heapsize, stacksize;
{
    threadpo	block;
    fourBytes	cells = heapsize + stacksize;

    block = (threadpo) malloc((size_t)(sizeof(struct thread) +
				       cells * sizeof(cell)));
    if (block)
	init_thread(block, cells, heapsize);

    return(block);
}

init_thread(block, cells, heapsize)
    threadpo	block;
    fourBytes	cells, heapsize;
{
    block->prolog = TRUE;
    block->rq = NULL;
    block->CP = NULL;
    block->H = block->stacks;	       		/* initialise the thread to some default values */
    block->HB = block->H;

    /* use a portion of the space for the CTS */
    block->HMAX = &(block->stacks[heapsize-SAFETY_BUFFER]);
    block->CHMAX = block->HMAX;

    block->BLS = &(block->stacks[heapsize]);
    block->B = (choicepo)block->BLS;
    block->SB = block->B;
    block->CSB = block->B;
    block->CATCH = block->B;	/*** HACK : THIS HAS TO BE DONE PROPERLY ***/
    block->GC_B = block->B;
    block->E = (envpo)block->BLS;
    block->CE = block->E;
    block->TR =  &(block->stacks[cells]);	/* the trail moves down in the space */
    block->stats.starttime = usertime();
    block->stats.lasttime = block->stats.starttime;
    block->stats.gc_time = 0;
    block->stats.gc_acc = 0;
    block->stats.gc_count = 0;
    block->current_input = &io[0];	/* stdin */
    block->current_output = &io[1];	/* stdout */
    block->TSZ = cells;

    
    block->B->H = block->H;
    block->B->TR = block->TR;
    block->B->E = NULL;
    block->B->AX = 0;

    {
	register cellpo Ai = block->A;
	register int i;
	for (i = REGISTERS; i--;) {
	    mknil(Ai);
	    Ai++;
	}
    }
}

bool
pr_new_thread()
{
    cellpo	new_th = &A[1];
    threadpo	th;

    delnk(new_th);
    if (NotVar(new_th))
	throw(209);
    if (!(th=newthread(init_heapsize, init_stacksize)))
	throw(610);

    /* link new thread into chain */
    TH->next->prev = th;
    th->next = TH->next;
    TH->next = th;
    th->prev = TH;

    mkreset(new_th);
    mkint(new_th, th);
    return(SUCCEED);
}

bool
pr_init_parlog()
{
#ifdef GNUDOS
	return(FAIL);
#else
#ifdef HERMES
    cellpo	reg1 = &A[1];
    int		x_windows, status;

    if (prolog_console_suspended) {	/* resuming prolog console */
	prolog_console_suspended = FALSE;
	return(SUCCEED);
    }

    if (TH != prolog_th)
	throw(412);

    delnk(reg1);
    if (NotInt(reg1))
	throw(210);

    x_windows = intvl(reg1);
    if (x_windows && parlog_th)
	throw(410);

    if (!parlog_th) {
	if (!(parlog_th=(threadpo) malloc(sizeof(struct thread))))
	    throw(613);

	parlog_th->prolog = FALSE;
	parlog_th->rq = NULL;

	/* link new thread into chain */
	TH->prev->next = parlog_th;
	parlog_th->prev = TH->prev;
	parlog_th->next = TH;
	TH->prev = parlog_th;
	(void) add_to_runq(parlog_th, TRUE);	/* add to run queue */

	(void) fprintf(stderr, "\nstarting Parlog ...\n");
	x_parlog = x_windows;
	status = jam(jam_argc, jam_argv);
	if (status == SUSPEND)
	    prolog_console_suspended = TRUE;
	return(status);
    }
    else if (!x_parlog) {
	prolog_console_suspended = TRUE;
	(void) fprintf(stderr, "\n[ switching to Parlog console ]\n");
	parlog_assign(&suspnd(io));
	return(SUSPEND);
    }
    else
	throw(412);
#endif
    fprintf(stderr, "Parlog not available\n");
    return(SUCCEED);
#endif GNUDOS
}

/* A[1] is assumed to be a variable */
bool
pr_thread()
{
    register
    cellpo	th = &A[1];

    delnk(th);
    mkreset(th);
    mkint(th, TH);
    return(SUCCEED);
}

bool
pr_kill_thread()
{
    register
    threadpo	th;
    cellpo	reg1 = &A[1];

    delnk(reg1);
    th = (threadpo)intvl(reg1);
    
    /* DO NOT change this - prolog_th should never be removed */
    if (th == prolog_th)
	return(SUCCEED);

    /* unlink this thread from the chain */
    th->prev->next = th->next;
    th->next->prev = th->prev;
    if (TH == th)
	TH = 0;

    /* HACK : should do some cleaning up of I/O channels here */

    (void) remove_from_runq(th);

    free((char *)th);
    return(SUCCEED);
}

bool
pr_fork()
{
    register
    threadpo	th;
    cellpo	reg1	= &A[1];
    cellpo	in	= &A[2];

    delnk(reg1);
    delnk(in);

    th = (threadpo)intvl(reg1);
    th->current_input = io + intvl(in);
    th->P = search_symbol(fork_sym, 0);
    (void) add_to_runq(th, TRUE);
    return(SUCCEED);
}

save_thread(th)
threadpo th;
{
    register
    cellpo	reg;
    short	count;

    th->P     = sP;
    th->CP    = CP;
    th->H     = H;
    th->HB    = HB;
    th->HMAX  = HMAX;
    th->CHMAX = CHMAX;
    th->BLS   = BLS;
    th->B     = B;
    th->SB    = SB;
    th->CSB   = CSB;
    th->GC_B  = GC_B;
    th->CATCH = CATCH;
    th->E     = E;
    th->CE    = CE;
    th->TR    = TR;

    reg = th->A;
    for (count=0; count < REGISTERS; count++)
	*reg++ = A[count];

    th->current_input = current_input;
    th->current_output = current_output;
}

load_thread(th)
threadpo th;
{
    /* copy out the thread's arguments */
    TH    = th        ;
    CP    = TH->CP    ;		/* continuation program counter */
    H     = TH->H     ;		/* top of heap */
    HB    = TH->HB    ;		/* heap back point */
    HMAX  = TH->HMAX  ;		/* pre-allocated heap space */
    CHMAX = TH->CHMAX ;		/* shadow pre-allocated heap space */
    BLS   = TH->BLS   ;		/* bottom of local stack */
    B     = TH->B     ;		/* last choice point */
    SB    = TH->SB    ;		/* where to cut */
    CSB   = TH->CSB   ;		/* continuation cut */
    GC_B  = TH->GC_B  ;		/* last garbage collected choice point */
    CATCH = TH->CATCH ;
    E     = TH->E     ;		/* local environment */
    CE    = TH->CE    ;		/* continuation local environment */
    TR    = TH->TR    ;		/* trail point */
    S     = H         ;		/* structure pointer */

    {
	register int temp;
	for (temp = 0; temp < REGISTERS; temp++)
		A[temp] = TH->A[temp];
    }

    current_input = TH->current_input;
    if (io_type(current_input) == IN_STREAM) {
	if (fdes(current_input) == stdin)
		charin = pr_read_stream0;
	else
		charin = pr_read_stream;
	charback = pr_unread_stream;
    }
    else if (io_type(current_input) == IN_RAM) {
	charin = pr_read_ram;
	charback = pr_unread_ram;
    }

    current_output = TH->current_output;
    if (io_type(current_output) == OUT_STREAM)
	charout = pr_write_stream;
    else if (io_type(current_output) == OUT_RAM)
	charout = pr_write_ram;
}

bool
resume(th, start)
threadpo th;
bool start;
{
	threadpo	check;
	extern runqpt RQ;

	if (th) {		/* check validity */
		check = prolog_th;
		while (check != th && check->next != prolog_th)
			check = check->next;
		if (check != th)
			throw(411);
		(void) add_to_runq(th, start);
	}

	if (RQ->next == RQ && TH == RQ->th)	/* no more in que */
		return(FAIL);

	if (TH && TH != parlog_th)
		save_thread(TH);

	RQ = RQ->next;

	return(SUCCEED);
}
/* A[1] is assumed to be a valid thread or 0 */
bool
pr_resume()
{
    cellpo      th = &A[1];

    delnk(th);
    return(resume((threadpo)intvl(th), FALSE));
}

bool
pr_suspend()
{
    (void) remove_from_runq(TH);
    return(SUCCEED);
}

bool
pr_suspend_th()
{
    cellpo	th = &A[1];

    delnk(th);
    (void) remove_from_runq((threadpo)intvl(th));
    return(SUCCEED);
}

bool
pr_rpc()
{
    register
    threadpo	th;
    cellpo	reg1	= &A[1];
    cellpo	in	= &A[2];
    cellpo	out	= &A[3];

    delnk(reg1);
    delnk(in);
    delnk(out);

    th = (threadpo)intvl(reg1);

    save_thread(TH);
    (void) remove_from_runq(TH);
    th->current_input = io + intvl(in);
    th->current_output = io + intvl(out);
    th->P = search_symbol(rpc_sym, 0);
    (void) add_to_runq(th, TRUE);
    TH = th;
    return(SUCCEED);
}
